/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import ninja.smirking.buycraft.api.BuycraftPayment;

import java.util.List;
import java.util.UUID;

/**
 * Created by Connor on 07/07/2015.
 *
 * @author Connor Spencer Harries
 */
public class ImmutablePayment implements BuycraftPayment {
    private final long time;
    private final String humanTime;
    private final String ign;
    private final UUID uuid;
    private final double price;
    private final String currency;
    private final List<Integer> packages;

    ImmutablePayment(long time, String humanTime, String ign, UUID uuid, double price, String currency, List<Integer> packages) {
        this.time = time;
        this.humanTime = humanTime;
        this.ign = ign;
        this.uuid = uuid;
        this.price = price;
        this.currency = currency;
        this.packages = packages;
    }

    public long getTime() {
        return time;
    }

    public String getHumanTime() {
        return humanTime;
    }

    public String getUsername() {
        return ign;
    }

    public UUID getUniqueId() {
        return uuid;
    }

    public double getPrice() {
        return price;
    }

    public String getCurrency() {
        return currency;
    }

    public List<Integer> getPackages() {
        return packages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ImmutablePayment that = (ImmutablePayment) o;

        if (time != that.time) return false;
        if (Double.compare(that.price, price) != 0) return false;
        if (!humanTime.equals(that.humanTime)) return false;
        if (!ign.equals(that.ign)) return false;
        if (!uuid.equals(that.uuid)) return false;
        if (!currency.equals(that.currency)) return false;
        return packages.equals(that.packages);

    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = (int) (time ^ (time >>> 32));
        result = 31 * result + humanTime.hashCode();
        result = 31 * result + ign.hashCode();
        result = 31 * result + uuid.hashCode();
        temp = Double.doubleToLongBits(price);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        result = 31 * result + currency.hashCode();
        result = 31 * result + packages.hashCode();
        return result;
    }
}
