/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.impl;

import java.util.*;

public class ImmutablePaymentBuilder {
    private final Set<String> setFields;

    private long time = 0L;
    private String humanTime = "";
    private String ign = "";
    private UUID uuid = new UUID(0, 0);
    private double price = 0.00;
    private String currency = "USD";
    private List<Integer> packages = new ArrayList<>();

    private ImmutablePaymentBuilder() {
        this.setFields = new HashSet<>();
    }

    public ImmutablePaymentBuilder setTime(long time) {
        setField("time");
        this.time = time;
        return this;
    }

    public ImmutablePaymentBuilder setHumanTime(String humanTime) {
        setField("humanTime");
        this.humanTime = humanTime;
        return this;
    }

    public ImmutablePaymentBuilder setUsername(String ign) {
        setField("ign");
        this.ign = ign;
        return this;
    }

    public ImmutablePaymentBuilder setUniqueId(UUID uuid) {
        setField("uuid");
        this.uuid = uuid;
        return this;
    }

    public ImmutablePaymentBuilder setPrice(double price) {
        setField("price");
        this.price = price;
        return this;
    }

    public ImmutablePaymentBuilder setCurrency(String currency) {
        setField("currency");
        this.currency = currency;
        return this;
    }

    public ImmutablePaymentBuilder setPackages(List<Integer> packages) {
        setField("packages");
        this.packages = packages;
        return this;
    }

    private void setField(String field) {
        if(setFields.contains(field)) {
            throw new IllegalStateException(String.format("Field '%s' has already been set.", field));
        }
        setFields.add(field);
    }

    public ImmutablePayment build() {
        return new ImmutablePayment(time, humanTime, ign, uuid, price, currency, packages);
    }

    public static ImmutablePaymentBuilder create() {
        return new ImmutablePaymentBuilder();
    }
}