/*
 * Copyright (C) 2015 Connor Spencer Harries
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ninja.smirking.buycraft.serialization;

import com.google.gson.*;
import ninja.smirking.buycraft.api.BuycraftCategory;
import ninja.smirking.buycraft.api.BuycraftCategory.Serialization;
import ninja.smirking.buycraft.impl.ImmutableCategoryBuilder;

import java.lang.reflect.Type;

/**
 * Created by Connor on 07/07/2015.
 *
 * @author Connor Spencer Harries
 */
public class CategoryDeserializer implements JsonDeserializer<BuycraftCategory> {
    @Override
    public BuycraftCategory deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if(!json.isJsonObject()) {
            throw new JsonParseException("Not a JSON object.");
        }

        ImmutableCategoryBuilder builder = ImmutableCategoryBuilder.create();
        JsonObject object = json.getAsJsonObject();

        if(object.has(Serialization.ID)) {
            builder.setId(object.get(Serialization.ID).getAsInt());
        }

        if(object.has(Serialization.NAME)) {
            builder.setName(object.get(Serialization.NAME).getAsString());
        }

        if(object.has(Serialization.DESCRIPTION)) {
            builder.setDescription(object.get(Serialization.DESCRIPTION).getAsString());
        }

        if(object.has(Serialization.ITEM_ID)) {
            builder.setItemId(object.get(Serialization.ITEM_ID).getAsInt());
        }

        return builder.build();
    }
}
