/*
 * Decompiled with CFR 0.152.
 */
package nl.axians.camel.commons.azure.servicebus.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class ServiceHubPropertyExtractor
implements Processor {
    public static final String HEADER_APPLICATION_PROPERTIES = "CamelAzureServiceBusApplicationProperties";
    private final List<String> requiredProperties;

    public ServiceHubPropertyExtractor(List<String> theRequiredProperties) {
        this.requiredProperties = theRequiredProperties != null ? theRequiredProperties : new ArrayList();
    }

    public void process(Exchange exchange) {
        Map applicationProperties = (Map)exchange.getIn().getHeader(HEADER_APPLICATION_PROPERTIES, Map.class);
        if (applicationProperties == null) {
            throw new IllegalStateException("No application properties found in the Azure Service Bus message");
        }
        for (String property : this.requiredProperties) {
            String value = (String)applicationProperties.get(property);
            if (value == null) {
                throw new IllegalStateException("Required application property not found in Azure Service Bus message: " + property);
            }
            exchange.setProperty(property, (Object)value);
        }
    }
}

