/*
 * Decompiled with CFR 0.152.
 */
package nl.axians.camel.datasonnet.springboot;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverters;

public class DataSonnetTypeConverters
implements TypeConverters {
    @Converter
    public static String toString(DefaultDocument<String> theDocument) {
        return (String)theDocument.getContent();
    }

    @Converter
    public static InputStream toInputStream(DefaultDocument<String> theDocument) {
        return new ByteArrayInputStream(((String)theDocument.getContent()).getBytes(StandardCharsets.UTF_8));
    }

    @Converter
    public static DefaultDocument<?> toDefaultDocument(String theContent, Exchange theExchange) {
        String contentType = (String)theExchange.getIn().getHeader("Content-Type", String.class);
        MediaType mediaType = contentType != null && !contentType.isBlank() ? MediaType.valueOf((String)contentType) : MediaTypes.APPLICATION_JSON;
        return new DefaultDocument((Object)theContent, mediaType);
    }

    @Converter
    public static DefaultDocument<?> toDefaultDocument(InputStream theContent, Exchange theExchange) throws IOException {
        return DataSonnetTypeConverters.toDefaultDocument(new String(theContent.readAllBytes(), StandardCharsets.UTF_8), theExchange);
    }
}

