/*
 * Decompiled with CFR 0.152.
 */
package nl.axians.camel.oauth2.springboot;

import nl.axians.camel.oauth2.OAuth2Component;
import nl.axians.camel.oauth2.springboot.OAuth2ComponentConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, OAuth2ComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.oauth2"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class OAuth2ComponentAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final CamelContext camelContext;
    private final OAuth2ComponentConfiguration configuration;

    public OAuth2ComponentAutoConfiguration(ApplicationContext theApplicationContext, CamelContext theCamelContext, OAuth2ComponentConfiguration theConfiguration) {
        this.applicationContext = theApplicationContext;
        this.camelContext = theCamelContext;
        this.configuration = theConfiguration;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureOAuth2Component() {
        return new ComponentCustomizer(){

            public void configure(String theName, Component theTarget) {
                CamelPropertiesHelper.copyProperties((CamelContext)OAuth2ComponentAutoConfiguration.this.camelContext, (Object)((Object)OAuth2ComponentAutoConfiguration.this.configuration), (Object)theTarget);
            }

            public boolean isEnabled(String theName, Component theTarget) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)OAuth2ComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.oauth2.customizer"}) && theTarget instanceof OAuth2Component;
            }
        };
    }
}

