/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.dsmr;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import nl.basjes.dsmr.CheckCRC;
import nl.basjes.dsmr.DSMRTelegram;
import nl.basjes.dsmr.MBusEvent;
import nl.basjes.dsmr.TimestampParser;
import nl.basjes.dsmr.parse.DsmrBaseVisitor;
import nl.basjes.dsmr.parse.DsmrLexer;
import nl.basjes.dsmr.parse.DsmrParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.shaded.org.antlr.v4.runtime.dfa.DFA;

public final class ParseDsmrTelegram
extends DsmrBaseVisitor<Void>
implements ANTLRErrorListener {
    private boolean hasSyntaxError = false;
    private final String telegramString;
    private final DSMRTelegram dsmrTelegram;
    private final TimestampParser timestampParser = new TimestampParser();

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object o, int i, int i1, String s, RecognitionException e) {
        this.hasSyntaxError = true;
        this.dsmrTelegram.isValid = false;
    }

    @Override
    public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    @Override
    public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
    }

    @Override
    public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
    }

    public static synchronized DSMRTelegram parse(String telegram) {
        return new ParseDsmrTelegram(telegram).parse();
    }

    private ParseDsmrTelegram(String telegram) {
        this.telegramString = telegram;
        this.dsmrTelegram = new DSMRTelegram();
        this.dsmrTelegram.isValid = this.dsmrTelegram.validCRC = CheckCRC.crcIsValid(this.telegramString);
    }

    private DSMRTelegram parse() {
        if (this.telegramString == null || this.telegramString.isEmpty()) {
            this.dsmrTelegram.isValid = false;
            return null;
        }
        CodePointCharStream input = CharStreams.fromString(this.telegramString);
        DsmrLexer lexer = new DsmrLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        DsmrParser parser = new DsmrParser(tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(this);
        parser.addErrorListener(this);
        DsmrParser.TelegramContext telegramContext = parser.telegram();
        if (telegramContext.ident == null) {
            return this.dsmrTelegram;
        }
        this.visitTelegram(telegramContext);
        this.fillMBusDataToAttributes(this.dsmrTelegram);
        this.dsmrTelegram.isValid = !this.hasSyntaxError && this.dsmrTelegram.validCRC;
        return this.dsmrTelegram;
    }

    private void fillMBusDataToAttributes(DSMRTelegram telegram) {
        for (Map.Entry<Integer, MBusEvent> mBusEventEntry : telegram.mBusEvents.entrySet()) {
            MBusEvent mBusEvent = mBusEventEntry.getValue();
            switch (mBusEvent.deviceType) {
                case 2: {
                    if (telegram.slaveEMeterEquipmentId != null) break;
                    telegram.slaveEMeterEquipmentId = mBusEvent.equipmentId;
                    telegram.slaveEMeterTimestamp = mBusEvent.timestamp;
                    telegram.slaveEMeterkWh = mBusEvent.value;
                    if ("kWh".equals(mBusEvent.unit)) break;
                    this.hasSyntaxError = true;
                    break;
                }
                case 3: {
                    if (telegram.gasEquipmentId != null) break;
                    telegram.gasEquipmentId = mBusEvent.equipmentId;
                    telegram.gasTimestamp = mBusEvent.timestamp;
                    telegram.gasM3 = mBusEvent.value;
                    if ("m3".equals(mBusEvent.unit)) break;
                    this.hasSyntaxError = true;
                    break;
                }
                case 6: 
                case 7: {
                    if (telegram.waterEquipmentId != null) break;
                    telegram.waterEquipmentId = mBusEvent.equipmentId;
                    telegram.waterTimestamp = mBusEvent.timestamp;
                    telegram.waterM3 = mBusEvent.value;
                    if ("m3".equals(mBusEvent.unit)) break;
                    this.hasSyntaxError = true;
                    break;
                }
                case 4: 
                case 12: {
                    if (telegram.thermalHeatEquipmentId != null) break;
                    telegram.thermalHeatEquipmentId = mBusEvent.equipmentId;
                    telegram.thermalHeatTimestamp = mBusEvent.timestamp;
                    telegram.thermalHeatGJ = mBusEvent.value;
                    if ("GJ".equals(mBusEvent.unit)) break;
                    this.hasSyntaxError = true;
                    break;
                }
                case 10: 
                case 11: {
                    if (telegram.thermalColdEquipmentId != null) break;
                    telegram.thermalColdEquipmentId = mBusEvent.equipmentId;
                    telegram.thermalColdTimestamp = mBusEvent.timestamp;
                    telegram.thermalColdGJ = mBusEvent.value;
                    if ("GJ".equals(mBusEvent.unit)) break;
                    this.hasSyntaxError = true;
                    break;
                }
            }
        }
    }

    private byte[] hexStringToByteArray(String s) {
        byte[] data = new byte[s.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)((Character.digit(s.charAt(i * 2), 16) << 4) + Character.digit(s.charAt(i * 2 + 1), 16));
        }
        return data;
    }

    private String hexStringToString(String hexString) {
        return new String(this.hexStringToByteArray(hexString), StandardCharsets.UTF_8);
    }

    @Override
    public Void visitTelegram(DsmrParser.TelegramContext ctx) {
        this.dsmrTelegram.ident = ctx.ident.getText();
        this.dsmrTelegram.crc = ctx.crc.getText().substring(1);
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitP1Version(DsmrParser.P1VersionContext ctx) {
        this.dsmrTelegram.p1Version = ctx.version.getText();
        return null;
    }

    @Override
    public Void visitTimestamp(DsmrParser.TimestampContext ctx) {
        this.dsmrTelegram.timestamp = this.timestampParser.parse(ctx.timestamp.getText());
        return null;
    }

    @Override
    public Void visitEquipmentId(DsmrParser.EquipmentIdContext ctx) {
        this.dsmrTelegram.equipmentId = this.hexStringToString(ctx.id.getText());
        return null;
    }

    @Override
    public Void visitMessage(DsmrParser.MessageContext ctx) {
        this.dsmrTelegram.message = ctx.text == null ? "" : this.hexStringToString(ctx.text.getText());
        return null;
    }

    @Override
    public Void visitPowerFailureEventLog(DsmrParser.PowerFailureEventLogContext ctx) {
        this.dsmrTelegram.powerFailureEventLogSize = Long.valueOf(ctx.count.getText());
        this.dsmrTelegram.powerFailureEventLog = new ArrayList<DSMRTelegram.PowerFailureEvent>();
        this.visitChildren(ctx);
        return null;
    }

    @Override
    public Void visitPowerFailureEvent(DsmrParser.PowerFailureEventContext ctx) {
        DSMRTelegram.PowerFailureEvent powerFailureEvent = new DSMRTelegram.PowerFailureEvent();
        powerFailureEvent.endTime = this.timestampParser.parse(ctx.eventTime.getText());
        powerFailureEvent.duration = Duration.ofSeconds(Long.parseLong(ctx.eventDuration.getText()));
        powerFailureEvent.startTime = powerFailureEvent.endTime.minus(powerFailureEvent.duration);
        this.dsmrTelegram.powerFailureEventLog.add(powerFailureEvent);
        return null;
    }

    @Override
    public Void visitElectricityTariffIndicator(DsmrParser.ElectricityTariffIndicatorContext ctx) {
        this.dsmrTelegram.electricityTariffIndicator = Long.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityReceivedLowTariff(DsmrParser.ElectricityReceivedLowTariffContext ctx) {
        this.dsmrTelegram.electricityReceivedLowTariff = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityReceivedNormalTariff(DsmrParser.ElectricityReceivedNormalTariffContext ctx) {
        this.dsmrTelegram.electricityReceivedNormalTariff = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityReturnedLowTariff(DsmrParser.ElectricityReturnedLowTariffContext ctx) {
        this.dsmrTelegram.electricityReturnedLowTariff = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityReturnedNormalTariff(DsmrParser.ElectricityReturnedNormalTariffContext ctx) {
        this.dsmrTelegram.electricityReturnedNormalTariff = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityPowerReceived(DsmrParser.ElectricityPowerReceivedContext ctx) {
        this.dsmrTelegram.electricityPowerReceived = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitElectricityPowerReturned(DsmrParser.ElectricityPowerReturnedContext ctx) {
        this.dsmrTelegram.electricityPowerReturned = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerFailures(DsmrParser.PowerFailuresContext ctx) {
        this.dsmrTelegram.powerFailures = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitLongPowerFailures(DsmrParser.LongPowerFailuresContext ctx) {
        this.dsmrTelegram.longPowerFailures = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSagsPhaseL1(DsmrParser.VoltageSagsPhaseL1Context ctx) {
        this.dsmrTelegram.voltageSagsPhaseL1 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSagsPhaseL2(DsmrParser.VoltageSagsPhaseL2Context ctx) {
        this.dsmrTelegram.voltageSagsPhaseL2 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSagsPhaseL3(DsmrParser.VoltageSagsPhaseL3Context ctx) {
        this.dsmrTelegram.voltageSagsPhaseL3 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSwellsPhaseL1(DsmrParser.VoltageSwellsPhaseL1Context ctx) {
        this.dsmrTelegram.voltageSwellsPhaseL1 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSwellsPhaseL2(DsmrParser.VoltageSwellsPhaseL2Context ctx) {
        this.dsmrTelegram.voltageSwellsPhaseL2 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageSwellsPhaseL3(DsmrParser.VoltageSwellsPhaseL3Context ctx) {
        this.dsmrTelegram.voltageSwellsPhaseL3 = Long.valueOf(ctx.count.getText());
        return null;
    }

    @Override
    public Void visitVoltageL1(DsmrParser.VoltageL1Context ctx) {
        this.dsmrTelegram.voltageL1 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitVoltageL2(DsmrParser.VoltageL2Context ctx) {
        this.dsmrTelegram.voltageL2 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitVoltageL3(DsmrParser.VoltageL3Context ctx) {
        this.dsmrTelegram.voltageL3 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitCurrentL1(DsmrParser.CurrentL1Context ctx) {
        this.dsmrTelegram.currentL1 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitCurrentL2(DsmrParser.CurrentL2Context ctx) {
        this.dsmrTelegram.currentL2 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitCurrentL3(DsmrParser.CurrentL3Context ctx) {
        this.dsmrTelegram.currentL3 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReceivedL1(DsmrParser.PowerReceivedL1Context ctx) {
        this.dsmrTelegram.powerReceivedL1 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReceivedL2(DsmrParser.PowerReceivedL2Context ctx) {
        this.dsmrTelegram.powerReceivedL2 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReceivedL3(DsmrParser.PowerReceivedL3Context ctx) {
        this.dsmrTelegram.powerReceivedL3 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReturnedL1(DsmrParser.PowerReturnedL1Context ctx) {
        this.dsmrTelegram.powerReturnedL1 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReturnedL2(DsmrParser.PowerReturnedL2Context ctx) {
        this.dsmrTelegram.powerReturnedL2 = Double.valueOf(ctx.value.getText());
        return null;
    }

    @Override
    public Void visitPowerReturnedL3(DsmrParser.PowerReturnedL3Context ctx) {
        this.dsmrTelegram.powerReturnedL3 = Double.valueOf(ctx.value.getText());
        return null;
    }

    private MBusEvent getMBusEvent(int index) {
        return this.dsmrTelegram.mBusEvents.computeIfAbsent(index, i -> new MBusEvent());
    }

    private void setMBusType(int index, int type) {
        MBusEvent mBusEvent = this.getMBusEvent(index);
        mBusEvent.deviceType = type;
    }

    @Override
    public Void visitMBus1Type(DsmrParser.MBus1TypeContext ctx) {
        this.setMBusType(1, Integer.parseInt(ctx.type.getText()));
        return null;
    }

    @Override
    public Void visitMBus2Type(DsmrParser.MBus2TypeContext ctx) {
        this.setMBusType(2, Integer.parseInt(ctx.type.getText()));
        return null;
    }

    @Override
    public Void visitMBus3Type(DsmrParser.MBus3TypeContext ctx) {
        this.setMBusType(3, Integer.parseInt(ctx.type.getText()));
        return null;
    }

    @Override
    public Void visitMBus4Type(DsmrParser.MBus4TypeContext ctx) {
        this.setMBusType(4, Integer.parseInt(ctx.type.getText()));
        return null;
    }

    private void setMBusEquipmentId(int index, String equipmentId) {
        MBusEvent mBusEvent = this.getMBusEvent(index);
        mBusEvent.equipmentId = this.hexStringToString(equipmentId);
    }

    @Override
    public Void visitMBus1EquipmentId(DsmrParser.MBus1EquipmentIdContext ctx) {
        this.setMBusEquipmentId(1, ctx.id.getText());
        return null;
    }

    @Override
    public Void visitMBus2EquipmentId(DsmrParser.MBus2EquipmentIdContext ctx) {
        this.setMBusEquipmentId(2, ctx.id.getText());
        return null;
    }

    @Override
    public Void visitMBus3EquipmentId(DsmrParser.MBus3EquipmentIdContext ctx) {
        this.setMBusEquipmentId(3, ctx.id.getText());
        return null;
    }

    @Override
    public Void visitMBus4EquipmentId(DsmrParser.MBus4EquipmentIdContext ctx) {
        this.setMBusEquipmentId(4, ctx.id.getText());
        return null;
    }

    private void setMBusUsage(int index, String timestampText, String value, String unit) {
        MBusEvent mBusEvent = this.getMBusEvent(index);
        mBusEvent.timestamp = this.timestampParser.parse(timestampText);
        mBusEvent.value = Double.valueOf(value);
        mBusEvent.unit = unit;
    }

    @Override
    public Void visitMBus1Usage(DsmrParser.MBus1UsageContext ctx) {
        this.setMBusUsage(1, ctx.timestamp.getText(), ctx.value.getText(), ctx.unit.getText());
        return null;
    }

    @Override
    public Void visitMBus2Usage(DsmrParser.MBus2UsageContext ctx) {
        this.setMBusUsage(2, ctx.timestamp.getText(), ctx.value.getText(), ctx.unit.getText());
        return null;
    }

    @Override
    public Void visitMBus3Usage(DsmrParser.MBus3UsageContext ctx) {
        this.setMBusUsage(3, ctx.timestamp.getText(), ctx.value.getText(), ctx.unit.getText());
        return null;
    }

    @Override
    public Void visitMBus4Usage(DsmrParser.MBus4UsageContext ctx) {
        this.setMBusUsage(4, ctx.timestamp.getText(), ctx.value.getText(), ctx.unit.getText());
        return null;
    }
}

