/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadUTF8RecordStream
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ReadUTF8RecordStream.class);
    public static final long MIN_MAX_RECORD_SIZE = 10240L;
    public static final long MAX_MAX_RECORD_SIZE = 0x6400000L;
    private InputStream inputStream;
    private Pattern endMatcher;
    private long maxRecordSize;
    private StringBuilder previousLastRecord = new StringBuilder();

    public ReadUTF8RecordStream(InputStream input, String recordEndRegex) {
        this(input, recordEndRegex, 10240L);
    }

    public ReadUTF8RecordStream(InputStream input, String recordEndRegex, long newMaxRecordSize) {
        this.inputStream = input;
        this.endMatcher = Pattern.compile("(" + recordEndRegex + ")");
        this.maxRecordSize = Math.max(newMaxRecordSize, 10240L);
        this.maxRecordSize = Math.min(this.maxRecordSize, 0x6400000L);
    }

    public String read() throws IOException {
        int length;
        byte[] readBuffer = new byte[4096];
        if (this.previousLastRecord == null) {
            return null;
        }
        String record = this.extractRecordFromBuffer();
        if (record != null) {
            return record;
        }
        do {
            int bytesRead;
            if ((bytesRead = this.inputStream.read(readBuffer)) == -1) {
                String returnValue = this.previousLastRecord.toString();
                this.previousLastRecord = null;
                return returnValue;
            }
            this.previousLastRecord.append(new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8));
            record = this.extractRecordFromBuffer();
            if (record == null) continue;
            return record;
        } while ((long)(length = this.previousLastRecord.length()) <= this.maxRecordSize);
        LOG.error("After {} bytes the end-of-record pattern     {}     has not been found.", (Object)length, (Object)this.endMatcher.pattern());
        this.previousLastRecord = null;
        throw new IOException("After " + length + " bytes the end-of-record pattern has not been found yet.");
    }

    private String extractRecordFromBuffer() {
        Matcher matcher = this.endMatcher.matcher(this.previousLastRecord);
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            int endOfPartIndex = matchResult.end(1);
            String result = this.previousLastRecord.substring(0, endOfPartIndex);
            this.previousLastRecord = new StringBuilder(this.previousLastRecord.substring(endOfPartIndex));
            return result;
        }
        return null;
    }
}

