/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.graphql.tcp;

import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.facade.ModbusTCPMaster;
import java.io.File;
import kotlin.Metadata;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.j2mod.ModbusDeviceJ2Mod;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.YamlLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackages={"nl.basjes.modbus.graphql.tcp", "nl.basjes.modbus.graphql"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0017R\u0012\u0010\u0004\u001a\u00020\u00058\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\u00078\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lnl/basjes/modbus/graphql/tcp/SunSpecGraphQLApplication;", "", "<init>", "()V", "modbusHost", "", "modbusPort", "", "modbusUnit", "getModbusUnit", "()I", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbus-tcp-graphql"})
public class SunSpecGraphQLApplication {
    @Value(value="${modbus.host}")
    @NotNull
    private String modbusHost = "";
    @Value(value="${modbus.port:502}")
    private int modbusPort = 502;
    @Value(value="${modbus.unit:1}")
    private final int modbusUnit;

    public SunSpecGraphQLApplication() {
        this.modbusUnit = 1;
    }

    public int getModbusUnit() {
        return this.modbusUnit;
    }

    @Bean
    @NotNull
    public SchemaDevice schemaDevice() {
        Logger logger = LoggerFactory.getLogger((String)"Modbus TCP");
        logger.info("Connecting to Modbus TCP device on:");
        logger.info("- Hostname: {}", (Object)this.modbusHost);
        logger.info("- TCP Port: {}", (Object)this.modbusPort);
        logger.info("- UnitID  : {}", (Object)this.getModbusUnit());
        logger.info("Modbus: Connecting...");
        ModbusTCPMaster modbusMaster = new ModbusTCPMaster(this.modbusHost, this.modbusPort);
        modbusMaster.connect();
        ModbusDeviceJ2Mod modbusDevice = new ModbusDeviceJ2Mod((AbstractModbusMaster)modbusMaster, this.getModbusUnit());
        logger.info("Modbus: Connected");
        logger.info("Schema: Loading schema");
        SchemaDevice schemaDevice = YamlLoaderKt.toSchemaDevice((File)new File("ModbusSchema.yaml"));
        SchemaDevice.connect$default((SchemaDevice)schemaDevice, (ModbusDevice)((ModbusDevice)modbusDevice), (int)0, (int)2, null);
        logger.info("Schema: Completed");
        return schemaDevice;
    }
}

