/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.graphql;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.version.Version;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0012J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lnl/basjes/modbus/graphql/GraphQLSchemaLibraryVersion;", "Lgraphql/schema/GraphQLTypeVisitorStub;", "<init>", "()V", "addModbusSchemaToolkitVersionToGraphQLSchema", "Lgraphql/schema/GraphQLTypeVisitor;", "newField", "Lgraphql/schema/GraphQLFieldDefinition;", "name", "", "description", "visitGraphQLObjectType", "Lgraphql/util/TraversalControl;", "objectType", "Lgraphql/schema/GraphQLObjectType;", "context", "Lgraphql/util/TraverserContext;", "Lgraphql/schema/GraphQLSchemaElement;", "modbus-graphql-common"})
public class GraphQLSchemaLibraryVersion
extends GraphQLTypeVisitorStub {
    @Bean
    @NotNull
    public GraphQLTypeVisitor addModbusSchemaToolkitVersionToGraphQLSchema() {
        return (GraphQLTypeVisitor)this;
    }

    private GraphQLFieldDefinition newField(String name, String description) {
        GraphQLFieldDefinition graphQLFieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name(name).description(description).type((GraphQLOutputType)Scalars.GraphQLString).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"build(...)");
        return graphQLFieldDefinition;
    }

    @Nullable
    public TraversalControl visitGraphQLObjectType(@NotNull GraphQLObjectType objectType, @NotNull TraverserContext<GraphQLSchemaElement> context) {
        Intrinsics.checkNotNullParameter((Object)objectType, (String)"objectType");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
        if (Intrinsics.areEqual((Object)objectType.getName(), (Object)"Query")) {
            LogManager.getLogger(GraphQLSchemaLibraryVersion.class).info("Adding the `modbusSchemaVersion` to the GraphQL Query.");
            GraphQLObjectType version = GraphQLObjectType.newObject().name("ModbusSchemaVersion").description("The version information of the underlying Modbus Schema Toolkit.").field(this.newField("gitCommitId", "The git commit id of the Modbus Schema Toolkit that is used")).field(this.newField("gitCommitIdDescribeShort", "The git describe short of the Modbus Schema Toolkit that is used")).field(this.newField("buildTimeStamp", "Timestamp when the Modbus Schema Toolkit was built.")).field(this.newField("projectVersion", "Version of the Modbus Schema Toolkit")).field(this.newField("copyright", "Copyright notice of the Modbus Schema Toolkit that is used")).field(this.newField("license", "The software license Modbus Schema Toolkit that is used")).field(this.newField("url", "Project url")).field(this.newField("buildKotlinVersion", "Modbus Schema Toolkit was build using this Kotlin version")).build();
            GraphQLFieldDefinition getVersion = GraphQLFieldDefinition.newFieldDefinition().name("modbusSchemaVersion").description("Returns the version information of the underlying Modbus Schema Toolkit.").type((GraphQLOutputType)version).build();
            GraphQLObjectType updatedQuery = objectType.transform(arg_0 -> GraphQLSchemaLibraryVersion.visitGraphQLObjectType$lambda$0(getVersion, arg_0));
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)objectType.getName(), (String)getVersion.getName());
            codeRegistry.dataFetcher(coordinates, GraphQLSchemaLibraryVersion::visitGraphQLObjectType$lambda$1);
            return this.changeNode(context, (GraphQLSchemaElement)updatedQuery);
        }
        return TraversalControl.CONTINUE;
    }

    private static final void visitGraphQLObjectType$lambda$0(GraphQLFieldDefinition $getVersion, GraphQLObjectType.Builder it) {
        it.field($getVersion);
    }

    private static final Version visitGraphQLObjectType$lambda$1(DataFetchingEnvironment it) {
        return Version.INSTANCE;
    }
}

