/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.graphql;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.SelectedField;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import nl.basjes.modbus.graphql.DeviceData;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import nl.basjes.modbus.schema.utils.CodeGeneration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.graphql.data.method.annotation.Argument;
import org.springframework.graphql.data.method.annotation.GraphQlExceptionHandler;
import org.springframework.graphql.data.method.annotation.QueryMapping;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.SubscriptionMapping;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.stereotype.Controller;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;

@Controller
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u000f*\u00020\u0014H\u0016J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001eH\u0016J\u001a\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J4\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\b\b\u0001\u0010 \u001a\u00020\u001e2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0016J \u0010(\u001a\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\n\u0010,\u001a\u00060-j\u0002`.H\u0017J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0017J\u0010\u00102\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0017J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u00100\u001a\u000201H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR,\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lnl/basjes/modbus/graphql/SchemaDeviceGraphQLResolver;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "fields", "", "", "Lnl/basjes/modbus/schema/Field;", "getFields", "()Ljava/util/Map;", "gqlId", "Lnl/basjes/modbus/schema/Block;", "gqlType", "toStr", "", "requestedFields", "dataFetchingEnvironment", "Lgraphql/schema/DataFetchingEnvironment;", "maxAge", "", "maxAgeMs", "", "interval", "intervalMs", "queryDeviceData", "Lnl/basjes/modbus/graphql/DeviceData;", "streamDeviceData", "Lreactor/core/publisher/Flux;", "queryAtRoundInterval", "", "timeToNextMultiple", "handleIllegalArgument", "Lgraphql/GraphQLError;", "errorBuilder", "Lgraphql/GraphqlErrorBuilder;", "ex", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "getModbusQueryDuration", "modbusQuery", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "getModbusQueryStatus", "getModbusQueryFields", "modbus-graphql-common"})
@SourceDebugExtension(value={"SMAP\nSchemaDeviceGraphQLResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDeviceGraphQLResolver.kt\nnl/basjes/modbus/graphql/SchemaDeviceGraphQLResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1869#2:203\n1869#2,2:204\n1870#2:206\n774#2:207\n865#2,2:208\n774#2:210\n865#2,2:211\n774#2:213\n865#2,2:214\n1563#2:216\n1634#2,3:217\n1617#2,9:220\n1869#2:229\n1870#2:231\n1626#2:232\n1869#2,2:233\n1869#2,2:235\n1869#2,2:237\n1563#2:239\n1634#2,3:240\n1869#2,2:243\n1#3:230\n*S KotlinDebug\n*F\n+ 1 SchemaDeviceGraphQLResolver.kt\nnl/basjes/modbus/graphql/SchemaDeviceGraphQLResolver\n*L\n61#1:203\n64#1:204,2\n61#1:206\n74#1:207\n74#1:208,2\n75#1:210\n75#1:211,2\n76#1:213\n76#1:214,2\n77#1:216\n77#1:217,3\n80#1:220,9\n80#1:229\n80#1:231\n80#1:232\n111#1:233,2\n120#1:235,2\n144#1:237,2\n199#1:239\n199#1:240,3\n164#1:243,2\n80#1:230\n*E\n"})
public class SchemaDeviceGraphQLResolver {
    @NotNull
    private final SchemaDevice schemaDevice;
    private final Logger logger;
    @NotNull
    private final Map<String, Map<String, Field>> fields;

    public SchemaDeviceGraphQLResolver(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        this.schemaDevice = schemaDevice;
        this.logger = LoggerFactory.getLogger((String)"Modbus GraphQL");
        this.fields = new LinkedHashMap();
        Iterable $this$forEach$iv = this.getSchemaDevice().getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block = (Block)element$iv;
            boolean bl = false;
            Map blockMap = new LinkedHashMap();
            this.getFields().put(this.gqlType(block), blockMap);
            Iterable $this$forEach$iv2 = block.getFields();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                blockMap.put(this.gqlId(field), field);
            }
        }
    }

    @NotNull
    public SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Map<String, Map<String, Field>> getFields() {
        return this.fields;
    }

    @NotNull
    public String gqlId(@NotNull Block $this$gqlId) {
        Intrinsics.checkNotNullParameter((Object)$this$gqlId, (String)"<this>");
        return CodeGeneration.convertToCodeCompliantName((String)$this$gqlId.getId(), (boolean)false);
    }

    @NotNull
    public String gqlType(@NotNull Block $this$gqlType) {
        Intrinsics.checkNotNullParameter((Object)$this$gqlType, (String)"<this>");
        return CodeGeneration.convertToCodeCompliantName((String)$this$gqlType.getId(), (boolean)true);
    }

    @NotNull
    public String gqlId(@NotNull Field $this$gqlId) {
        Intrinsics.checkNotNullParameter((Object)$this$gqlId, (String)"<this>");
        return CodeGeneration.convertToCodeCompliantName((String)$this$gqlId.getId(), (boolean)false);
    }

    @NotNull
    public String toStr(@NotNull List<Field> $this$toStr) {
        Intrinsics.checkNotNullParameter($this$toStr, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$toStr, (CharSequence)", ", null, null, (int)0, null, SchemaDeviceGraphQLResolver::toStr$lambda$2, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private List<Field> requestedFields(DataFetchingEnvironment dataFetchingEnvironment) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        SelectedField it;
        Iterable $this$filterTo$iv$iv;
        List list = dataFetchingEnvironment.getSelectionSet().getFields();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SelectedField)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() instanceof GraphQLScalarType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SelectedField)element$iv$iv;
            boolean bl = false;
            if (!(it.getParentField().getType() instanceof GraphQLObjectType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SelectedField)element$iv$iv;
            boolean bl = false;
            GraphQLOutputType graphQLOutputType = it.getParentField().getType();
            Intrinsics.checkNotNull((Object)graphQLOutputType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
            if (!(!Intrinsics.areEqual((Object)((GraphQLObjectType)graphQLOutputType).getName(), (Object)"DeviceData"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SelectedField)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GraphQLOutputType graphQLOutputType = it.getParentField().getType();
            Intrinsics.checkNotNull((Object)graphQLOutputType, (String)"null cannot be cast to non-null type graphql.schema.GraphQLObjectType");
            collection.add(new Pair((Object)((GraphQLObjectType)graphQLOutputType).getName(), (Object)it.getName()));
        }
        List selectedFields = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = selectedFields;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Field it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            String block = (String)object;
            String field = (String)pair.component2();
            Map map = (Map)this.getFields().get(block);
            if ((map != null ? (Field)map.get(field) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List modbusFields = (List)destination$iv$iv2;
        this.getLogger().trace("Query with Modbus fields " + this.toStr(modbusFields));
        return modbusFields;
    }

    public long maxAge(int maxAgeMs) {
        if (maxAgeMs < 0 || maxAgeMs > 60000) {
            throw new IllegalArgumentException("maxAgeMs must be a between 0 ms and 60000 ms (60 seconds)");
        }
        return maxAgeMs;
    }

    public long interval(int intervalMs) {
        if (intervalMs < 500 || intervalMs > 60000) {
            throw new IllegalArgumentException("IntervalMs must be between 500 ms (0.5 seconds) and 60000 ms (60 seconds)");
        }
        return intervalMs;
    }

    @QueryMapping(value="deviceData")
    @NotNull
    public DeviceData queryDeviceData(@Argument(value="maxAgeMs") int maxAgeMs, @NotNull DataFetchingEnvironment dataFetchingEnvironment) {
        Intrinsics.checkNotNullParameter((Object)dataFetchingEnvironment, (String)"dataFetchingEnvironment");
        long usedMaxAgeMs = this.maxAge(maxAgeMs);
        List requestedFields = this.requestedFields(dataFetchingEnvironment);
        Iterable $this$forEach$iv = requestedFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.need();
        }
        Instant start = Instant.now();
        this.getLogger().trace("Query: START@    {}", (Object)start);
        List modbusQueries = this.getSchemaDevice().update(usedMaxAgeMs);
        long stop = Instant.now().toEpochMilli();
        int duration = (int)(stop - start.toEpochMilli());
        Object[] bl = new Object[]{Instant.now(), duration, modbusQueries.size()};
        this.getLogger().trace("Query: COMPLETE@ {} DURATION {}ms to do {} Modbus Requests", bl);
        Iterable $this$forEach$iv2 = requestedFields;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Field it = (Field)element$iv;
            boolean bl2 = false;
            it.unNeed();
        }
        SchemaDevice schemaDevice = this.getSchemaDevice();
        ZonedDateTime zonedDateTime = start.atZone(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return new DeviceData(schemaDevice, requestedFields, modbusQueries, zonedDateTime, duration);
    }

    @SubscriptionMapping(value="deviceData")
    @NotNull
    public Flux<DeviceData> streamDeviceData(@Argument(value="intervalMs") int intervalMs, @Argument(value="maxAgeMs") int maxAgeMs, @Argument(value="queryAtRoundInterval") boolean queryAtRoundInterval, @NotNull DataFetchingEnvironment dataFetchingEnvironment) {
        Intrinsics.checkNotNullParameter((Object)dataFetchingEnvironment, (String)"dataFetchingEnvironment");
        long usedIntervalMs = this.interval(intervalMs);
        long usedMaxAgeMs = this.maxAge(maxAgeMs);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String subscriberId = string;
        List requestedFields = this.requestedFields(dataFetchingEnvironment);
        this.getLogger().trace("START: Subscription " + subscriberId + ": Modbus fields " + this.toStr(requestedFields));
        Iterable $this$forEach$iv = requestedFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.need();
        }
        Flux flux = Flux.interval((java.time.Duration)java.time.Duration.ofMillis(usedIntervalMs)).map(arg_0 -> SchemaDeviceGraphQLResolver.streamDeviceData$lambda$12(arg_0 -> SchemaDeviceGraphQLResolver.streamDeviceData$lambda$11(queryAtRoundInterval, this, intervalMs, subscriberId, usedMaxAgeMs, requestedFields, arg_0), arg_0)).doFinally(arg_0 -> SchemaDeviceGraphQLResolver.streamDeviceData$lambda$14(this, subscriberId, requestedFields, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doFinally(...)");
        return flux;
    }

    public long timeToNextMultiple(long intervalMs) {
        long now = System.currentTimeMillis();
        long roundedNext = (now / intervalMs + 1L) * intervalMs;
        return roundedNext - now;
    }

    @GraphQlExceptionHandler(value={IllegalArgumentException.class})
    @NotNull
    public GraphQLError handleIllegalArgument(@NotNull GraphqlErrorBuilder<?> errorBuilder, @NotNull IllegalArgumentException ex) {
        Intrinsics.checkNotNullParameter(errorBuilder, (String)"errorBuilder");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        GraphQLError graphQLError = errorBuilder.message(ex.getMessage(), new Object[0]).errorType((ErrorClassification)ErrorType.BAD_REQUEST).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLError, (String)"build(...)");
        return graphQLError;
    }

    @SchemaMapping(value="duration")
    public int getModbusQueryDuration(@NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        Duration duration = modbusQuery.getDuration-FghU774();
        if (duration == null) {
            return 0;
        }
        return (int)Duration.toLong-impl((long)duration.unbox-impl(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    @SchemaMapping(value="status")
    @NotNull
    public String getModbusQueryStatus(@NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        return modbusQuery.getStatus().name();
    }

    /*
     * WARNING - void declaration
     */
    @SchemaMapping(value="fields")
    @NotNull
    public List<String> getModbusQueryFields(@NotNull ModbusQuery modbusQuery) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        Iterable $this$map$iv = modbusQuery.getFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field field = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBlock().getId() + "|" + it.getId());
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence toStr$lambda$2(Field it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + it.getBlock().getId() + " | " + it.getId() + ")";
    }

    private static final DeviceData streamDeviceData$lambda$11(boolean $queryAtRoundInterval, SchemaDeviceGraphQLResolver this$0, int $intervalMs, String $subscriberId, long $usedMaxAgeMs, List $requestedFields, Long it) {
        if ($queryAtRoundInterval) {
            Thread.sleep(java.time.Duration.ofMillis(this$0.timeToNextMultiple((long)$intervalMs)));
        }
        Instant start = Instant.now();
        this$0.getLogger().trace("TIMER: Subscription {}: START@    {}", (Object)$subscriberId, (Object)start);
        List modbusQueries = this$0.getSchemaDevice().update($usedMaxAgeMs);
        long stop = Instant.now().toEpochMilli();
        int duration = (int)(stop - start.toEpochMilli());
        Object[] objectArray = new Object[]{$subscriberId, Instant.now(), duration, modbusQueries.size()};
        this$0.getLogger().trace("TIMER: Subscription {}: COMPLETE@ {} DURATION {}ms to do {} Modbus Requests", objectArray);
        SchemaDevice schemaDevice = this$0.getSchemaDevice();
        ZonedDateTime zonedDateTime = start.atZone(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return new DeviceData(schemaDevice, $requestedFields, modbusQueries, zonedDateTime, duration);
    }

    private static final DeviceData streamDeviceData$lambda$12(Function1 $tmp0, Object p0) {
        return (DeviceData)$tmp0.invoke(p0);
    }

    private static final void streamDeviceData$lambda$14(SchemaDeviceGraphQLResolver this$0, String $subscriberId, List $requestedFields, SignalType it) {
        this$0.getLogger().trace("STOP: Subscription " + $subscriberId + ": Modbus fields " + this$0.toStr($requestedFields));
        Iterable $this$forEach$iv = $requestedFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it2 = (Field)element$iv;
            boolean bl = false;
            it2.unNeed();
        }
    }
}

