/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.graphql;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Description;

@Description(value="The data from the modbus device.")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lnl/basjes/modbus/graphql/DeviceData;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "requestedFields", "", "Lnl/basjes/modbus/schema/Field;", "modbusQueries", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "requestTimestamp", "Ljava/time/ZonedDateTime;", "totalUpdateDurationMs", "", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Ljava/util/List;Ljava/util/List;Ljava/time/ZonedDateTime;I)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getRequestedFields", "()Ljava/util/List;", "getModbusQueries", "getRequestTimestamp", "()Ljava/time/ZonedDateTime;", "getTotalUpdateDurationMs", "()I", "description", "", "getDescription", "()Ljava/lang/String;", "dataTimestamp", "getDataTimestamp", "modbus-graphql-common"})
@SourceDebugExtension(value={"SMAP\nDeviceData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceData.kt\nnl/basjes/modbus/graphql/DeviceData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,47:1\n1617#2,9:48\n1869#2:57\n1870#2:59\n1626#2:60\n1#3:58\n37#4:61\n36#4,3:62\n*S KotlinDebug\n*F\n+ 1 DeviceData.kt\nnl/basjes/modbus/graphql/DeviceData\n*L\n42#1:48,9\n42#1:57\n42#1:59\n42#1:60\n42#1:58\n42#1:61\n42#1:62,3\n*E\n"})
public final class DeviceData {
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final List<Field> requestedFields;
    @NotNull
    private final List<ModbusQuery> modbusQueries;
    @NotNull
    private final ZonedDateTime requestTimestamp;
    private final int totalUpdateDurationMs;
    @NotNull
    private final String description;

    public DeviceData(@NotNull SchemaDevice schemaDevice, @NotNull List<Field> requestedFields, @NotNull List<? extends ModbusQuery> modbusQueries, @NotNull ZonedDateTime requestTimestamp, int totalUpdateDurationMs) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter(requestedFields, (String)"requestedFields");
        Intrinsics.checkNotNullParameter(modbusQueries, (String)"modbusQueries");
        Intrinsics.checkNotNullParameter((Object)requestTimestamp, (String)"requestTimestamp");
        this.schemaDevice = schemaDevice;
        this.requestedFields = requestedFields;
        this.modbusQueries = modbusQueries;
        this.requestTimestamp = requestTimestamp;
        this.totalUpdateDurationMs = totalUpdateDurationMs;
        this.description = this.schemaDevice.getDescription();
    }

    @NotNull
    public final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    public final List<Field> getRequestedFields() {
        return this.requestedFields;
    }

    @NotNull
    public final List<ModbusQuery> getModbusQueries() {
        return this.modbusQueries;
    }

    @NotNull
    public final ZonedDateTime getRequestTimestamp() {
        return this.requestTimestamp;
    }

    public final int getTotalUpdateDurationMs() {
        return this.totalUpdateDurationMs;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ZonedDateTime getDataTimestamp() {
        void $this$mapNotNullTo$iv$iv;
        if (this.requestedFields.isEmpty()) {
            return null;
        }
        Iterable $this$mapNotNull$iv = this.requestedFields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Field it = (Field)element$iv$iv;
            boolean bl2 = false;
            if (it.getValueEpochMs() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long l = (Long)ArraysKt.maxOrNull((Comparable[])thisCollection$iv.toArray(new Long[0]));
        if (l == null) {
            return null;
        }
        long maxTimestamp = l;
        return Instant.ofEpochMilli(maxTimestamp).atZone(ZoneOffset.UTC);
    }
}

