/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.digitalpetri;

import com.digitalpetri.modbus.client.ModbusClient;
import com.digitalpetri.modbus.exceptions.ModbusException;
import com.digitalpetri.modbus.exceptions.ModbusResponseException;
import com.digitalpetri.modbus.pdu.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.pdu.ReadHoldingRegistersResponse;
import com.digitalpetri.modbus.pdu.ReadInputRegistersRequest;
import com.digitalpetri.modbus.pdu.ReadInputRegistersResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.FunctionCode;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.NotYetImplementedException;
import nl.basjes.modbus.device.exception.ReadErrorResponseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnl/basjes/modbus/device/digitalpetri/ModbusDeviceDigitalPetri;", "Lnl/basjes/modbus/device/api/ModbusDevice;", "client", "Lcom/digitalpetri/modbus/client/ModbusClient;", "unitId", "", "<init>", "(Lcom/digitalpetri/modbus/client/ModbusClient;I)V", "close", "", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "firstRegister", "Lnl/basjes/modbus/device/api/Address;", "count", "buildRegisterBlock", "firstAddress", "bytes", "", "modbus-api-digitalpetri"})
@SourceDebugExtension(value={"SMAP\nModbusDeviceDigitalPetri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusDeviceDigitalPetri.kt\nnl/basjes/modbus/device/digitalpetri/ModbusDeviceDigitalPetri\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class ModbusDeviceDigitalPetri
extends ModbusDevice {
    @NotNull
    private final ModbusClient client;
    private final int unitId;

    public ModbusDeviceDigitalPetri(@NotNull ModbusClient client, int unitId) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.unitId = unitId;
        if (!this.client.isConnected()) {
            boolean $i$a$-require-ModbusDeviceDigitalPetri$32 = false;
            String $i$a$-require-ModbusDeviceDigitalPetri$32 = "The provided client must be connected";
            throw new IllegalArgumentException($i$a$-require-ModbusDeviceDigitalPetri$32.toString());
        }
        if (!(this.unitId >= 0 && this.unitId <= 247)) {
            boolean bl = false;
            String string = "The unitId is outside the allowed range [0-247]: " + this.unitId;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public void close() {
        this.client.disconnect();
    }

    @NotNull
    public RegisterBlock getRegisters(@NotNull Address firstRegister, int count) throws nl.basjes.modbus.device.exception.ModbusException {
        Intrinsics.checkNotNullParameter((Object)firstRegister, (String)"firstRegister");
        FunctionCode functionCode = FunctionCode.Companion.forReading(firstRegister.getAddressClass());
        switch (WhenMappings.$EnumSwitchMapping$0[functionCode.ordinal()]) {
            case 1: 
            case 2: {
                throw new NotYetImplementedException("Reading a " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
            }
            case 3: {
                try {
                    ReadHoldingRegistersResponse response = this.client.readHoldingRegisters(this.unitId, new ReadHoldingRegistersRequest(firstRegister.getPhysicalAddress(), count));
                    return this.buildRegisterBlock(firstRegister, response.registers());
                }
                catch (ModbusResponseException modbusResponseException) {
                    return ReadErrorResponseKt.createReadErrorResponse((Address)firstRegister, (int)count);
                }
                catch (ModbusException e) {
                    throw new nl.basjes.modbus.device.exception.ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
            case 4: {
                try {
                    ReadInputRegistersResponse response = this.client.readInputRegisters(this.unitId, new ReadInputRegistersRequest(firstRegister.getPhysicalAddress(), count));
                    return this.buildRegisterBlock(firstRegister, response.registers());
                }
                catch (ModbusResponseException modbusResponseException) {
                    return ReadErrorResponseKt.createReadErrorResponse((Address)firstRegister, (int)count);
                }
                catch (nl.basjes.modbus.device.exception.ModbusException e) {
                    throw new nl.basjes.modbus.device.exception.ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
        }
        throw new NotYetImplementedException("The function code " + functionCode + " for " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
    }

    private final RegisterBlock buildRegisterBlock(Address firstAddress, byte[] bytes) {
        long now = System.currentTimeMillis();
        Address loopRegisterAddress = firstAddress;
        RegisterBlock result = new RegisterBlock(firstAddress.getAddressClass());
        if (bytes == null) {
            return result;
        }
        if (bytes.length % 2 != 0) {
            throw new nl.basjes.modbus.device.exception.ModbusException("Received an odd number of bytes (" + bytes.length + ") for the registers", null, 2, null);
        }
        int n = bytes.length / 2;
        for (int registerNr = 0; registerNr < n; ++registerNr) {
            byte byte0 = bytes[registerNr * 2];
            byte byte1 = bytes[registerNr * 2 + 1];
            short register = (short)((byte0 << 8 & 0xFF00 | byte1 & 0xFF) & 0xFFFF);
            result.set(loopRegisterAddress, new RegisterValue(loopRegisterAddress).setValue(register, now));
            loopRegisterAddress = loopRegisterAddress.increment(1);
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FunctionCode.values().length];
            try {
                nArray[FunctionCode.READ_COIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_DISCRETE_INPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_HOLDING_REGISTERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_INPUT_REGISTERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

