/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.j2mod;

import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.util.BitVector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.FunctionCode;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.exception.NotYetImplementedException;
import nl.basjes.modbus.device.exception.ReadErrorResponseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J%\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnl/basjes/modbus/device/j2mod/ModbusDeviceJ2Mod;", "Lnl/basjes/modbus/device/api/ModbusDevice;", "master", "Lcom/ghgande/j2mod/modbus/facade/AbstractModbusMaster;", "unitId", "", "<init>", "(Lcom/ghgande/j2mod/modbus/facade/AbstractModbusMaster;I)V", "close", "", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "firstRegister", "Lnl/basjes/modbus/device/api/Address;", "count", "buildRegisterBlock", "firstAddress", "registers", "", "Lcom/ghgande/j2mod/modbus/procimg/InputRegister;", "(Lnl/basjes/modbus/device/api/Address;[Lcom/ghgande/j2mod/modbus/procimg/InputRegister;)Lnl/basjes/modbus/device/api/RegisterBlock;", "getDiscretes", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "firstDiscrete", "buildDiscreteBlock", "bitVector", "Lcom/ghgande/j2mod/modbus/util/BitVector;", "modbus-api-j2mod"})
@SourceDebugExtension(value={"SMAP\nModbusDeviceJ2Mod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusDeviceJ2Mod.kt\nnl/basjes/modbus/device/j2mod/ModbusDeviceJ2Mod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class ModbusDeviceJ2Mod
extends ModbusDevice {
    @NotNull
    private final AbstractModbusMaster master;
    private final int unitId;

    public ModbusDeviceJ2Mod(@NotNull AbstractModbusMaster master, int unitId) {
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.master = master;
        this.unitId = unitId;
        if (!this.master.isConnected()) {
            boolean $i$a$-require-ModbusDeviceJ2Mod$32 = false;
            String $i$a$-require-ModbusDeviceJ2Mod$32 = "The provided master must be connected";
            throw new IllegalArgumentException($i$a$-require-ModbusDeviceJ2Mod$32.toString());
        }
        if (!(this.unitId >= 0 && this.unitId <= 247)) {
            boolean bl = false;
            String string = "The unitId is outside the allowed range [0-247]: " + this.unitId;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public void close() {
        this.master.disconnect();
    }

    @NotNull
    public RegisterBlock getRegisters(@NotNull Address firstRegister, int count) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)firstRegister, (String)"firstRegister");
        FunctionCode functionCode = FunctionCode.Companion.forReading(firstRegister.getAddressClass());
        switch (WhenMappings.$EnumSwitchMapping$0[functionCode.ordinal()]) {
            case 1: 
            case 2: {
                throw new NotYetImplementedException("Reading a " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
            }
            case 3: {
                try {
                    Register[] registerArray = this.master.readMultipleRegisters(this.unitId, firstRegister.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)registerArray, (String)"readMultipleRegisters(...)");
                    Register[] registers = registerArray;
                    return this.buildRegisterBlock(firstRegister, (InputRegister[])registers);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorRegisterBlock((Address)firstRegister, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
            case 4: {
                try {
                    InputRegister[] inputRegisterArray = this.master.readInputRegisters(this.unitId, firstRegister.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)inputRegisterArray, (String)"readInputRegisters(...)");
                    InputRegister[] registers = inputRegisterArray;
                    return this.buildRegisterBlock(firstRegister, registers);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorRegisterBlock((Address)firstRegister, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
        }
        throw new NotYetImplementedException("The function code " + functionCode + " for " + firstRegister.getAddressClass() + " cannot be retrieved using getRegisters", null, 2, null);
    }

    private final RegisterBlock buildRegisterBlock(Address firstAddress, InputRegister[] registers) {
        long now = System.currentTimeMillis();
        Address loopRegisterAddress = firstAddress;
        RegisterBlock result = new RegisterBlock(firstAddress.getAddressClass());
        for (InputRegister register : registers) {
            result.set(loopRegisterAddress, new RegisterValue(loopRegisterAddress).setValue((Object)((short)(register.getValue() & 0xFFFF)), now));
            loopRegisterAddress = loopRegisterAddress.increment(1);
        }
        return result;
    }

    @NotNull
    public DiscreteBlock getDiscretes(@NotNull Address firstDiscrete, int count) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)firstDiscrete, (String)"firstDiscrete");
        FunctionCode functionCode = FunctionCode.Companion.forReading(firstDiscrete.getAddressClass());
        switch (WhenMappings.$EnumSwitchMapping$0[functionCode.ordinal()]) {
            case 1: {
                try {
                    BitVector bitVector = this.master.readCoils(this.unitId, firstDiscrete.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)bitVector, (String)"readCoils(...)");
                    BitVector coils = bitVector;
                    return this.buildDiscreteBlock(firstDiscrete, coils);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorDiscreteBlock((Address)firstDiscrete, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstDiscrete.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
            case 2: {
                try {
                    BitVector bitVector = this.master.readInputDiscretes(this.unitId, firstDiscrete.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)bitVector, (String)"readInputDiscretes(...)");
                    BitVector coils = bitVector;
                    return this.buildDiscreteBlock(firstDiscrete, coils);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorDiscreteBlock((Address)firstDiscrete, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstDiscrete.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
        }
        throw new NotYetImplementedException("The function code " + functionCode + " for " + firstDiscrete.getAddressClass() + " cannot be retrieved using getDiscretes", null, 2, null);
    }

    private final DiscreteBlock buildDiscreteBlock(Address firstAddress, BitVector bitVector) {
        long now = System.currentTimeMillis();
        Address loopDiscreteAddress = firstAddress;
        DiscreteBlock result = new DiscreteBlock(firstAddress.getAddressClass());
        int n = bitVector.size();
        for (int index = 0; index < n; ++index) {
            result.set(loopDiscreteAddress, new DiscreteValue(loopDiscreteAddress).setValue((Object)bitVector.getBit(index), now));
            loopDiscreteAddress = loopDiscreteAddress.increment(1);
        }
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FunctionCode.values().length];
            try {
                nArray[FunctionCode.READ_COIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_DISCRETE_INPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_HOLDING_REGISTERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_INPUT_REGISTERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

