/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.j2mod;

import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.FunctionCode;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.exception.NotYetImplementedException;
import nl.basjes.modbus.device.exception.ReadErrorResponseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J%\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnl/basjes/modbus/device/j2mod/ModbusDeviceJ2Mod;", "Lnl/basjes/modbus/device/api/ModbusDevice;", "master", "Lcom/ghgande/j2mod/modbus/facade/AbstractModbusMaster;", "unitId", "", "<init>", "(Lcom/ghgande/j2mod/modbus/facade/AbstractModbusMaster;I)V", "close", "", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "firstRegister", "Lnl/basjes/modbus/device/api/Address;", "count", "buildRegisterBlock", "firstAddress", "registers", "", "Lcom/ghgande/j2mod/modbus/procimg/InputRegister;", "(Lnl/basjes/modbus/device/api/Address;[Lcom/ghgande/j2mod/modbus/procimg/InputRegister;)Lnl/basjes/modbus/device/api/RegisterBlock;", "modbus-api-j2mod"})
@SourceDebugExtension(value={"SMAP\nModbusDeviceJ2Mod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusDeviceJ2Mod.kt\nnl/basjes/modbus/device/j2mod/ModbusDeviceJ2Mod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class ModbusDeviceJ2Mod
extends ModbusDevice {
    @NotNull
    private final AbstractModbusMaster master;
    private final int unitId;

    public ModbusDeviceJ2Mod(@NotNull AbstractModbusMaster master, int unitId) {
        Intrinsics.checkNotNullParameter((Object)master, (String)"master");
        this.master = master;
        this.unitId = unitId;
        if (!this.master.isConnected()) {
            boolean $i$a$-require-ModbusDeviceJ2Mod$32 = false;
            String $i$a$-require-ModbusDeviceJ2Mod$32 = "The provided master must be connected";
            throw new IllegalArgumentException($i$a$-require-ModbusDeviceJ2Mod$32.toString());
        }
        if (!(this.unitId >= 0 && this.unitId <= 247)) {
            boolean bl = false;
            String string = "The unitId is outside the allowed range [0-247]: " + this.unitId;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public void close() {
        this.master.disconnect();
    }

    @NotNull
    public RegisterBlock getRegisters(@NotNull Address firstRegister, int count) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)firstRegister, (String)"firstRegister");
        FunctionCode functionCode = FunctionCode.Companion.forReading(firstRegister.getAddressClass());
        switch (WhenMappings.$EnumSwitchMapping$0[functionCode.ordinal()]) {
            case 1: 
            case 2: {
                throw new NotYetImplementedException("Reading a " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
            }
            case 3: {
                try {
                    Register[] registerArray = this.master.readMultipleRegisters(this.unitId, firstRegister.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)registerArray, (String)"readMultipleRegisters(...)");
                    Register[] registers = registerArray;
                    return this.buildRegisterBlock(firstRegister, (InputRegister[])registers);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorResponse((Address)firstRegister, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
            case 4: {
                try {
                    InputRegister[] inputRegisterArray = this.master.readInputRegisters(this.unitId, firstRegister.getPhysicalAddress(), count);
                    Intrinsics.checkNotNullExpressionValue((Object)inputRegisterArray, (String)"readInputRegisters(...)");
                    InputRegister[] registers = inputRegisterArray;
                    return this.buildRegisterBlock(firstRegister, registers);
                }
                catch (ModbusSlaveException modbusSlaveException) {
                    return ReadErrorResponseKt.createReadErrorResponse((Address)firstRegister, (int)count);
                }
                catch (com.ghgande.j2mod.modbus.ModbusException e) {
                    throw new ModbusException("For " + functionCode + " & " + firstRegister.getPhysicalAddress() + ":" + e.getMessage(), (Throwable)e);
                }
            }
        }
        throw new NotYetImplementedException("The function code " + functionCode + " for " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
    }

    private final RegisterBlock buildRegisterBlock(Address firstAddress, InputRegister[] registers) {
        long now = System.currentTimeMillis();
        Address loopRegisterAddress = firstAddress;
        RegisterBlock result = new RegisterBlock(firstAddress.getAddressClass());
        for (InputRegister register : registers) {
            result.set(loopRegisterAddress, new RegisterValue(loopRegisterAddress).setValue((short)(register.getValue() & 0xFFFF), now));
            loopRegisterAddress = loopRegisterAddress.increment(1);
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FunctionCode.values().length];
            try {
                nArray[FunctionCode.READ_COIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_DISCRETE_INPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_HOLDING_REGISTERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_INPUT_REGISTERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

