/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.plc4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.FunctionCode;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.exception.NotYetImplementedException;
import nl.basjes.modbus.device.exception.ReadErrorResponseKt;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriverManager;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnl/basjes/modbus/device/plc4j/ModbusDevicePlc4j;", "Lnl/basjes/modbus/device/api/ModbusDevice;", "connectionString", "", "<init>", "(Ljava/lang/String;)V", "connection", "Lorg/apache/plc4x/java/api/PlcConnection;", "close", "", "getAddressClassTag", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "firstRegister", "Lnl/basjes/modbus/device/api/Address;", "count", "", "modbus-api-plc4j"})
public final class ModbusDevicePlc4j
extends ModbusDevice {
    @NotNull
    private final PlcConnection connection;

    public ModbusDevicePlc4j(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        try {
            PlcConnection plcConnection = PlcDriverManager.getDefault().getConnectionManager().getConnection(connectionString);
            Intrinsics.checkNotNullExpressionValue((Object)plcConnection, (String)"getConnection(...)");
            this.connection = plcConnection;
        }
        catch (PlcConnectionException e) {
            throw new ModbusException("Unable to connect to the master", (Throwable)e);
        }
        if (!this.connection.isConnected()) {
            throw new ModbusException("Unable to connect", null, 2, null);
        }
        if (!this.connection.getMetadata().isReadSupported()) {
            throw new ModbusException("This connection doesn't support reading.", null, 2, null);
        }
    }

    public void close() throws ModbusException {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "No message in exception";
            }
            throw new ModbusException(string, (Throwable)e);
        }
    }

    private final String getAddressClassTag(AddressClass addressClass) {
        return addressClass.getLongLabel();
    }

    @NotNull
    public RegisterBlock getRegisters(@NotNull Address firstRegister, int count) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)firstRegister, (String)"firstRegister");
        FunctionCode functionCode = FunctionCode.Companion.forReading(firstRegister.getAddressClass());
        switch (WhenMappings.$EnumSwitchMapping$1[functionCode.ordinal()]) {
            case 1: 
            case 2: {
                throw new NotYetImplementedException("Reading a " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
            }
            case 3: 
            case 4: {
                PlcReadRequest.Builder builder = this.connection.readRequestBuilder();
                String string = "%s:%05d[%d]";
                Object[] objectArray = new Object[]{this.getAddressClassTag(firstRegister.getAddressClass()), firstRegister.getRegisterNumber(), count};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String fieldTag = string2;
                builder.addTag("F", (PlcTag)ModbusTag.of((String)fieldTag));
                CompletableFuture asyncResponse = builder.build().execute();
                PlcReadResponse response = null;
                try {
                    Object t = asyncResponse.get(2L, TimeUnit.SECONDS);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    response = (PlcReadResponse)t;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                long now = System.currentTimeMillis();
                PlcResponseCode plcResponseCode = response.getResponseCode("F");
                switch (plcResponseCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[plcResponseCode.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return ReadErrorResponseKt.createReadErrorRegisterBlock((Address)firstRegister, (int)count);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Address address = firstRegister;
                RegisterBlock result = new RegisterBlock(address.getAddressClass());
                try {
                    Collection allShorts = response.getAllIntegers("F");
                    for (Integer value : allShorts) {
                        result.set(address, new RegisterValue(address).setValue((Object)((short)value.intValue()), now));
                        address = address.increment(1);
                    }
                }
                catch (PlcRuntimeException e) {
                    throw new ModbusException("Got a PlcRuntimeException (" + e.getMessage() + ") on " + fieldTag, (Throwable)e);
                }
                return result;
            }
        }
        throw new NotYetImplementedException("The function code " + functionCode + " for " + firstRegister.getAddressClass() + " has not yet been implemented", null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PlcResponseCode.values().length];
            try {
                nArray[PlcResponseCode.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.NOT_FOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.ACCESS_DENIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.INVALID_ADDRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.INVALID_DATATYPE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.INVALID_DATA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.INTERNAL_ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.REMOTE_BUSY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.REMOTE_ERROR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.UNSUPPORTED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlcResponseCode.RESPONSE_PENDING.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FunctionCode.values().length];
            try {
                nArray[FunctionCode.READ_COIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_DISCRETE_INPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_HOLDING_REGISTERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FunctionCode.READ_INPUT_REGISTERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

