/*
 * Modbus Schema Toolkit
 * Copyright (C) 2019-2025 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.basjes.modbus.device.testcases

import nl.basjes.modbus.device.api.Address
import nl.basjes.modbus.device.memory.MockedModbusDevice
import nl.basjes.modbus.device.memory.MockedModbusDevice.Companion.builder

object DeviceThermiaGenesisDated20250518 {
    @JvmStatic
    val device: MockedModbusDevice
        get() =
            // Extracted on 2025-05-18 from my Thermia Calibra Cool 7 running Genesis 11
            builder()
                .withLogging()
                .withRegisters(
                    Address.of("ir:00001"),
                    """
                    0063 0400 0000 0384 0000 0000 0879 087A 0992 07B6
                    07F7 4E20 07A1 07A1 1258 1175 11C4 0000 0BB8 06A4
                    03E8 01F4 0000 FE0C FA24 F63C 4E20 0000 0000 0000
                    0000 0000 0000 0000 0000 FFE7 0000 0000 0000 4E20
                    4E20 2710 0000 0000 4E20 0001 0000 0000 232D 0000
                    05DF 0000 0000 0000 0063 0063 000B 0000 00C5 0000
                    0000 0063 0063 0063 0063 0063 0000 0000 0000 0000
                    0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
                    0000 0004 0000 0000 0000 0000 0000 0000 0000 0000
                    C3DC 0000 0000 0000 4E20 4E20 4E20 4E20 4E20 4E20
                    4E20 0064 4E20 4E20 4E20 4E20 4E20 0000 4E20 4E20
                    4E20 4E20 4E20 4E20 4E20 4E20 4E20 4E20 4E20 4E20
                    00D6 0869 0875 0653 01F2 000D 04AC 0582 0850 0847
                    0096 0000 0000 0000 0000 0000 0000 0000 0000 0000
                    0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
                    0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
                    0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
                    0000 0000 0000 ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    000B 0000 000C 0001 0000 0000 0000 0000 0016
                    """.trimIndent(),
                ).withRegisters(
                    Address.of("hr:00000"),
                    """
                    0003 0000 0000 1194 07D0 0802 0834 09C4 0AF0 0C1C
                    0C80 0E10 0FA0 0000 0000 0000 06A4 0000 0000 0000
                    0000 0000 1130 1770 0000 0000 0001 0009 0007 0005
                    0708 1770 1194 0000 2710 1770 0000 1964 05DC 2710
                    0000 2710 0000 2710 0000 2710 0000 2710 1194 0000
                    2710 1388 1F40 07D0 0FA0 0000 2710 0002 0A28 0000
                    2710 012C 012C 003C 00B4 000A 001E 07D0 FE0C 00C8
                    04B0 1964 1770 30D4 0001 FFFA 0FA0 07D0 0190 2710
                    2710 1388 1388 0001 0001 0001 0009 0001 0009 ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- 0708 0514 03E8 1770 0834
                    0B54 0D48 0FA0 10CC 13EC 170C 09C4 0000 4E20 XXXX
                    XXXX ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- 03E8
                    1770 0834 0B54 0D48 0FA0 10CC 13EC 170C 03E8 1770
                    0834 0B54 0D48 0FA0 10CC 13EC 170C ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- 03E8
                    1770 0834 0B54 0D48 0FA0 10CC 13EC 170C 03E8 1770
                    0834 0B54 0D48 0FA0 10CC 13EC 170C ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- ---- ----
                    ---- ---- ---- ---- ---- ---- ---- ---- 0000 00C8
                    000A xxxx 06A4 076C 03E8 0000 06A4 0017 0011 0000
                    06A4 0017 0011 0000 06A4 0017 0011 0000 06A4 0017
                    0011 XXXX
                    """.trimIndent(),
                ).build()
}
