/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.testcases.sunspec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.testcases.sunspec.SunSpecBasicsPrinterKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter;", "", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/device/api/ModbusDevice;)V", "sunSpecChainHeaderSize", "", "print", "", "onlyModelHeaders", "", "SunSpecModelHeader", "Companion", "modbus-api-testing"})
@SourceDebugExtension(value={"SMAP\nSunSpecBasicsPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SunSpecBasicsPrinter.kt\nnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n37#2:177\n36#2,3:178\n1#3:181\n*S KotlinDebug\n*F\n+ 1 SunSpecBasicsPrinter.kt\nnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter\n*L\n62#1:177\n62#1:178,3\n*E\n"})
public final class SunSpecBasicsPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModbusDevice modbusDevice;
    private final int sunSpecChainHeaderSize;
    @NotNull
    private static final Logger LOG;

    public SunSpecBasicsPrinter(@NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.modbusDevice = modbusDevice;
        this.sunSpecChainHeaderSize = 2;
    }

    public final void print(boolean onlyModelHeaders) {
        List sunSpecModels = new ArrayList();
        Address sunSpecFirstModelAddress = null;
        RegisterBlock fullDump = new RegisterBlock(AddressClass.HOLDING_REGISTER);
        for (Address sunSpecChainStartAddress : SunSpecBasicsPrinterKt.access$getSunSpecStandardStartPhysicalAddress$p()) {
            LOG.info("Looking for SunSpec header at {}", (Object)sunSpecChainStartAddress);
            RegisterBlock registers = this.modbusDevice.getRegisters(sunSpecChainStartAddress, 2);
            Object $this$toTypedArray$iv = registers.getValues();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RegisterValue[] registerValues = thisCollection$iv.toArray(new RegisterValue[0]);
            fullDump.merge(registers);
            if (registerValues.length < 2) continue;
            $this$toTypedArray$iv = registerValues[0].getValue();
            boolean bl = $this$toTypedArray$iv != null ? 21365 == (Short)$this$toTypedArray$iv : false;
            if (!bl) continue;
            $this$toTypedArray$iv = registerValues[1].getValue();
            boolean bl2 = $this$toTypedArray$iv != null ? 28243 == (Short)$this$toTypedArray$iv : false;
            if (!bl2) continue;
            sunSpecFirstModelAddress = sunSpecChainStartAddress.increment(this.sunSpecChainHeaderSize);
            LOG.info("Found the SunSpec header at {}", (Object)sunSpecChainStartAddress);
            break;
        }
        if (!(sunSpecFirstModelAddress != null)) {
            boolean $i$a$-require-SunSpecBasicsPrinter$print$22 = false;
            String $i$a$-require-SunSpecBasicsPrinter$print$22 = "Unable to locate the SunSpec address";
            throw new IllegalArgumentException($i$a$-require-SunSpecBasicsPrinter$print$22.toString());
        }
        Address modelAddress = sunSpecFirstModelAddress;
        int modelId = 0;
        SunSpecModelHeader sunSpecModelHeader = null;
        do {
            sunSpecModelHeader = new SunSpecModelHeader(this.modbusDevice, modelAddress);
            sunSpecModels.add(sunSpecModelHeader);
            LOG.info("Model: {}", (Object)sunSpecModelHeader);
            modelAddress = modelAddress.increment(2 + sunSpecModelHeader.getModelSize());
        } while ((modelId = sunSpecModelHeader.getModelId()) != -1 && modelId != 0);
        if (onlyModelHeaders) {
            return;
        }
        sunSpecModels.remove(sunSpecModelHeader);
        for (SunSpecModelHeader sunSpecModel : sunSpecModels) {
            LOG.info("--- LOADING: {}", (Object)sunSpecModel);
            sunSpecModel.loadRegisters(this.modbusDevice);
            fullDump.merge(sunSpecModel.getHeader());
            fullDump.merge(sunSpecModel.getRegisters());
            LOG.info("+++ SUCCESS: {}", (Object)sunSpecModel);
        }
        LOG.info("FullDump: {}", (Object)fullDump);
        Collection values = fullDump.getValues();
        if (!(!values.isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Address dumpAddress = ((RegisterValue)CollectionsKt.first((Iterable)values)).getAddress();
        for (RegisterValue value : values) {
            while (!Intrinsics.areEqual((Object)dumpAddress, (Object)value.getAddress())) {
                RegisterValue unknownValue = new RegisterValue(dumpAddress).setValue((short)-1, 0L);
                LOG.info("{} -------", (Object)unknownValue);
                dumpAddress = Address.increment$default((Address)dumpAddress, (int)0, (int)1, null);
            }
            LOG.info("{}", (Object)value);
            dumpAddress = Address.increment$default((Address)dumpAddress, (int)0, (int)1, null);
        }
    }

    public static /* synthetic */ void print$default(SunSpecBasicsPrinter sunSpecBasicsPrinter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        sunSpecBasicsPrinter.print(bl);
    }

    static {
        Logger logger = LogManager.getLogger((String)"SunSpec TEST Printer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-api-testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter$SunSpecModelHeader;", "", "device", "Lnl/basjes/modbus/device/api/ModbusDevice;", "address", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Lnl/basjes/modbus/device/api/ModbusDevice;Lnl/basjes/modbus/device/api/Address;)V", "modelAddress", "getModelAddress", "()Lnl/basjes/modbus/device/api/Address;", "modelId", "", "getModelId", "()I", "modelSize", "getModelSize", "header", "Lnl/basjes/modbus/device/api/RegisterBlock;", "getHeader", "()Lnl/basjes/modbus/device/api/RegisterBlock;", "registers", "getRegisters", "loadRegisters", "", "toString", "", "modbus-api-testing"})
    @SourceDebugExtension(value={"SMAP\nSunSpecBasicsPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SunSpecBasicsPrinter.kt\nnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter$SunSpecModelHeader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,176:1\n37#2:177\n36#2,3:178\n*S KotlinDebug\n*F\n+ 1 SunSpecBasicsPrinter.kt\nnl/basjes/modbus/device/testcases/sunspec/SunSpecBasicsPrinter$SunSpecModelHeader\n*L\n142#1:177\n142#1:178,3\n*E\n"})
    private static final class SunSpecModelHeader {
        @NotNull
        private final Address modelAddress;
        private final int modelId;
        private final int modelSize;
        @NotNull
        private final RegisterBlock header;
        @NotNull
        private final RegisterBlock registers;

        public SunSpecModelHeader(@NotNull ModbusDevice device, @NotNull Address address) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            RegisterBlock modelHeader = device.getRegisters(address, 2);
            Collection $this$toTypedArray$iv = modelHeader.getValues();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RegisterValue[] modelHeaderValues = thisCollection$iv.toArray(new RegisterValue[0]);
            Short s = modelHeaderValues[0].getValue();
            Intrinsics.checkNotNull((Object)s);
            this.modelId = s.shortValue();
            Short s2 = modelHeaderValues[1].getValue();
            Intrinsics.checkNotNull((Object)s2);
            this.modelSize = s2.shortValue();
            this.header = new RegisterBlock(address.getAddressClass());
            this.registers = new RegisterBlock(address.getAddressClass());
            this.header.merge(modelHeader);
            this.modelAddress = address.increment(2);
        }

        @NotNull
        public final Address getModelAddress() {
            return this.modelAddress;
        }

        public final int getModelId() {
            return this.modelId;
        }

        public final int getModelSize() {
            return this.modelSize;
        }

        @NotNull
        public final RegisterBlock getHeader() {
            return this.header;
        }

        @NotNull
        public final RegisterBlock getRegisters() {
            return this.registers;
        }

        public final void loadRegisters(@NotNull ModbusDevice device) throws ModbusException {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Address readAddress = this.modelAddress;
            int toRead = this.modelSize;
            int readSize = 125;
            while (toRead > 125) {
                this.registers.merge(device.getRegisters(readAddress, readSize));
                toRead -= readSize;
                readAddress = readAddress.increment(readSize);
            }
            this.registers.merge(device.getRegisters(readAddress, toRead));
        }

        @NotNull
        public String toString() {
            return "SunSpecModel{" + this.modelAddress + ", Id=" + this.modelId + ", Size=" + this.modelSize + ", registers= [" + CollectionsKt.joinToString$default((Iterable)this.registers.getValues(), (CharSequence)", ", null, null, (int)0, null, SunSpecModelHeader::toString$lambda$0, (int)30, null) + "]}";
        }

        private static final CharSequence toString$lambda$0(RegisterValue it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "0x" + it.getHexValue();
        }
    }
}

