/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"REGISTER_TAG_COLON_FORMAT", "Lkotlin/text/Regex;", "REGISTER_TAG_X_FORMAT", "REGISTER_TAG_56DIGIT_FORMAT", "asAddressAssumingModicon5", "Lnl/basjes/modbus/device/api/Address;", "", "asAddressAssumingModicon6", "asAddress", "", "addressFrom", "Lkotlin/Pair;", "Lnl/basjes/modbus/device/api/AddressClass;", "registerTag", "addressFromModicon5", "addressFromModicon6", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Address.kt\nnl/basjes/modbus/device/api/AddressKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,263:1\n1#2:264\n108#3:265\n80#3,22:266\n*S KotlinDebug\n*F\n+ 1 Address.kt\nnl/basjes/modbus/device/api/AddressKt\n*L\n227#1:265\n227#1:266,22\n*E\n"})
public final class AddressKt {
    @NotNull
    private static final Regex REGISTER_TAG_COLON_FORMAT = new Regex("^([a-zA-Z-]+):(\\d+)$");
    @NotNull
    private static final Regex REGISTER_TAG_X_FORMAT = new Regex("^(\\d)x(\\d+)$");
    @NotNull
    private static final Regex REGISTER_TAG_56DIGIT_FORMAT = new Regex("^(\\d)(\\d{4,5})$");

    @NotNull
    public static final Address asAddressAssumingModicon5(int $this$asAddressAssumingModicon5) {
        return Address.Companion.ofModicon5($this$asAddressAssumingModicon5);
    }

    @NotNull
    public static final Address asAddressAssumingModicon6(int $this$asAddressAssumingModicon6) {
        return Address.Companion.ofModicon6($this$asAddressAssumingModicon6);
    }

    @NotNull
    public static final Address asAddress(@NotNull String $this$asAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$asAddress, (String)"<this>");
        return Address.Companion.of($this$asAddress);
    }

    private static final Pair<AddressClass, Integer> addressFrom(int registerTag) {
        Object v0;
        int modiconRegisterNumber;
        block3: {
            if (registerTag < 0 || registerTag > 99999) {
                throw new IllegalArgumentException("Unable to parse the provided register tag \"" + registerTag + "\".");
            }
            int modiconAddressClass = registerTag / 10000;
            modiconRegisterNumber = registerTag - modiconAddressClass * 10000;
            Iterable iterable = (Iterable)AddressClass.getEntries();
            for (Object t : iterable) {
                AddressClass it = (AddressClass)((Object)t);
                boolean bl = false;
                if (!(it.getBaseOffset() == modiconAddressClass)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        AddressClass addressClass = v0;
        if (addressClass == null) {
            throw new IllegalArgumentException("Unable to parse the provided register tag \"" + registerTag + "\".");
        }
        return new Pair((Object)addressClass, (Object)(modiconRegisterNumber - addressClass.getRegisterNumberOffset()));
    }

    private static final Pair<AddressClass, Integer> addressFromModicon5(int registerTag) {
        return AddressKt.addressFrom(registerTag);
    }

    private static final Pair<AddressClass, Integer> addressFromModicon6(int registerTag) {
        Object v0;
        int modiconRegisterNumber;
        block2: {
            int modiconAddressClass = registerTag / 100000;
            modiconRegisterNumber = registerTag - modiconAddressClass * 100000;
            Iterable iterable = (Iterable)AddressClass.getEntries();
            for (Object t : iterable) {
                AddressClass it = (AddressClass)((Object)t);
                boolean bl = false;
                if (!(it.getBaseOffset() == modiconAddressClass)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        AddressClass addressClass = v0;
        if (addressClass == null) {
            throw new IllegalArgumentException("Unable to parse the provided register tag \"" + registerTag + "\".");
        }
        return new Pair((Object)addressClass, (Object)(modiconRegisterNumber - addressClass.getRegisterNumberOffset()));
    }

    private static final Pair<AddressClass, Integer> addressFrom(String registerTag) {
        String cleanedTag;
        MatchResult tagColonResult;
        String string = registerTag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((tagColonResult = Regex.find$default((Regex)REGISTER_TAG_COLON_FORMAT, (CharSequence)(cleanedTag = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (int)0, (int)2, null)) != null) {
            String addressClassCode = (String)tagColonResult.getGroupValues().get(1);
            AddressClass addressClass = AddressClass.Companion.of(addressClassCode);
            int physicalAddress = Integer.parseInt((String)tagColonResult.getGroupValues().get(2));
            return new Pair((Object)addressClass, (Object)physicalAddress);
        }
        MatchResult tagXResult = Regex.find$default((Regex)REGISTER_TAG_X_FORMAT, (CharSequence)cleanedTag, (int)0, (int)2, null);
        if (tagXResult != null) {
            String addressClassCode = (String)tagXResult.getGroupValues().get(1);
            AddressClass addressClass = AddressClass.Companion.of(addressClassCode);
            int registerNumber = Integer.parseInt((String)tagXResult.getGroupValues().get(2));
            int physicalAddress = registerNumber - addressClass.getRegisterNumberOffset();
            return new Pair((Object)addressClass, (Object)physicalAddress);
        }
        MatchResult tag56DigitResult = Regex.find$default((Regex)REGISTER_TAG_56DIGIT_FORMAT, (CharSequence)cleanedTag, (int)0, (int)2, null);
        if (tag56DigitResult != null) {
            String addressClassCode = (String)tag56DigitResult.getGroupValues().get(1);
            AddressClass addressClass = AddressClass.Companion.of(addressClassCode);
            int registerNumber = Integer.parseInt((String)tag56DigitResult.getGroupValues().get(2));
            int physicalAddress = registerNumber - addressClass.getRegisterNumberOffset();
            return new Pair((Object)addressClass, (Object)physicalAddress);
        }
        throw new IllegalArgumentException("Unable to parse the provided register tag \"" + registerTag + "\".");
    }

    public static final /* synthetic */ Pair access$addressFromModicon5(int registerTag) {
        return AddressKt.addressFromModicon5(registerTag);
    }

    public static final /* synthetic */ Pair access$addressFromModicon6(int registerTag) {
        return AddressKt.addressFromModicon6(registerTag);
    }

    public static final /* synthetic */ Pair access$addressFrom(String registerTag) {
        return AddressKt.addressFrom(registerTag);
    }
}

