/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.AddressClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006!"}, d2={"Lnl/basjes/modbus/device/api/FunctionCode;", "", "code", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "forWriting", "", "forWritingMultiple", "enumName", "", "readableName", "<init>", "(Ljava/lang/String;IILnl/basjes/modbus/device/api/AddressClass;ZZLjava/lang/String;Ljava/lang/String;)V", "getEnumName", "()Ljava/lang/String;", "getReadableName", "READ_COIL", "READ_DISCRETE_INPUT", "READ_HOLDING_REGISTERS", "READ_INPUT_REGISTERS", "WRITE_SINGLE_COIL", "WRITE_SINGLE_HOLDING_REGISTER", "WRITE_MULTIPLE_COILS", "WRITE_MULTIPLE_HOLDING_REGISTERS", "bitsPerValue", "getBitsPerValue", "()I", "isForReading", "()Z", "isForWritableSingle", "toString", "Companion", "modbus-api"})
public final class FunctionCode
extends Enum<FunctionCode> {
    @NotNull
    public static final Companion Companion;
    private final int code;
    @NotNull
    private final AddressClass addressClass;
    private final boolean forWriting;
    private final boolean forWritingMultiple;
    @NotNull
    private final String enumName;
    @NotNull
    private final String readableName;
    private final int bitsPerValue;
    public static final /* enum */ FunctionCode READ_COIL;
    public static final /* enum */ FunctionCode READ_DISCRETE_INPUT;
    public static final /* enum */ FunctionCode READ_HOLDING_REGISTERS;
    public static final /* enum */ FunctionCode READ_INPUT_REGISTERS;
    public static final /* enum */ FunctionCode WRITE_SINGLE_COIL;
    public static final /* enum */ FunctionCode WRITE_SINGLE_HOLDING_REGISTER;
    public static final /* enum */ FunctionCode WRITE_MULTIPLE_COILS;
    public static final /* enum */ FunctionCode WRITE_MULTIPLE_HOLDING_REGISTERS;
    private static final /* synthetic */ FunctionCode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private FunctionCode(int code, AddressClass addressClass, boolean forWriting, boolean forWritingMultiple, String enumName, String readableName) {
        this.code = code;
        this.addressClass = addressClass;
        this.forWriting = forWriting;
        this.forWritingMultiple = forWritingMultiple;
        this.enumName = enumName;
        this.readableName = readableName;
        this.bitsPerValue = this.addressClass.getBitsPerValue();
    }

    @NotNull
    public final String getEnumName() {
        return this.enumName;
    }

    @NotNull
    public final String getReadableName() {
        return this.readableName;
    }

    public final int getBitsPerValue() {
        return this.bitsPerValue;
    }

    public final boolean isForReading() {
        return !this.forWriting;
    }

    public final boolean isForWritableSingle() {
        return this.forWriting && !this.forWritingMultiple;
    }

    @NotNull
    public String toString() {
        return super.toString() + "(" + this.code + ")";
    }

    public static FunctionCode[] values() {
        return (FunctionCode[])$VALUES.clone();
    }

    public static FunctionCode valueOf(String value) {
        return Enum.valueOf(FunctionCode.class, value);
    }

    @NotNull
    public static EnumEntries<FunctionCode> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final FunctionCode of(int code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final FunctionCode forReading(@NotNull AddressClass addressClass) {
        return Companion.forReading(addressClass);
    }

    @JvmStatic
    @NotNull
    public static final FunctionCode forWritingSingle(@NotNull AddressClass addressClass) {
        return Companion.forWritingSingle(addressClass);
    }

    @JvmStatic
    @NotNull
    public static final FunctionCode forWritingMultiple(@NotNull AddressClass addressClass) {
        return Companion.forWritingMultiple(addressClass);
    }

    static {
        READ_COIL = new FunctionCode(1, AddressClass.COIL, false, false, "READ_COIL", "Read Coil");
        READ_DISCRETE_INPUT = new FunctionCode(2, AddressClass.DISCRETE_INPUT, false, false, "READ_DISCRETE_INPUT", "Read Discrete Input");
        READ_HOLDING_REGISTERS = new FunctionCode(3, AddressClass.HOLDING_REGISTER, false, false, "READ_HOLDING_REGISTERS", "Read Holding Registers");
        READ_INPUT_REGISTERS = new FunctionCode(4, AddressClass.INPUT_REGISTER, false, false, "READ_INPUT_REGISTERS", "Read Input Registers");
        WRITE_SINGLE_COIL = new FunctionCode(5, AddressClass.COIL, true, false, "WRITE_SINGLE_COIL", "Write Single Coil");
        WRITE_SINGLE_HOLDING_REGISTER = new FunctionCode(6, AddressClass.HOLDING_REGISTER, true, false, "WRITE_SINGLE_HOLDING_REGISTER", "Write Single Holding Register");
        WRITE_MULTIPLE_COILS = new FunctionCode(15, AddressClass.COIL, true, true, "WRITE_MULTIPLE_COILS", "Write Multiple Coils");
        WRITE_MULTIPLE_HOLDING_REGISTERS = new FunctionCode(16, AddressClass.HOLDING_REGISTER, true, true, "WRITE_MULTIPLE_HOLDING_REGISTERS", "Write Multiple Holding Registers");
        $VALUES = functionCodeArray = new FunctionCode[]{FunctionCode.READ_COIL, FunctionCode.READ_DISCRETE_INPUT, FunctionCode.READ_HOLDING_REGISTERS, FunctionCode.READ_INPUT_REGISTERS, FunctionCode.WRITE_SINGLE_COIL, FunctionCode.WRITE_SINGLE_HOLDING_REGISTER, FunctionCode.WRITE_MULTIPLE_COILS, FunctionCode.WRITE_MULTIPLE_HOLDING_REGISTERS};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lnl/basjes/modbus/device/api/FunctionCode$Companion;", "", "<init>", "()V", "of", "Lnl/basjes/modbus/device/api/FunctionCode;", "code", "", "forReading", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "forWritingSingle", "forWritingMultiple", "modbus-api"})
    @SourceDebugExtension(value={"SMAP\nFunctionCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionCode.kt\nnl/basjes/modbus/device/api/FunctionCode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n295#2,2:119\n774#2:121\n865#2,2:122\n774#2:124\n865#2,2:125\n774#2:127\n865#2,2:128\n295#2,2:130\n774#2:132\n865#2,2:133\n295#2,2:135\n*S KotlinDebug\n*F\n+ 1 FunctionCode.kt\nnl/basjes/modbus/device/api/FunctionCode$Companion\n*L\n73#1:119,2\n85#1:121\n85#1:122,2\n86#1:124\n86#1:125,2\n99#1:127\n99#1:128,2\n100#1:130,2\n112#1:132\n112#1:133,2\n113#1:135,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FunctionCode of(int code) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = (Iterable)FunctionCode.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionCode it = (FunctionCode)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.code == code)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            FunctionCode functionCode = v0;
            if (functionCode == null) {
                throw new IllegalArgumentException("The provided function code value " + code + " is not supported.");
            }
            return functionCode;
        }

        @JvmStatic
        @NotNull
        public final FunctionCode forReading(@NotNull AddressClass addressClass) {
            FunctionCode it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
            Iterable $this$filter$iv = (Iterable)FunctionCode.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FunctionCode)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it.addressClass == addressClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FunctionCode)((Object)element$iv$iv);
                boolean bl = false;
                if (!it.isForReading()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            FunctionCode functionCode = (FunctionCode)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (functionCode == null) {
                throw new IllegalArgumentException("Unable to find the read function code for " + addressClass + ".");
            }
            return functionCode;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final FunctionCode forWritingSingle(@NotNull AddressClass addressClass) {
            Object v0;
            block3: {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
                Iterable $this$filter$iv = (Iterable)FunctionCode.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FunctionCode it = (FunctionCode)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(it.addressClass == addressClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionCode it = (FunctionCode)((Object)element$iv);
                    boolean bl = false;
                    if (!it.isForWritableSingle()) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            FunctionCode functionCode = v0;
            if (functionCode == null) {
                throw new IllegalArgumentException("Unable to find the write single function code for " + addressClass + ".");
            }
            return functionCode;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final FunctionCode forWritingMultiple(@NotNull AddressClass addressClass) {
            Object v0;
            block3: {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
                Iterable $this$filter$iv = (Iterable)FunctionCode.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FunctionCode it = (FunctionCode)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!(it.addressClass == addressClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionCode it = (FunctionCode)((Object)element$iv);
                    boolean bl = false;
                    if (!it.forWritingMultiple) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            FunctionCode functionCode = v0;
            if (functionCode == null) {
                throw new IllegalArgumentException("Unable to find the write multiple function code for " + addressClass + ".");
            }
            return functionCode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

