/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.RegisterValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0086\u0002J\"\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0%J\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000bJ\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0(J\u0018\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nJ\u001e\u0010+\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010'\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0000J\u0015\u00101\u001a\u0004\u0018\u00010,2\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u00102J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0(J\f\u00104\u001a\b\u0012\u0004\u0012\u0002050(J\u0006\u00106\u001a\u000205J\b\u00107\u001a\u000205H\u0016J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010;\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010<\u001a\u00020\u0000J\b\u0010=\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00170\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006>"}, d2={"Lnl/basjes/modbus/device/api/RegisterBlock;", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "<init>", "(Lnl/basjes/modbus/device/api/AddressClass;)V", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "registerValues", "Ljava/util/TreeMap;", "Lnl/basjes/modbus/device/api/Address;", "Lnl/basjes/modbus/device/api/RegisterValue;", "clear", "", "get", "address", "set", "registerValue", "firstAddress", "getFirstAddress", "()Lnl/basjes/modbus/device/api/Address;", "keys", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getKeys", "()Ljava/util/Set;", "values", "", "getValues", "()Ljava/util/Collection;", "size", "", "getSize", "()I", "computeIfAbsent", "requiredRegister", "function", "Lkotlin/Function1;", "put", "value", "", "addresses", "key", "setValue", "", "timestamp", "", "merge", "registerBlock", "getValue", "(Lnl/basjes/modbus/device/api/Address;)Ljava/lang/Short;", "noGapsValuesList", "toHexList", "", "toHexString", "toString", "equals", "", "other", "assertAddressClass", "clone", "hashCode", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nRegisterBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterBlock.kt\nnl/basjes/modbus/device/api/RegisterBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1869#2,2:236\n1563#2:238\n1634#2,3:239\n1563#2:243\n1634#2,3:244\n1#3:242\n*S KotlinDebug\n*F\n+ 1 RegisterBlock.kt\nnl/basjes/modbus/device/api/RegisterBlock\n*L\n34#1:236,2\n79#1:238\n79#1:239,3\n137#1:243\n137#1:244,3\n*E\n"})
public final class RegisterBlock {
    @NotNull
    private final AddressClass addressClass;
    @NotNull
    private final TreeMap<Address, RegisterValue> registerValues;

    public RegisterBlock(@NotNull AddressClass addressClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
        this.addressClass = addressClass;
        this.registerValues = new TreeMap();
    }

    @NotNull
    public final AddressClass getAddressClass() {
        return this.addressClass;
    }

    public final void clear() {
        Collection<RegisterValue> collection = this.registerValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisterValue it = (RegisterValue)element$iv;
            boolean bl = false;
            it.clear();
        }
    }

    @NotNull
    public final RegisterValue get(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        RegisterValue returnValue = this.registerValues.get(address);
        if (returnValue == null) {
            returnValue = new RegisterValue(address);
            ((Map)this.registerValues).put(address, returnValue);
        }
        return returnValue;
    }

    public final void set(@NotNull Address address, @NotNull RegisterValue registerValue) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)registerValue, (String)"registerValue");
        if (this.registerValues.get(address) != null && registerValue.hasValue()) {
            Address address2 = registerValue.getAddress();
            Short s = registerValue.getValue();
            Intrinsics.checkNotNull((Object)s);
            this.setValue(address2, s, registerValue.getTimestamp());
        } else {
            ((Map)this.registerValues).put(address, registerValue);
        }
        this.registerValues.keySet();
    }

    @NotNull
    public final Address getFirstAddress() {
        Address address = this.registerValues.firstKey();
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"firstKey(...)");
        return address;
    }

    @NotNull
    public final Set<Address> getKeys() {
        Set<Address> set = this.registerValues.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Collection<RegisterValue> getValues() {
        Collection<RegisterValue> collection = this.registerValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final int getSize() {
        return this.registerValues.size();
    }

    @NotNull
    public final RegisterValue computeIfAbsent(@NotNull Address requiredRegister, @NotNull Function1<? super Address, RegisterValue> function) {
        Intrinsics.checkNotNullParameter((Object)requiredRegister, (String)"requiredRegister");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        RegisterValue registerValue = this.registerValues.computeIfAbsent(requiredRegister, arg_0 -> RegisterBlock.computeIfAbsent$lambda$1(function, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)registerValue, (String)"computeIfAbsent(...)");
        return registerValue;
    }

    public final void put(@NotNull RegisterValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.hasValue()) {
            Address address = value.getAddress();
            Short s = value.getValue();
            Intrinsics.checkNotNull((Object)s);
            this.setValue(address, s, value.getTimestamp());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RegisterValue> get(@NotNull List<Address> addresses) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Iterable $this$map$iv = addresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            Address address = (Address)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.registerValues.get(key));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final RegisterValue put(@NotNull Address key, @NotNull RegisterValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.assertAddressClass(key.getAddressClass());
        if (!Intrinsics.areEqual((Object)key, (Object)value.getAddress())) {
            boolean bl = false;
            String string = "The address MUST be the same as the address in the register value";
            throw new IllegalArgumentException(string.toString());
        }
        return this.registerValues.put(key, value);
    }

    public final void setValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.assertAddressClass(address.getAddressClass());
        this.registerValues.computeIfAbsent(address, arg_0 -> RegisterBlock.setValue$lambda$5(arg_0 -> RegisterBlock.setValue$lambda$4(address, arg_0), arg_0));
    }

    public final void setValue(@NotNull Address address, short value, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.assertAddressClass(address.getAddressClass());
        this.registerValues.computeIfAbsent(address, arg_0 -> RegisterBlock.setValue$lambda$7(arg_0 -> RegisterBlock.setValue$lambda$6(address, arg_0), arg_0)).setValue(value, timestamp);
    }

    public final void merge(@NotNull RegisterBlock registerBlock) {
        Intrinsics.checkNotNullParameter((Object)registerBlock, (String)"registerBlock");
        this.assertAddressClass(registerBlock.addressClass);
        Iterator<RegisterValue> iterator = registerBlock.registerValues.values().iterator();
        while (iterator.hasNext()) {
            RegisterValue registerValue;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.put(registerValue);
        }
    }

    @Nullable
    public final Short getValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        RegisterValue registerValue = this.registerValues.get(address);
        if (registerValue == null) {
            return null;
        }
        RegisterValue registerValue2 = registerValue;
        return registerValue2.getValue();
    }

    @NotNull
    public final List<RegisterValue> noGapsValuesList() {
        List result = new ArrayList();
        if (!this.registerValues.isEmpty()) {
            Address address = this.registerValues.firstKey();
            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"firstKey(...)");
            Address expectedNextAddress = address;
            Iterator<RegisterValue> iterator = this.registerValues.values().iterator();
            while (iterator.hasNext()) {
                RegisterValue value;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                while (!Intrinsics.areEqual((Object)value.getAddress(), (Object)expectedNextAddress)) {
                    result.add(new RegisterValue(expectedNextAddress));
                    expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
                }
                result.add(value);
                expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toHexList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.noGapsValuesList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RegisterValue registerValue = (RegisterValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHexValue());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String toHexString() {
        return CollectionsKt.joinToString$default((Iterable)this.toHexList(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String toString() {
        return "Starting at " + this.registerValues.firstKey().toCleanFormat() + ": [ " + this.toHexString() + " ]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegisterBlock)) {
            return false;
        }
        if (this.addressClass != ((RegisterBlock)other).addressClass) {
            return false;
        }
        return super.equals(other);
    }

    private final void assertAddressClass(AddressClass addressClass) {
        if (this.addressClass == addressClass) {
            return;
        }
        throw new IllegalArgumentException("Trying to use the AddressClass \"" + addressClass + "\" on a RegisterBlock which only allows AddressClass \"" + addressClass + "\"");
    }

    @NotNull
    public final RegisterBlock clone() {
        RegisterBlock result = new RegisterBlock(this.addressClass);
        Iterator<RegisterValue> iterator = this.registerValues.values().iterator();
        while (iterator.hasNext()) {
            RegisterValue value;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            RegisterValue registerValue = new RegisterValue(value.getAddress());
            if (value.hasValue()) {
                Short s = value.getValue();
                Intrinsics.checkNotNull((Object)s);
                registerValue.setValue(s, value.getTimestamp());
            }
            registerValue.setImmutable(value.getImmutable());
            registerValue.setFetchGroup(value.getFetchGroup());
            ((Map)result.registerValues).put(value.getAddress(), registerValue);
            registerValue.setComment(value.getComment());
        }
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.addressClass.hashCode();
        return result;
    }

    private static final RegisterValue computeIfAbsent$lambda$1(Function1 $tmp0, Object p0) {
        return (RegisterValue)$tmp0.invoke(p0);
    }

    private static final RegisterValue setValue$lambda$4(Address $address, Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue($address);
    }

    private static final RegisterValue setValue$lambda$5(Function1 $tmp0, Object p0) {
        return (RegisterValue)$tmp0.invoke(p0);
    }

    private static final RegisterValue setValue$lambda$6(Address $address, Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue($address);
    }

    private static final RegisterValue setValue$lambda$7(Function1 $tmp0, Object p0) {
        return (RegisterValue)$tmp0.invoke(p0);
    }
}

