/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u000fJ\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001dJ\u0006\u0010'\u001a\u00020(J\b\u0010+\u001a\u00020\tH\u0016J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010/\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u000100H\u0096\u0002J\b\u00101\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010)\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000b\u00a8\u00062"}, d2={"Lnl/basjes/modbus/device/api/RegisterValue;", "", "address", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Lnl/basjes/modbus/device/api/Address;)V", "getAddress", "()Lnl/basjes/modbus/device/api/Address;", "fetchGroup", "", "getFetchGroup", "()Ljava/lang/String;", "setFetchGroup", "(Ljava/lang/String;)V", "immutable", "", "getImmutable", "()Z", "setImmutable", "(Z)V", "value", "", "getValue", "()Ljava/lang/Short;", "Ljava/lang/Short;", "comment", "getComment", "setComment", "timestamp", "", "getTimestamp", "()J", "setTimestamp", "(J)V", "setValue", "hasValue", "needsToBeUpdated", "now", "maxAge", "clear", "", "hexValue", "getHexValue", "toString", "compareTo", "", "other", "equals", "", "hashCode", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nRegisterValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterValue.kt\nnl/basjes/modbus/device/api/RegisterValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class RegisterValue
implements Comparable<RegisterValue> {
    @NotNull
    private final Address address;
    @NotNull
    private String fetchGroup;
    private boolean immutable;
    @Nullable
    private Short value;
    @Nullable
    private String comment;
    private long timestamp;

    public RegisterValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        this.fetchGroup = "FG_" + this.address.toCleanFormat();
        this.timestamp = Long.MIN_VALUE;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @NotNull
    public final String getFetchGroup() {
        return this.fetchGroup;
    }

    public final void setFetchGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fetchGroup = string;
    }

    public final boolean getImmutable() {
        return this.immutable;
    }

    public final void setImmutable(boolean bl) {
        this.immutable = bl;
    }

    @Nullable
    public final Short getValue() {
        return this.value;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@Nullable String string) {
        this.comment = string;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(long l) {
        this.timestamp = l;
    }

    @NotNull
    public final RegisterValue setValue(short value) {
        return this.setValue(value, System.currentTimeMillis());
    }

    @NotNull
    public final RegisterValue setValue(short value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
        return this;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final boolean needsToBeUpdated(long now, long maxAge) {
        if (this.value == null) {
            return true;
        }
        if (this.immutable) {
            return false;
        }
        if (!(this.timestamp > -2208988800000L)) {
            boolean bl = false;
            String string = "Any register with a valid value MUST be after 1900-01-01T00:00:00Z";
            throw new IllegalArgumentException(string.toString());
        }
        return now - this.timestamp > maxAge;
    }

    public final void clear() {
        this.value = null;
        this.timestamp = Long.MIN_VALUE;
    }

    @NotNull
    public final String getHexValue() {
        if (this.hasValue()) {
            String string = "%04X";
            Object[] objectArray = new Object[]{this.value};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        return "----";
    }

    @NotNull
    public String toString() {
        Object stringComment = "";
        CharSequence charSequence = this.comment;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            stringComment = " /* " + this.comment + " */";
        }
        if (this.hasValue()) {
            return "{" + this.address + "=0x" + this.getHexValue() + "}" + (String)stringComment;
        }
        return "{" + this.address + "= ----}" + (String)stringComment;
    }

    @Override
    public int compareTo(@NotNull RegisterValue other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int addressCompared = this.address.compareTo(other.address);
        if (addressCompared != 0) {
            return addressCompared;
        }
        return Intrinsics.compare((long)this.timestamp, (long)other.timestamp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegisterValue)) {
            return false;
        }
        if (this.immutable != ((RegisterValue)other).immutable) return false;
        Short s = this.value;
        Short s2 = ((RegisterValue)other).value;
        if (!Intrinsics.areEqual((Object)(s != null ? Integer.valueOf(s.shortValue()) : null), (Object)(s2 != null ? Integer.valueOf(s2.shortValue()) : null))) return false;
        if (this.timestamp != ((RegisterValue)other).timestamp) return false;
        if (!Intrinsics.areEqual((Object)this.address, (Object)((RegisterValue)other).address)) return false;
        if (!Intrinsics.areEqual((Object)this.fetchGroup, (Object)((RegisterValue)other).fetchGroup)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.fetchGroup.hashCode();
        result = 31 * result + Boolean.hashCode(this.immutable);
        return result;
    }
}

