/*
 * Modbus Schema Toolkit
 * Copyright (C) 2019-2025 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@file:Suppress("unused") // Some of these will only be used by projects that use this library

package nl.basjes.modbus.version

const val GIT_COMMIT_ID                = "3ca1179b2f8cbe695e9e196fa809b901e093f2a5"
const val GIT_COMMIT_ID_DESCRIBE_SHORT = "v0.10.0"
const val BUILD_TIME_STAMP             = "2025-06-24T20:25:37Z"
const val PROJECT_VERSION              = "0.10.0"
const val COPYRIGHT                    = "Copyright (C) 2019-2025 Niels Basjes"
const val LICENSE                      = "Apache 2.0"
const val URL                          = "https://modbus.basjes.nl"
const val BUILD_KOTLIN_VERSION         = "2.2.0"

class Version {
    val gitCommitId              = GIT_COMMIT_ID
    val gitCommitIdDescribeShort = GIT_COMMIT_ID_DESCRIBE_SHORT
    val buildTimeStamp           = BUILD_TIME_STAMP
    val projectVersion           = PROJECT_VERSION
    val copyright                = COPYRIGHT
    val license                  = LICENSE
    val url                      = URL
    val buildKotlinVersion       = BUILD_KOTLIN_VERSION

    companion object {
        @JvmField
        val INSTANCE = Version()
    }
}
