/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.AddressKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\u0011\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006 "}, d2={"Lnl/basjes/modbus/device/api/Address;", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "physicalAddress", "", "<init>", "(Lnl/basjes/modbus/device/api/AddressClass;I)V", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "getPhysicalAddress", "()I", "registerNumber", "getRegisterNumber", "increment", "step", "distance", "address", "(Lnl/basjes/modbus/device/api/Address;)Ljava/lang/Integer;", "toString", "", "toCleanFormat", "toModicon5", "toModicon6", "toModiconX", "compareTo", "other", "equals", "", "", "hashCode", "Companion", "modbus-api"})
public final class Address
implements Comparable<Address> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AddressClass addressClass;
    private final int physicalAddress;

    public Address(@NotNull AddressClass addressClass, int physicalAddress) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
        this.addressClass = addressClass;
        this.physicalAddress = physicalAddress;
        if (!(this.physicalAddress >= 0 && this.physicalAddress <= 65535)) {
            boolean bl = false;
            String string = "Invalid Modbus register address specified for " + this.addressClass.getLongLabel() + ": " + this.physicalAddress;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final AddressClass getAddressClass() {
        return this.addressClass;
    }

    public final int getPhysicalAddress() {
        return this.physicalAddress;
    }

    public final int getRegisterNumber() {
        return this.physicalAddress + this.addressClass.getRegisterNumberOffset();
    }

    @JvmOverloads
    @NotNull
    public final Address increment(int step) {
        return new Address(this.addressClass, this.physicalAddress + step);
    }

    public static /* synthetic */ Address increment$default(Address address, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return address.increment(n);
    }

    @Nullable
    public final Integer distance(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (this.addressClass != address.addressClass) {
            return null;
        }
        return address.physicalAddress - this.physicalAddress;
    }

    @NotNull
    public String toString() {
        return this.toCleanFormat();
    }

    @NotNull
    public final String toCleanFormat() {
        String string = "%s:%05d";
        Object[] objectArray = new Object[]{this.addressClass.getShortLabel(), this.physicalAddress};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Nullable
    public final String toModicon5() {
        if (this.getRegisterNumber() > 9999) {
            return null;
        }
        String string = "%d%04d";
        Object[] objectArray = new Object[]{this.addressClass.getBaseOffset(), this.getRegisterNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String toModicon6() {
        String string = "%d%05d";
        Object[] objectArray = new Object[]{this.addressClass.getBaseOffset(), this.getRegisterNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String toModiconX() {
        String string = "%dx%05d";
        Object[] objectArray = new Object[]{this.addressClass.getBaseOffset(), this.getRegisterNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Override
    public int compareTo(@NotNull Address other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int addressClassCompared = this.addressClass.compareTo((Enum)other.addressClass);
        if (addressClassCompared != 0) {
            return addressClassCompared;
        }
        return Intrinsics.compare((int)this.physicalAddress, (int)other.physicalAddress);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Address)) {
            return false;
        }
        return this.addressClass == ((Address)other).addressClass && this.physicalAddress == ((Address)other).physicalAddress;
    }

    public int hashCode() {
        int result = this.addressClass.hashCode();
        result = 31 * result + this.physicalAddress;
        return result;
    }

    @JvmOverloads
    @NotNull
    public final Address increment() {
        return Address.increment$default(this, 0, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Address of(@NotNull AddressClass addressClass, int physicalAddress) {
        return Companion.of(addressClass, physicalAddress);
    }

    @JvmStatic
    @NotNull
    public static final Address ofModicon5(int modicon5RegisterTag) {
        return Companion.ofModicon5(modicon5RegisterTag);
    }

    @JvmStatic
    @NotNull
    public static final Address ofModicon6(int modicon6RegisterTag) {
        return Companion.ofModicon6(modicon6RegisterTag);
    }

    @JvmStatic
    @NotNull
    public static final Address of(@NotNull String registerTag) {
        return Companion.of(registerTag);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lnl/basjes/modbus/device/api/Address$Companion;", "", "<init>", "()V", "of", "Lnl/basjes/modbus/device/api/Address;", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "physicalAddress", "", "ofModicon5", "modicon5RegisterTag", "ofModicon6", "modicon6RegisterTag", "registerTag", "", "modbus-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Address of(@NotNull AddressClass addressClass, int physicalAddress) {
            Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
            return new Address(addressClass, physicalAddress);
        }

        @JvmStatic
        @NotNull
        public final Address ofModicon5(int modicon5RegisterTag) {
            Pair pair = AddressKt.access$addressFromModicon5(modicon5RegisterTag);
            AddressClass addressClass = (AddressClass)((Object)pair.component1());
            int physicalAddress = ((Number)pair.component2()).intValue();
            return new Address(addressClass, physicalAddress);
        }

        @JvmStatic
        @NotNull
        public final Address ofModicon6(int modicon6RegisterTag) {
            Pair pair = AddressKt.access$addressFromModicon6(modicon6RegisterTag);
            AddressClass addressClass = (AddressClass)((Object)pair.component1());
            int physicalAddress = ((Number)pair.component2()).intValue();
            return new Address(addressClass, physicalAddress);
        }

        @JvmStatic
        @NotNull
        public final Address of(@NotNull String registerTag) {
            Intrinsics.checkNotNullParameter((Object)registerTag, (String)"registerTag");
            Pair pair = AddressKt.access$addressFrom(registerTag);
            AddressClass addressClass = (AddressClass)((Object)pair.component1());
            int physicalAddress = ((Number)pair.component2()).intValue();
            return new Address(addressClass, physicalAddress);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

