/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.exception.ModbusIllegalAddressClassException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u001a\b\u0000\u0010\u0001*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0000*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004*\u0004\b\u0002\u0010\u00032\u00020\u0005BA\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00020\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010+\u001a\u00028\u00012\u0006\u0010,\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00028\u0001\u00a2\u0006\u0002\u0010/J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b00J\u001d\u0010-\u001a\u0004\u0018\u00018\u00012\u0006\u00102\u001a\u00020\u000b2\u0006\u0010.\u001a\u00028\u0001\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u00105\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ#\u00104\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010.\u001a\u00028\u00022\u0006\u00106\u001a\u000207\u00a2\u0006\u0002\u00108J\u0013\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00028\u0000\u00a2\u0006\u0002\u0010;J\u0015\u0010<\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\u0002\u0010=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u000100J\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020@H&J\u000e\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020CJ\u0013\u0010D\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u0010\u0010F\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000b\u0010G\u001a\u00028\u0000\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b!0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\r\u0012\t\u0012\u00078\u0001\u00a2\u0006\u0002\b!0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u0082\u0001\u0002JK\u00a8\u0006L"}, d2={"Lnl/basjes/modbus/device/api/ModbusBlock;", "BLOCK", "VALUE", "TYPE", "Lnl/basjes/modbus/device/api/ModbusValue;", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "newBlock", "Lkotlin/Function1;", "newValue", "Lnl/basjes/modbus/device/api/Address;", "requiredBitsPerValue", "", "<init>", "(Lnl/basjes/modbus/device/api/AddressClass;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;I)V", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "modbusValues", "Ljava/util/TreeMap;", "clear", "", "get", "address", "(Lnl/basjes/modbus/device/api/Address;)Lnl/basjes/modbus/device/api/ModbusValue;", "set", "modbusValue", "(Lnl/basjes/modbus/device/api/Address;Lnl/basjes/modbus/device/api/ModbusValue;)V", "firstAddress", "getFirstAddress", "()Lnl/basjes/modbus/device/api/Address;", "keys", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getKeys", "()Ljava/util/Set;", "values", "", "getValues", "()Ljava/util/Collection;", "size", "getSize", "()I", "getOrCreateIfAbsent", "requiredRegister", "put", "value", "(Lnl/basjes/modbus/device/api/ModbusValue;)V", "", "addresses", "key", "(Lnl/basjes/modbus/device/api/Address;Lnl/basjes/modbus/device/api/ModbusValue;)Lnl/basjes/modbus/device/api/ModbusValue;", "setValue", "setReadError", "timestamp", "", "(Lnl/basjes/modbus/device/api/Address;Ljava/lang/Object;J)V", "merge", "modbusBlock", "(Lnl/basjes/modbus/device/api/ModbusBlock;)V", "getValue", "(Lnl/basjes/modbus/device/api/Address;)Ljava/lang/Object;", "noGapsValuesList", "toMultiLineString", "", "asString", "multiLine", "", "equals", "other", "assertAddressClass", "clone", "()Lnl/basjes/modbus/device/api/ModbusBlock;", "hashCode", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "Lnl/basjes/modbus/device/api/RegisterBlock;", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nModbusBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusBlock.kt\nnl/basjes/modbus/device/api/ModbusBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1869#2,2:387\n1617#2,9:389\n1869#2:398\n1870#2:400\n1626#2:401\n1#3:399\n1#3:402\n*S KotlinDebug\n*F\n+ 1 ModbusBlock.kt\nnl/basjes/modbus/device/api/ModbusBlock\n*L\n118#1:387,2\n166#1:389,9\n166#1:398\n166#1:400\n166#1:401\n166#1:399\n*E\n"})
public abstract class ModbusBlock<BLOCK extends ModbusBlock<BLOCK, VALUE, TYPE>, VALUE extends ModbusValue<VALUE, TYPE>, TYPE> {
    @NotNull
    private final AddressClass addressClass;
    @NotNull
    private final Function1<AddressClass, BLOCK> newBlock;
    @NotNull
    private final Function1<Address, VALUE> newValue;
    @NotNull
    private final TreeMap<Address, VALUE> modbusValues;

    private ModbusBlock(AddressClass addressClass, Function1<? super AddressClass, ? extends BLOCK> newBlock, Function1<? super Address, ? extends VALUE> newValue, int requiredBitsPerValue) {
        this.addressClass = addressClass;
        this.newBlock = newBlock;
        this.newValue = newValue;
        this.modbusValues = new TreeMap();
        if (!(this.addressClass.getBitsPerValue() == requiredBitsPerValue)) {
            boolean bl = false;
            throw new ModbusIllegalAddressClassException("The used AddressClass must be " + requiredBitsPerValue + " bits per value (" + this.addressClass.getLongLabel() + " has " + this.addressClass.getBitsPerValue() + " bits per value)", null, 2, null);
        }
    }

    @NotNull
    public final AddressClass getAddressClass() {
        return this.addressClass;
    }

    public final void clear() {
        Collection<VALUE> collection = this.modbusValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModbusValue it = (ModbusValue)element$iv;
            boolean bl = false;
            it.clear();
        }
    }

    @NotNull
    public final VALUE get(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.assertAddressClass(address.getAddressClass());
        ModbusValue modbusValue = this.modbusValues.computeIfAbsent(address, arg_0 -> ModbusBlock.get$lambda$3(arg_0 -> ModbusBlock.get$lambda$2(this, address, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modbusValue, (String)"computeIfAbsent(...)");
        return (VALUE)modbusValue;
    }

    public final void set(@NotNull Address address, @NotNull VALUE modbusValue) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(modbusValue, (String)"modbusValue");
        if (this.modbusValues.get(address) != null && ((ModbusValue)modbusValue).hasValue()) {
            Address address2 = ((ModbusValue)modbusValue).getAddress();
            Object TYPE = ((ModbusValue)modbusValue).getValue();
            Intrinsics.checkNotNull(TYPE);
            this.setValue(address2, TYPE, ((ModbusValue)modbusValue).getFetchTimestamp$modbus_api());
        } else {
            ((Map)this.modbusValues).put(address, modbusValue);
        }
        this.modbusValues.keySet();
    }

    @Nullable
    public final Address getFirstAddress() {
        return this.modbusValues.isEmpty() ? null : this.modbusValues.firstKey();
    }

    @NotNull
    public final Set<Address> getKeys() {
        Set<Address> set = this.modbusValues.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Collection<VALUE> getValues() {
        Collection<VALUE> collection = this.modbusValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final int getSize() {
        return this.modbusValues.size();
    }

    @NotNull
    public final VALUE getOrCreateIfAbsent(@NotNull Address requiredRegister) {
        Intrinsics.checkNotNullParameter((Object)requiredRegister, (String)"requiredRegister");
        ModbusValue modbusValue = this.modbusValues.computeIfAbsent(requiredRegister, arg_0 -> ModbusBlock.getOrCreateIfAbsent$lambda$4(this.newValue, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modbusValue, (String)"computeIfAbsent(...)");
        return (VALUE)modbusValue;
    }

    public final void put(@NotNull VALUE value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        ((ModbusValue)this.get(((ModbusValue)value).getAddress())).setValue(value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VALUE> get(@NotNull List<Address> addresses) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Iterable $this$mapNotNull$iv = addresses;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModbusValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Address key = (Address)element$iv$iv;
            boolean bl2 = false;
            if ((ModbusValue)this.modbusValues.get(key) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final VALUE put(@NotNull Address key, @NotNull VALUE value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.assertAddressClass(key.getAddressClass());
        if (!Intrinsics.areEqual((Object)key, (Object)((ModbusValue)value).getAddress())) {
            boolean bl = false;
            String string = "The address MUST be the same as the address in the register value";
            throw new IllegalArgumentException(string.toString());
        }
        return (VALUE)((ModbusValue)this.modbusValues.put(key, value));
    }

    public final void setValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.get(address);
    }

    public final void setReadError(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ((ModbusValue)this.get(address)).setSoftReadError();
    }

    public final void setValue(@NotNull Address address, TYPE value, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ((ModbusValue)this.get(address)).setValue(value, timestamp);
    }

    public final void merge(@NotNull BLOCK modbusBlock) {
        Intrinsics.checkNotNullParameter(modbusBlock, (String)"modbusBlock");
        this.assertAddressClass(((ModbusBlock)modbusBlock).addressClass);
        for (VALUE VALUE : ((ModbusBlock)modbusBlock).modbusValues.values()) {
            Intrinsics.checkNotNullExpressionValue(VALUE, (String)"next(...)");
            ModbusValue registerValue = (ModbusValue)VALUE;
            this.put(registerValue);
        }
    }

    @Nullable
    public final TYPE getValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ModbusValue modbusValue = (ModbusValue)this.modbusValues.get(address);
        if (modbusValue == null) {
            return null;
        }
        ModbusValue modbusValue2 = modbusValue;
        return modbusValue2.getValue();
    }

    @NotNull
    public final List<VALUE> noGapsValuesList() {
        List result = new ArrayList();
        if (!this.modbusValues.isEmpty()) {
            Address address = this.modbusValues.firstKey();
            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"firstKey(...)");
            Address expectedNextAddress = address;
            for (VALUE VALUE : this.modbusValues.values()) {
                Intrinsics.checkNotNullExpressionValue(VALUE, (String)"next(...)");
                ModbusValue value = (ModbusValue)VALUE;
                while (!Intrinsics.areEqual((Object)value.getAddress(), (Object)expectedNextAddress)) {
                    result.add(this.newValue.invoke((Object)expectedNextAddress));
                    expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
                }
                result.add(value);
                expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
            }
        }
        return result;
    }

    @NotNull
    public final String toMultiLineString() {
        StringBuilder sb = new StringBuilder();
        List<VALUE> valuesList = this.noGapsValuesList();
        int lineCount = 0;
        for (ModbusValue value : valuesList) {
            String comment = value.getComment();
            CharSequence charSequence = comment;
            if (!(charSequence == null || charSequence.length() == 0)) {
                comment = StringsKt.replace$default((String)comment, (String)"{address}", (String)value.getAddress().toCleanFormat(), (boolean)false, (int)4, null);
                if (lineCount > 0) {
                    sb.append("\n");
                }
                sb.append("\n# " + StringsKt.replace$default((String)comment, (String)"\n", (String)"\n# ", (boolean)false, (int)4, null) + "\n");
                lineCount = 0;
            }
            if (lineCount > 0) {
                sb.append(" ");
            }
            sb.append(value.getAsString());
            if (++lineCount < 10) continue;
            sb.append("\n");
            lineCount = 0;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public abstract String asString();

    @NotNull
    public final String asString(boolean multiLine) {
        return multiLine ? this.toMultiLineString() : this.asString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegisterBlock)) {
            return false;
        }
        if (this.addressClass != ((RegisterBlock)other).getAddressClass()) {
            return false;
        }
        return super.equals(other);
    }

    private final void assertAddressClass(AddressClass addressClass) {
        if (this.addressClass == addressClass) {
            return;
        }
        throw new ModbusIllegalAddressClassException("Trying to use the AddressClass \"" + addressClass + "\" on a ModbusBlock which only allows AddressClass \"" + this.addressClass + "\"", null, 2, null);
    }

    @NotNull
    public final BLOCK clone() {
        ModbusBlock result = (ModbusBlock)this.newBlock.invoke((Object)this.addressClass);
        for (VALUE VALUE : this.modbusValues.values()) {
            Intrinsics.checkNotNullExpressionValue(VALUE, (String)"next(...)");
            ModbusValue value = (ModbusValue)VALUE;
            ((Map)result.modbusValues).put(value.getAddress(), value.clone());
        }
        return (BLOCK)result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.addressClass.hashCode();
        return result;
    }

    private static final ModbusValue get$lambda$2(ModbusBlock this$0, Address $address, Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ModbusValue)this$0.newValue.invoke((Object)$address);
    }

    private static final ModbusValue get$lambda$3(Function1 $tmp0, Object p0) {
        return (ModbusValue)$tmp0.invoke(p0);
    }

    private static final ModbusValue getOrCreateIfAbsent$lambda$4(Function1 $tmp0, Object p0) {
        return (ModbusValue)$tmp0.invoke(p0);
    }

    public /* synthetic */ ModbusBlock(AddressClass addressClass, Function1 newBlock, Function1 newValue, int requiredBitsPerValue, DefaultConstructorMarker $constructor_marker) {
        this(addressClass, newBlock, newValue, requiredBitsPerValue);
    }
}

