/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.exception.ModbusApiException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"toCleanedArray", "", "", "(Ljava/lang/String;)[Ljava/lang/String;", "standardFixedYamlTimeStamp", "", "toDiscreteBlock", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "firstAddress", "Lnl/basjes/modbus/device/api/Address;", "toRegisterBlock", "Lnl/basjes/modbus/device/api/RegisterBlock;", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nModbusBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusBlock.kt\nnl/basjes/modbus/device/api/ModbusBlockKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,386:1\n739#2,9:387\n1869#2,2:427\n37#3:396\n36#3,3:397\n106#4:400\n78#4,22:401\n106#4:429\n78#4,22:430\n11308#5:423\n11643#5,3:424\n*S KotlinDebug\n*F\n+ 1 ModbusBlock.kt\nnl/basjes/modbus/device/api/ModbusBlockKt\n*L\n314#1:387,9\n333#1:427,2\n315#1:396\n315#1:397,3\n329#1:400\n329#1:401,22\n358#1:429\n358#1:430,22\n333#1:423\n333#1:424,3\n*E\n"})
public final class ModbusBlockKt {
    private static final long standardFixedYamlTimeStamp = 981173106789L;

    private static final String[] toCleanedArray(String $this$toCleanedArray) {
        List list;
        CharSequence charSequence = $this$toCleanedArray;
        Regex regex = new Regex("#.*\n");
        String string = "\n";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("//.*\n");
        string = "\n";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("^ +");
        string = "";
        charSequence = StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\n", (String)" ", (boolean)false, (int)4, null);
        regex = new Regex(" +");
        string = " ";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        charSequence = string2;
        regex = new Regex(" ");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final DiscreteBlock toDiscreteBlock(@NotNull String $this$toDiscreteBlock, @NotNull Address firstAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$toDiscreteBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
        AddressClass addressClass = firstAddress.getAddressClass();
        DiscreteBlock discreteBlock = new DiscreteBlock(addressClass);
        int currentPhysicalAddress = 0;
        currentPhysicalAddress = firstAddress.getPhysicalAddress();
        for (String word : ModbusBlockKt.toCleanedArray($this$toDiscreteBlock)) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String toParse;
            boolean match$iv$iv;
            char it;
            Object $this$trim$iv = word;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            int startFound$iv$iv = 0;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                int index$iv$iv = startFound$iv$iv == 0 ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (startFound$iv$iv == 0) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = 1;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(toParse = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) continue;
            char[] cArray = toParse.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            $this$trim$iv = cArray;
            boolean $i$f$map = false;
            $this$trim$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                match$iv$iv = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                block16: {
                    Address currentAddress;
                    block15: {
                        block14: {
                            String it2 = (String)element$iv;
                            boolean bl = false;
                            currentAddress = Address.Companion.of(addressClass, currentPhysicalAddress);
                            String string = it2;
                            switch (string.hashCode()) {
                                case 48: {
                                    if (!string.equals("0")) {
                                        throw new ModbusApiException("The unable to parse \"" + toParse + "\" into a valid discrete value", null, 2, null);
                                    }
                                    break block14;
                                }
                                case 49: {
                                    if (!string.equals("1")) {
                                        throw new ModbusApiException("The unable to parse \"" + toParse + "\" into a valid discrete value", null, 2, null);
                                    }
                                    break block15;
                                }
                                case 120: {
                                    if (string.equals("x")) break;
                                    throw new ModbusApiException("The unable to parse \"" + toParse + "\" into a valid discrete value", null, 2, null);
                                }
                                case 45: {
                                    if (!string.equals("-")) throw new ModbusApiException("The unable to parse \"" + toParse + "\" into a valid discrete value", null, 2, null);
                                    discreteBlock.setValue(currentAddress);
                                    break block16;
                                }
                            }
                            discreteBlock.setReadError(currentAddress);
                            break block16;
                        }
                        discreteBlock.setValue(currentAddress, false, 981173106789L);
                        break block16;
                    }
                    discreteBlock.setValue(currentAddress, true, 981173106789L);
                    break block16;
                    throw new ModbusApiException("The unable to parse \"" + toParse + "\" into a valid discrete value", null, 2, null);
                }
                ++currentPhysicalAddress;
            }
        }
        return discreteBlock;
    }

    @NotNull
    public static final RegisterBlock toRegisterBlock(@NotNull String $this$toRegisterBlock, @NotNull Address firstAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegisterBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
        AddressClass addressClass = firstAddress.getAddressClass();
        RegisterBlock registerBlock = new RegisterBlock(addressClass);
        int currentPhysicalAddress = firstAddress.getPhysicalAddress();
        String[] stringArray = ModbusBlockKt.toCleanedArray($this$toRegisterBlock);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String toParse;
            String word;
            String $this$trim$iv = word = stringArray[i];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(toParse = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) continue;
            Address currentAddress = Address.Companion.of(addressClass, currentPhysicalAddress);
            String string = toParse.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            switch (toParse = string) {
                case "null": 
                case "----": {
                    registerBlock.setValue(currentAddress);
                    break;
                }
                case "xxxx": {
                    registerBlock.setReadError(currentAddress);
                    break;
                }
                default: {
                    int parsedInt = Integer.parseInt(toParse, CharsKt.checkRadix((int)16));
                    short value = (short)(parsedInt & 0xFFFF);
                    registerBlock.setValue(currentAddress, value, 981173106789L);
                }
            }
            ++currentPhysicalAddress;
        }
        return registerBlock;
    }
}

