/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.exception.ModbusIllegalAddressClassException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B<\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u00101J\u0013\u00100\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\u001b\u00100\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u00012\u0006\u0010+\u001a\u00020&\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u00020\u0019J\u0006\u00109\u001a\u00020:J\u0006\u00108\u001a\u00020:J\u0006\u0010;\u001a\u00020\u0019J\u0006\u0010<\u001a\u00020:J\u0016\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020&J\u0006\u0010@\u001a\u00020:J\b\u0010C\u001a\u00020\u0013H&J\u0016\u0010D\u001a\u00020\u000b2\u0006\u0010E\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010FJ\u0013\u0010G\u001a\u00020\u00192\b\u0010E\u001a\u0004\u0018\u00010HH\u0096\u0002J\b\u0010I\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR/\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u0004\u0018\u00018\u00012\b\u0010\u001e\u001a\u0004\u0018\u00018\u0001@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0015\"\u0004\b$\u0010\u0017R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u00106\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001b\"\u0004\b8\u0010\u001dR\u0011\u0010A\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0015\u0082\u0001\u0002JK\u00a8\u0006L"}, d2={"Lnl/basjes/modbus/device/api/ModbusValue;", "VALUE", "TYPE", "", "address", "Lnl/basjes/modbus/device/api/Address;", "makeANewInstance", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "requiredBitsPerValue", "", "<init>", "(Lnl/basjes/modbus/device/api/Address;Lkotlin/jvm/functions/Function1;I)V", "getAddress", "()Lnl/basjes/modbus/device/api/Address;", "getMakeANewInstance$modbus_api", "()Lkotlin/jvm/functions/Function1;", "fetchGroup", "", "getFetchGroup", "()Ljava/lang/String;", "setFetchGroup", "(Ljava/lang/String;)V", "immutable", "", "getImmutable", "()Z", "setImmutable", "(Z)V", "value", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "comment", "getComment", "setComment", "fetchTimestamp", "", "getFetchTimestamp$modbus_api", "()J", "setFetchTimestamp$modbus_api", "(J)V", "timestamp", "getTimestamp", "()Ljava/lang/Long;", "clone", "()Lnl/basjes/modbus/device/api/ModbusValue;", "setValue", "(Ljava/lang/Object;)Lnl/basjes/modbus/device/api/ModbusValue;", "modbusValue", "(Lnl/basjes/modbus/device/api/ModbusValue;)Lnl/basjes/modbus/device/api/ModbusValue;", "(Ljava/lang/Object;J)Lnl/basjes/modbus/device/api/ModbusValue;", "hasValue", "hardReadError", "getHardReadError", "setHardReadError", "setSoftReadError", "", "isReadError", "clearSoftReadError", "needsToBeUpdated", "now", "maxAge", "clear", "asString", "getAsString", "toSingleValueString", "compareTo", "other", "(Lnl/basjes/modbus/device/api/ModbusValue;)I", "equals", "", "hashCode", "Lnl/basjes/modbus/device/api/DiscreteValue;", "Lnl/basjes/modbus/device/api/RegisterValue;", "modbus-api"})
public abstract class ModbusValue<VALUE extends ModbusValue<VALUE, TYPE>, TYPE>
implements Comparable<VALUE> {
    @NotNull
    private final Address address;
    @NotNull
    private final Function1<Address, VALUE> makeANewInstance;
    @NotNull
    private String fetchGroup;
    private boolean immutable;
    @Nullable
    private TYPE value;
    @Nullable
    private String comment;
    private long fetchTimestamp;
    private boolean hardReadError;

    private ModbusValue(Address address, Function1<? super Address, ? extends VALUE> makeANewInstance, int requiredBitsPerValue) {
        this.address = address;
        this.makeANewInstance = makeANewInstance;
        if (!(this.address.getAddressClass().getBitsPerValue() == requiredBitsPerValue)) {
            boolean bl = false;
            throw new ModbusIllegalAddressClassException("The used AddressClass must be " + requiredBitsPerValue + " bits per value (" + this.address.getAddressClass().getLongLabel() + " has " + this.address.getAddressClass().getBitsPerValue() + " bits per value)", null, 2, null);
        }
        this.fetchGroup = "FG_" + this.address.toCleanFormat();
        this.fetchTimestamp = Long.MIN_VALUE;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @NotNull
    public final Function1<Address, VALUE> getMakeANewInstance$modbus_api() {
        return this.makeANewInstance;
    }

    @NotNull
    public final String getFetchGroup() {
        return this.fetchGroup;
    }

    public final void setFetchGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fetchGroup = string;
    }

    public final boolean getImmutable() {
        return this.immutable;
    }

    public final void setImmutable(boolean bl) {
        this.immutable = bl;
    }

    @Nullable
    public final TYPE getValue() {
        return this.value;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@Nullable String string) {
        this.comment = string;
    }

    public final long getFetchTimestamp$modbus_api() {
        return this.fetchTimestamp;
    }

    public final void setFetchTimestamp$modbus_api(long l) {
        this.fetchTimestamp = l;
    }

    @Nullable
    public final Long getTimestamp() {
        return this.fetchTimestamp <= -2208988800000L || this.immutable ? null : Long.valueOf(this.fetchTimestamp);
    }

    @NotNull
    public final VALUE clone() {
        ModbusValue modbusValue = (ModbusValue)this.makeANewInstance.invoke((Object)this.address);
        modbusValue.fetchGroup = this.fetchGroup;
        modbusValue.immutable = this.immutable;
        modbusValue.value = this.value;
        modbusValue.comment = this.comment;
        modbusValue.fetchTimestamp = this.fetchTimestamp;
        modbusValue.hardReadError = this.hardReadError;
        return (VALUE)modbusValue;
    }

    @NotNull
    public final VALUE setValue(TYPE value) {
        return this.setValue(value, System.currentTimeMillis());
    }

    @NotNull
    public final VALUE setValue(@NotNull VALUE modbusValue) {
        Intrinsics.checkNotNullParameter(modbusValue, (String)"modbusValue");
        this.value = ((ModbusValue)modbusValue).value;
        this.fetchTimestamp = ((ModbusValue)modbusValue).fetchTimestamp;
        this.hardReadError = ((ModbusValue)modbusValue).hardReadError;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type VALUE of nl.basjes.modbus.device.api.ModbusValue");
        return (VALUE)this;
    }

    @NotNull
    public final VALUE setValue(TYPE value, long timestamp) {
        this.value = value;
        this.fetchTimestamp = timestamp;
        this.hardReadError = false;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type VALUE of nl.basjes.modbus.device.api.ModbusValue");
        return (VALUE)this;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final boolean getHardReadError() {
        return this.hardReadError;
    }

    public final void setHardReadError(boolean bl) {
        this.hardReadError = bl;
    }

    public final void setSoftReadError() {
        this.value = null;
        this.fetchTimestamp = -2568642711112L;
        this.hardReadError = false;
    }

    public final void setHardReadError() {
        this.value = null;
        this.fetchTimestamp = -2568642711112L;
        this.hardReadError = true;
    }

    public final boolean isReadError() {
        return this.value == null && this.fetchTimestamp == -2568642711112L;
    }

    public final void clearSoftReadError() {
        if (this.isReadError() && !this.hardReadError) {
            this.value = null;
            this.fetchTimestamp = Long.MIN_VALUE;
        }
    }

    public final boolean needsToBeUpdated(long now, long maxAge) {
        if (this.isReadError()) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        if (this.immutable) {
            return false;
        }
        if (this.fetchTimestamp < -2208988800000L) {
            return true;
        }
        return now - this.fetchTimestamp > maxAge;
    }

    public final void clear() {
        this.value = null;
        this.fetchTimestamp = Long.MIN_VALUE;
    }

    @NotNull
    public final String getAsString() {
        return this.toSingleValueString();
    }

    @NotNull
    public abstract String toSingleValueString();

    @Override
    public int compareTo(@NotNull VALUE other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        int addressCompared = this.address.compareTo(((ModbusValue)other).address);
        if (addressCompared != 0) {
            return addressCompared;
        }
        return Intrinsics.compare((long)this.fetchTimestamp, (long)((ModbusValue)other).fetchTimestamp);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModbusValue)) {
            return false;
        }
        return this.immutable == ((ModbusValue)other).immutable && Intrinsics.areEqual(this.value, ((ModbusValue)other).value) && this.fetchTimestamp == ((ModbusValue)other).fetchTimestamp && Intrinsics.areEqual((Object)this.address, (Object)((ModbusValue)other).address) && Intrinsics.areEqual((Object)this.fetchGroup, (Object)((ModbusValue)other).fetchGroup);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.fetchGroup.hashCode();
        result = 31 * result + Boolean.hashCode(this.immutable);
        return result;
    }

    public /* synthetic */ ModbusValue(Address address, Function1 makeANewInstance, int requiredBitsPerValue, DefaultConstructorMarker $constructor_marker) {
        this(address, makeANewInstance, requiredBitsPerValue);
    }
}

