/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lnl/basjes/modbus/device/api/RegisterValue;", "Lnl/basjes/modbus/device/api/ModbusValue;", "", "address", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Lnl/basjes/modbus/device/api/Address;)V", "toSingleValueString", "", "toString", "modbus-api"})
public final class RegisterValue
extends ModbusValue<RegisterValue, Short> {
    public RegisterValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        super(address, arg_0 -> RegisterValue._init_$lambda$0(address, arg_0), 16, null);
    }

    @Override
    @NotNull
    public String toSingleValueString() {
        Short localValue = (Short)this.getValue();
        if (localValue != null) {
            String string = "%04X";
            Object[] objectArray = new Object[]{localValue};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        if (this.isReadError()) {
            return this.getHardReadError() ? "XXXX" : "xxxx";
        }
        return "----";
    }

    @NotNull
    public String toString() {
        Object stringComment = "";
        CharSequence charSequence = this.getComment();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            stringComment = " /* " + this.getComment() + " */";
        }
        if (this.hasValue()) {
            return "{" + this.getAddress() + "=0x" + this.toSingleValueString() + "}" + (String)stringComment;
        }
        return "{" + this.getAddress() + "=" + this.toSingleValueString() + "}" + (String)stringComment;
    }

    private static final RegisterValue _init_$lambda$0(Address $address, Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue($address);
    }
}

