/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.memory;

import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusBlockKt;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.device.exception.ReadErrorResponseKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 12\u00020\u0001:\u000201B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0007J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0018J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020 H\u0016J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\tJ\u0016\u0010(\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010(\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0018J\u0018\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010$\u001a\u00020 H\u0016J \u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00162\u0006\u0010$\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lnl/basjes/modbus/device/memory/MockedModbusDevice;", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "()V", "discreteBlocks", "", "Lnl/basjes/modbus/device/api/AddressClass;", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "registerBlocks", "Lnl/basjes/modbus/device/api/RegisterBlock;", "logger", "Lorg/apache/logging/log4j/Logger;", "logRequests", "", "getLogRequests", "()Z", "setLogRequests", "(Z)V", "close", "", "addModbusValues", "firstAddress", "Lnl/basjes/modbus/device/api/Address;", "values", "", "addDiscretes", "discreteValue", "Lnl/basjes/modbus/device/api/DiscreteValue;", "discreteBlock", "hexRegisterValues", "addressClass", "firstPhysicalAddress", "", "binaryDiscretesValues", "getDiscretes", "firstDiscrete", "count", "addRegister", "registerValue", "Lnl/basjes/modbus/device/api/RegisterValue;", "addRegisters", "registerBlock", "getRegisters", "firstRegister", "logRequestResult", "first", "result", "", "MockedModbusDeviceBuilder", "Companion", "modbus-api"})
public class MockedModbusDevice
extends ModbusDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<AddressClass, DiscreteBlock> discreteBlocks = new TreeMap();
    @NotNull
    private final Map<AddressClass, RegisterBlock> registerBlocks = new TreeMap();
    @NotNull
    private final Logger logger;
    private boolean logRequests;

    public MockedModbusDevice() {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public final boolean getLogRequests() {
        return this.logRequests;
    }

    public final void setLogRequests(boolean bl) {
        this.logRequests = bl;
    }

    @Override
    public void close() {
    }

    @NotNull
    public final MockedModbusDevice addModbusValues(@NotNull Address firstAddress, @NotNull String values) {
        MockedModbusDevice mockedModbusDevice;
        Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        switch (WhenMappings.$EnumSwitchMapping$0[firstAddress.getAddressClass().getType().ordinal()]) {
            case 1: {
                mockedModbusDevice = this.addDiscretes(firstAddress.getAddressClass(), firstAddress.getPhysicalAddress(), values);
                break;
            }
            case 2: {
                mockedModbusDevice = this.addRegisters(firstAddress.getAddressClass(), firstAddress.getPhysicalAddress(), values);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mockedModbusDevice;
    }

    public final void addDiscretes(@NotNull DiscreteValue discreteValue) {
        Intrinsics.checkNotNullParameter((Object)discreteValue, (String)"discreteValue");
        AddressClass addressClass = discreteValue.getAddress().getAddressClass();
        this.discreteBlocks.computeIfAbsent(addressClass, arg_0 -> MockedModbusDevice.addDiscretes$lambda$1(arg_0 -> MockedModbusDevice.addDiscretes$lambda$0(addressClass, arg_0), arg_0)).put((ModbusValue)discreteValue);
    }

    public final void addDiscretes(@NotNull DiscreteBlock discreteBlock) {
        Intrinsics.checkNotNullParameter((Object)discreteBlock, (String)"discreteBlock");
        AddressClass addressClass = discreteBlock.getAddressClass();
        this.discreteBlocks.computeIfAbsent(addressClass, arg_0 -> MockedModbusDevice.addDiscretes$lambda$3(arg_0 -> MockedModbusDevice.addDiscretes$lambda$2(addressClass, arg_0), arg_0)).merge((ModbusBlock)discreteBlock);
    }

    @NotNull
    public final MockedModbusDevice addDiscretes(@NotNull Address firstAddress, @NotNull String hexRegisterValues) {
        Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
        Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
        return this.addDiscretes(firstAddress.getAddressClass(), firstAddress.getPhysicalAddress(), hexRegisterValues);
    }

    @NotNull
    public final MockedModbusDevice addDiscretes(@NotNull AddressClass addressClass, int firstPhysicalAddress, @NotNull String binaryDiscretesValues) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
        Intrinsics.checkNotNullParameter((Object)binaryDiscretesValues, (String)"binaryDiscretesValues");
        DiscreteBlock discreteBlock = ModbusBlockKt.toDiscreteBlock(binaryDiscretesValues, new Address(addressClass, firstPhysicalAddress));
        this.addDiscretes(discreteBlock);
        return this;
    }

    @Override
    @NotNull
    public DiscreteBlock getDiscretes(@NotNull Address firstDiscrete, int count) throws ModbusException {
        int firstPhysicalAddress;
        Intrinsics.checkNotNullParameter((Object)firstDiscrete, (String)"firstDiscrete");
        AddressClass addressClass = firstDiscrete.getAddressClass();
        DiscreteBlock discreteBlock = this.discreteBlocks.get((Object)addressClass);
        if (discreteBlock == null) {
            return new DiscreteBlock(addressClass);
        }
        DiscreteBlock discreteBlock2 = discreteBlock;
        DiscreteBlock discretes = new DiscreteBlock(addressClass);
        int n = firstPhysicalAddress + count;
        for (int registerNumber = firstPhysicalAddress = firstDiscrete.getPhysicalAddress(); registerNumber < n; ++registerNumber) {
            Address address = Address.Companion.of(addressClass, registerNumber);
            DiscreteValue discreteValue = (DiscreteValue)discreteBlock2.get(address);
            if (discreteValue.isReadError()) {
                this.logRequestResult(firstDiscrete, count, "READ ERROR ON " + address.toCleanFormat());
                return ReadErrorResponseKt.createReadErrorDiscreteBlock(firstDiscrete, count);
            }
            if (!discreteValue.hasValue()) continue;
            discreteValue.setFetchTimestamp$modbus_api(System.currentTimeMillis());
            discretes.set(address, (ModbusValue)discreteValue);
        }
        this.logRequestResult(firstDiscrete, count, discretes);
        return discretes;
    }

    public final void addRegister(@NotNull RegisterValue registerValue) {
        Intrinsics.checkNotNullParameter((Object)registerValue, (String)"registerValue");
        AddressClass addressClass = registerValue.getAddress().getAddressClass();
        this.registerBlocks.computeIfAbsent(addressClass, arg_0 -> MockedModbusDevice.addRegister$lambda$5(arg_0 -> MockedModbusDevice.addRegister$lambda$4(addressClass, arg_0), arg_0)).put((ModbusValue)registerValue);
    }

    public final void addRegisters(@NotNull RegisterBlock registerBlock) {
        Intrinsics.checkNotNullParameter((Object)registerBlock, (String)"registerBlock");
        AddressClass addressClass = registerBlock.getAddressClass();
        this.registerBlocks.computeIfAbsent(addressClass, arg_0 -> MockedModbusDevice.addRegisters$lambda$7(arg_0 -> MockedModbusDevice.addRegisters$lambda$6(addressClass, arg_0), arg_0)).merge((ModbusBlock)registerBlock);
    }

    @NotNull
    public final MockedModbusDevice addRegisters(@NotNull Address firstAddress, @NotNull String hexRegisterValues) {
        Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
        Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
        return this.addRegisters(firstAddress.getAddressClass(), firstAddress.getPhysicalAddress(), hexRegisterValues);
    }

    @NotNull
    public final MockedModbusDevice addRegisters(@NotNull AddressClass addressClass, int firstPhysicalAddress, @NotNull String hexRegisterValues) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
        Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
        RegisterBlock registerBlock = ModbusBlockKt.toRegisterBlock(hexRegisterValues, new Address(addressClass, firstPhysicalAddress));
        this.addRegisters(registerBlock);
        return this;
    }

    @Override
    @NotNull
    public RegisterBlock getRegisters(@NotNull Address firstRegister, int count) {
        int firstPhysicalAddress;
        Intrinsics.checkNotNullParameter((Object)firstRegister, (String)"firstRegister");
        AddressClass addressClass = firstRegister.getAddressClass();
        RegisterBlock registerBlock = this.registerBlocks.get((Object)addressClass);
        if (registerBlock == null) {
            return new RegisterBlock(addressClass);
        }
        RegisterBlock registerBlock2 = registerBlock;
        RegisterBlock registers = new RegisterBlock(addressClass);
        int n = firstPhysicalAddress + count;
        for (int registerNumber = firstPhysicalAddress = firstRegister.getPhysicalAddress(); registerNumber < n; ++registerNumber) {
            Address address = Address.Companion.of(addressClass, registerNumber);
            RegisterValue registerValue = (RegisterValue)registerBlock2.get(address);
            if (registerValue.isReadError()) {
                this.logRequestResult(firstRegister, count, "READ ERROR ON " + address.toCleanFormat());
                return ReadErrorResponseKt.createReadErrorRegisterBlock(firstRegister, count);
            }
            if (!registerValue.hasValue()) continue;
            registerValue.setFetchTimestamp$modbus_api(System.currentTimeMillis());
            registers.set(address, (ModbusValue)registerValue);
        }
        this.logRequestResult(firstRegister, count, registers);
        return registers;
    }

    private final void logRequestResult(Address first, int count, Object result) {
        if (this.logRequests) {
            this.logger.info("Getting {} " + (first.getAddressClass().getBitsPerValue() == 1 ? "registers" : "discretes") + " starting at \"{}\" (last = \"{}\"): {}", (Object)count, (Object)first, (Object)first.increment(count - 1), result);
        }
    }

    private static final DiscreteBlock addDiscretes$lambda$0(AddressClass $addressClass, AddressClass it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new DiscreteBlock($addressClass);
    }

    private static final DiscreteBlock addDiscretes$lambda$1(Function1 $tmp0, Object p0) {
        return (DiscreteBlock)$tmp0.invoke(p0);
    }

    private static final DiscreteBlock addDiscretes$lambda$2(AddressClass $addressClass, AddressClass it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new DiscreteBlock($addressClass);
    }

    private static final DiscreteBlock addDiscretes$lambda$3(Function1 $tmp0, Object p0) {
        return (DiscreteBlock)$tmp0.invoke(p0);
    }

    private static final RegisterBlock addRegister$lambda$4(AddressClass $addressClass, AddressClass it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new RegisterBlock($addressClass);
    }

    private static final RegisterBlock addRegister$lambda$5(Function1 $tmp0, Object p0) {
        return (RegisterBlock)$tmp0.invoke(p0);
    }

    private static final RegisterBlock addRegisters$lambda$6(AddressClass $addressClass, AddressClass it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new RegisterBlock($addressClass);
    }

    private static final RegisterBlock addRegisters$lambda$7(Function1 $tmp0, Object p0) {
        return (RegisterBlock)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final MockedModbusDevice of(@NotNull Address firstAddress, @NotNull String hexRegisterValues) {
        return Companion.of(firstAddress, hexRegisterValues);
    }

    @JvmStatic
    @NotNull
    public static final MockedModbusDevice of(@NotNull AddressClass addressClass, int firstPhysicalAddress, @NotNull String hexRegisterValues) {
        return Companion.of(addressClass, firstPhysicalAddress, hexRegisterValues);
    }

    @JvmStatic
    @NotNull
    public static final MockedModbusDeviceBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lnl/basjes/modbus/device/memory/MockedModbusDevice$Companion;", "", "<init>", "()V", "of", "Lnl/basjes/modbus/device/memory/MockedModbusDevice;", "firstAddress", "Lnl/basjes/modbus/device/api/Address;", "hexRegisterValues", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "firstPhysicalAddress", "", "builder", "Lnl/basjes/modbus/device/memory/MockedModbusDevice$MockedModbusDeviceBuilder;", "modbus-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MockedModbusDevice of(@NotNull Address firstAddress, @NotNull String hexRegisterValues) {
            Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
            Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
            return this.of(firstAddress.getAddressClass(), firstAddress.getPhysicalAddress(), hexRegisterValues);
        }

        @JvmStatic
        @NotNull
        public final MockedModbusDevice of(@NotNull AddressClass addressClass, int firstPhysicalAddress, @NotNull String hexRegisterValues) {
            Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
            Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
            MockedModbusDevice mockedDevice = new MockedModbusDevice();
            mockedDevice.addRegisters(addressClass, firstPhysicalAddress, hexRegisterValues);
            return mockedDevice;
        }

        @JvmStatic
        @NotNull
        public final MockedModbusDeviceBuilder builder() {
            return new MockedModbusDeviceBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0006\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnl/basjes/modbus/device/memory/MockedModbusDevice$MockedModbusDeviceBuilder;", "", "<init>", "()V", "mockedModbusDevice", "Lnl/basjes/modbus/device/memory/MockedModbusDevice;", "withDiscretes", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "firstAddress", "", "discretesString", "", "Lnl/basjes/modbus/device/api/Address;", "discreteBlock", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "withRegisters", "hexRegisterValues", "registerBlock", "Lnl/basjes/modbus/device/api/RegisterBlock;", "withLogging", "build", "modbus-api"})
    public static final class MockedModbusDeviceBuilder {
        @NotNull
        private final MockedModbusDevice mockedModbusDevice = new MockedModbusDevice();

        @NotNull
        public final MockedModbusDeviceBuilder withDiscretes(@NotNull AddressClass addressClass, int firstAddress, @NotNull String discretesString) {
            Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
            Intrinsics.checkNotNullParameter((Object)discretesString, (String)"discretesString");
            this.mockedModbusDevice.addDiscretes(addressClass, firstAddress, discretesString);
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withDiscretes(@NotNull Address firstAddress, @NotNull String discretesString) {
            Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
            Intrinsics.checkNotNullParameter((Object)discretesString, (String)"discretesString");
            this.mockedModbusDevice.addDiscretes(firstAddress, discretesString);
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withDiscretes(@NotNull DiscreteBlock discreteBlock) {
            Intrinsics.checkNotNullParameter((Object)discreteBlock, (String)"discreteBlock");
            Address firstAddress = discreteBlock.getFirstAddress();
            if (firstAddress != null) {
                this.mockedModbusDevice.addDiscretes(firstAddress, discreteBlock.toBitString());
            }
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withRegisters(@NotNull AddressClass addressClass, int firstAddress, @NotNull String hexRegisterValues) {
            Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
            Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
            this.mockedModbusDevice.addRegisters(addressClass, firstAddress, hexRegisterValues);
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withRegisters(@NotNull Address firstAddress, @NotNull String hexRegisterValues) {
            Intrinsics.checkNotNullParameter((Object)firstAddress, (String)"firstAddress");
            Intrinsics.checkNotNullParameter((Object)hexRegisterValues, (String)"hexRegisterValues");
            this.mockedModbusDevice.addRegisters(firstAddress, hexRegisterValues);
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withRegisters(@NotNull RegisterBlock registerBlock) {
            Intrinsics.checkNotNullParameter((Object)registerBlock, (String)"registerBlock");
            Address firstAddress = registerBlock.getFirstAddress();
            if (firstAddress != null) {
                this.mockedModbusDevice.addRegisters(firstAddress, registerBlock.toHexString());
            }
            return this;
        }

        @NotNull
        public final MockedModbusDeviceBuilder withLogging() {
            this.mockedModbusDevice.setLogRequests(true);
            return this;
        }

        @NotNull
        public final MockedModbusDevice build() {
            return this.mockedModbusDevice;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

