/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.device.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.RegisterValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0086\u0002J\"\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0%J\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000bJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0(J\u0018\u0010&\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nJ\u001e\u0010+\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010'\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0000J\u0015\u00102\u001a\u0004\u0018\u00010-2\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u00103J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0(J\u0006\u00105\u001a\u000206J\f\u00107\u001a\b\u0012\u0004\u0012\u0002060(J\u0006\u00108\u001a\u000206J\b\u00109\u001a\u000206H\u0016J\u0013\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010=\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010>\u001a\u00020\u0000J\b\u0010?\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00170\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006@"}, d2={"Lnl/basjes/modbus/device/api/RegisterBlock;", "", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "<init>", "(Lnl/basjes/modbus/device/api/AddressClass;)V", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "registerValues", "Ljava/util/TreeMap;", "Lnl/basjes/modbus/device/api/Address;", "Lnl/basjes/modbus/device/api/RegisterValue;", "clear", "", "get", "address", "set", "registerValue", "firstAddress", "getFirstAddress", "()Lnl/basjes/modbus/device/api/Address;", "keys", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getKeys", "()Ljava/util/Set;", "values", "", "getValues", "()Ljava/util/Collection;", "size", "", "getSize", "()I", "computeIfAbsent", "requiredRegister", "function", "Lkotlin/Function1;", "put", "value", "", "addresses", "key", "setValue", "setReadError", "", "timestamp", "", "merge", "registerBlock", "getValue", "(Lnl/basjes/modbus/device/api/Address;)Ljava/lang/Short;", "noGapsValuesList", "toMultiLineString", "", "toHexList", "toHexString", "toString", "equals", "", "other", "assertAddressClass", "clone", "hashCode", "modbus-api"})
@SourceDebugExtension(value={"SMAP\nRegisterBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterBlock.kt\nnl/basjes/modbus/device/api/RegisterBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1869#2,2:277\n1617#2,9:279\n1869#2:288\n1870#2:290\n1626#2:291\n1563#2:293\n1634#2,3:294\n1#3:289\n1#3:292\n*S KotlinDebug\n*F\n+ 1 RegisterBlock.kt\nnl/basjes/modbus/device/api/RegisterBlock\n*L\n34#1:277,2\n83#1:279,9\n83#1:288\n83#1:290\n83#1:291\n179#1:293\n179#1:294,3\n83#1:289\n*E\n"})
public final class RegisterBlock {
    @NotNull
    private final AddressClass addressClass;
    @NotNull
    private final TreeMap<Address, RegisterValue> registerValues;

    public RegisterBlock(@NotNull AddressClass addressClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressClass), (String)"addressClass");
        this.addressClass = addressClass;
        this.registerValues = new TreeMap();
    }

    @NotNull
    public final AddressClass getAddressClass() {
        return this.addressClass;
    }

    public final void clear() {
        Collection<RegisterValue> collection = this.registerValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisterValue it = (RegisterValue)element$iv;
            boolean bl = false;
            it.clear();
        }
    }

    @NotNull
    public final RegisterValue get(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.assertAddressClass(address.getAddressClass());
        RegisterValue registerValue = this.registerValues.computeIfAbsent(address, arg_0 -> RegisterBlock.get$lambda$2(arg_0 -> RegisterBlock.get$lambda$1(address, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)registerValue, (String)"computeIfAbsent(...)");
        return registerValue;
    }

    public final void set(@NotNull Address address, @NotNull RegisterValue registerValue) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)registerValue, (String)"registerValue");
        if (this.registerValues.get(address) != null && registerValue.hasValue()) {
            Address address2 = registerValue.getAddress();
            Short s = registerValue.getValue();
            Intrinsics.checkNotNull((Object)s);
            this.setValue(address2, s, registerValue.getFetchTimestamp());
        } else {
            ((Map)this.registerValues).put(address, registerValue);
        }
        this.registerValues.keySet();
    }

    @Nullable
    public final Address getFirstAddress() {
        return this.registerValues.isEmpty() ? null : this.registerValues.firstKey();
    }

    @NotNull
    public final Set<Address> getKeys() {
        Set<Address> set = this.registerValues.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Collection<RegisterValue> getValues() {
        Collection<RegisterValue> collection = this.registerValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final int getSize() {
        return this.registerValues.size();
    }

    @NotNull
    public final RegisterValue computeIfAbsent(@NotNull Address requiredRegister, @NotNull Function1<? super Address, RegisterValue> function) {
        Intrinsics.checkNotNullParameter((Object)requiredRegister, (String)"requiredRegister");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        RegisterValue registerValue = this.registerValues.computeIfAbsent(requiredRegister, arg_0 -> RegisterBlock.computeIfAbsent$lambda$3(function, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)registerValue, (String)"computeIfAbsent(...)");
        return registerValue;
    }

    public final void put(@NotNull RegisterValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.get(value.getAddress()).setValue(value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RegisterValue> get(@NotNull List<Address> addresses) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Iterable $this$mapNotNull$iv = addresses;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RegisterValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Address key = (Address)element$iv$iv;
            boolean bl2 = false;
            if (this.registerValues.get(key) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final RegisterValue put(@NotNull Address key, @NotNull RegisterValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.assertAddressClass(key.getAddressClass());
        if (!Intrinsics.areEqual((Object)key, (Object)value.getAddress())) {
            boolean bl = false;
            String string = "The address MUST be the same as the address in the register value";
            throw new IllegalArgumentException(string.toString());
        }
        return this.registerValues.put(key, value);
    }

    public final void setValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.get(address);
    }

    public final void setReadError(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.get(address).setSoftReadError();
    }

    public final void setValue(@NotNull Address address, short value, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.get(address).setValue(value, timestamp);
    }

    public final void merge(@NotNull RegisterBlock registerBlock) {
        Intrinsics.checkNotNullParameter((Object)registerBlock, (String)"registerBlock");
        this.assertAddressClass(registerBlock.addressClass);
        Iterator<RegisterValue> iterator = registerBlock.registerValues.values().iterator();
        while (iterator.hasNext()) {
            RegisterValue registerValue;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.put(registerValue);
        }
    }

    @Nullable
    public final Short getValue(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        RegisterValue registerValue = this.registerValues.get(address);
        if (registerValue == null) {
            return null;
        }
        RegisterValue registerValue2 = registerValue;
        return registerValue2.getValue();
    }

    @NotNull
    public final List<RegisterValue> noGapsValuesList() {
        List result = new ArrayList();
        if (!this.registerValues.isEmpty()) {
            Address address = this.registerValues.firstKey();
            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"firstKey(...)");
            Address expectedNextAddress = address;
            Iterator<RegisterValue> iterator = this.registerValues.values().iterator();
            while (iterator.hasNext()) {
                RegisterValue value;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                while (!Intrinsics.areEqual((Object)value.getAddress(), (Object)expectedNextAddress)) {
                    result.add(new RegisterValue(expectedNextAddress));
                    expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
                }
                result.add(value);
                expectedNextAddress = Address.increment$default(expectedNextAddress, 0, 1, null);
            }
        }
        return result;
    }

    @NotNull
    public final String toMultiLineString() {
        StringBuilder sb = new StringBuilder();
        List<RegisterValue> valuesList = this.noGapsValuesList();
        int lineCount = 0;
        for (RegisterValue registerValue : valuesList) {
            String comment = registerValue.getComment();
            CharSequence charSequence = comment;
            if (!(charSequence == null || charSequence.length() == 0)) {
                comment = StringsKt.replace$default((String)comment, (String)"{address}", (String)registerValue.getAddress().toCleanFormat(), (boolean)false, (int)4, null);
                if (lineCount > 0) {
                    sb.append("\n");
                }
                sb.append("\n# " + StringsKt.replace$default((String)comment, (String)"\n", (String)"\n# ", (boolean)false, (int)4, null) + "\n");
                lineCount = 0;
            }
            if (lineCount > 0) {
                sb.append(" ");
            }
            sb.append(registerValue.getHexValue());
            if (++lineCount < 10) continue;
            sb.append("\n");
            lineCount = 0;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toHexList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.noGapsValuesList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RegisterValue registerValue = (RegisterValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHexValue());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String toHexString() {
        return CollectionsKt.joinToString$default((Iterable)this.toHexList(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String toString() {
        Object object;
        block3: {
            block2: {
                object = this.getFirstAddress();
                if (object == null) break block2;
                Address it = object;
                boolean bl = false;
                String string = "Starting at " + it.toCleanFormat() + ": [ " + this.toHexString() + " ]";
                object = string;
                if (string != null) break block3;
            }
            object = "Empty RegisterBlock";
        }
        return object;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegisterBlock)) {
            return false;
        }
        if (this.addressClass != ((RegisterBlock)other).addressClass) {
            return false;
        }
        return super.equals(other);
    }

    private final void assertAddressClass(AddressClass addressClass) {
        if (this.addressClass == addressClass) {
            return;
        }
        throw new IllegalArgumentException("Trying to use the AddressClass \"" + addressClass + "\" on a RegisterBlock which only allows AddressClass \"" + addressClass + "\"");
    }

    @NotNull
    public final RegisterBlock clone() {
        RegisterBlock result = new RegisterBlock(this.addressClass);
        Iterator<RegisterValue> iterator = this.registerValues.values().iterator();
        while (iterator.hasNext()) {
            RegisterValue value;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ((Map)result.registerValues).put(value.getAddress(), value.clone());
        }
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.addressClass.hashCode();
        return result;
    }

    private static final RegisterValue get$lambda$1(Address $address, Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue($address);
    }

    private static final RegisterValue get$lambda$2(Function1 $tmp0, Object p0) {
        return (RegisterValue)$tmp0.invoke(p0);
    }

    private static final RegisterValue computeIfAbsent$lambda$3(Function1 $tmp0, Object p0) {
        return (RegisterValue)$tmp0.invoke(p0);
    }
}

