/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.utils.StringTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 72\u00020\u0001:\u000278B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010!\u001a\u00020\u00002\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\"\"\u00020\u001a\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u0005J\u0013\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010'\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020)H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010.\u001a\u00020\u001aH\u0002J\u0016\u0010/\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020+J\b\u00103\u001a\u00020\u0005H\u0016J\u0006\u00104\u001a\u00020)J\u0006\u00105\u001a\u00020)J\u0006\u00106\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnl/basjes/modbus/schema/Block;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "id", "", "description", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Ljava/lang/String;Ljava/lang/String;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getDescription", "()Ljava/lang/String;", "getId", "fetchGroup", "getFetchGroup", "setFetchGroup", "(Ljava/lang/String;)V", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "setAddressClass", "(Lnl/basjes/modbus/device/api/AddressClass;)V", "mutableFields", "", "Lnl/basjes/modbus/schema/Field;", "fields", "", "getFields", "()Ljava/util/List;", "fieldMap", "", "addField", "", "([Lnl/basjes/modbus/schema/Field;)Lnl/basjes/modbus/schema/Block;", "getField", "fieldName", "get", "fieldId", "sortFieldsByAddress", "", "initialize", "", "findCircularReference", "usageChainSoFar", "field", "toTable", "table", "Lnl/basjes/modbus/schema/utils/StringTable;", "onlyUseFullFields", "toString", "update", "need", "unNeed", "Companion", "BlockBuilder", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1863#2,2:244\n1863#2,2:246\n1863#2,2:248\n*S KotlinDebug\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block\n*L\n165#1:244,2\n170#1:246,2\n175#1:248,2\n*E\n"})
public class Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @Nullable
    private final String description;
    @NotNull
    private final String id;
    @Nullable
    private String fetchGroup;
    @Nullable
    private AddressClass addressClass;
    @NotNull
    private final List<Field> mutableFields;
    @NotNull
    private final List<Field> fields;
    @NotNull
    private final Map<String, Field> fieldMap;

    public Block(@NotNull SchemaDevice schemaDevice, @NotNull String id, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.schemaDevice = schemaDevice;
        this.description = description;
        this.id = ((Object)StringsKt.trim((CharSequence)id)).toString();
        this.mutableFields = new ArrayList();
        this.fields = this.mutableFields;
        this.fieldMap = new TreeMap();
        this.schemaDevice.addBlock(this);
    }

    public /* synthetic */ Block(SchemaDevice schemaDevice, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(schemaDevice, string, string2);
    }

    @NotNull
    public final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getFetchGroup() {
        return this.fetchGroup;
    }

    public final void setFetchGroup(@Nullable String string) {
        this.fetchGroup = string;
    }

    @Nullable
    public final AddressClass getAddressClass() {
        return this.addressClass;
    }

    public final void setAddressClass(@Nullable AddressClass addressClass) {
        this.addressClass = addressClass;
    }

    @NotNull
    public final List<Field> getFields() {
        return this.fields;
    }

    @NotNull
    public final Block addField(Field ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        for (Field field : fields) {
            if (this.fields.contains(field)) continue;
            this.mutableFields.add(field);
            this.fieldMap.put(field.getId(), field);
        }
        this.schemaDevice.aFieldWasChanged();
        return this;
    }

    @Nullable
    public final Field getField(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return this.fieldMap.get(fieldName);
    }

    @Nullable
    public final Field get(@NotNull String fieldId) {
        Intrinsics.checkNotNullParameter((Object)fieldId, (String)"fieldId");
        return this.fieldMap.get(fieldId);
    }

    public final void sortFieldsByAddress() {
        this.initialize();
        CollectionsKt.sort(this.mutableFields);
    }

    public final boolean initialize() {
        for (Field field : this.fields) {
            field.initialize();
        }
        for (Field field : this.fields) {
            if (field.initialize()) continue;
            return false;
        }
        this.findCircularReference();
        return true;
    }

    private final void findCircularReference() {
        for (Field field : this.fields) {
            List<String> circularReference = this.findCircularReference(CollectionsKt.emptyList(), field);
            if (!(!((Collection)circularReference).isEmpty())) continue;
            throw new ModbusSchemaParseException("Found circular reference starting with field \"" + field.getId() + "\" : " + circularReference);
        }
    }

    private final List<String> findCircularReference(List<String> usageChainSoFar, Field field) {
        if (usageChainSoFar.contains(field.getId())) {
            return usageChainSoFar;
        }
        List usageChain = new ArrayList(usageChainSoFar);
        usageChain.add(field.getId());
        for (String requiredFieldName : field.getRequiredFieldNames()) {
            Field requiredField;
            if (this.fieldMap.get(requiredFieldName) == null) {
                throw new ModbusSchemaParseException("Required field \"" + requiredFieldName + "\" (needed for \"" + field.getId() + "\") is missing.");
            }
            List<String> circularReference = this.findCircularReference(usageChain, requiredField);
            if (!(!((Collection)circularReference).isEmpty())) continue;
            return circularReference;
        }
        return CollectionsKt.emptyList();
    }

    public final void toTable(@NotNull StringTable table, boolean onlyUseFullFields) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String[] stringArray = new String[4];
        stringArray[0] = this.id;
        stringArray[1] = "";
        stringArray[2] = "";
        String string = this.description;
        if (string == null) {
            string = "";
        }
        stringArray[3] = string;
        table.addRow(stringArray);
        for (Field field : this.fields) {
            field.toTable(table, onlyUseFullFields);
        }
    }

    @NotNull
    public String toString() {
        return "Block(id='" + this.id + "', description=" + this.description + ", fetchGroup=" + this.fetchGroup + ", addressClass=" + this.addressClass + ", fieldMap=" + this.fieldMap + ")";
    }

    public final void update() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field field = (Field)element$iv;
            boolean bl = false;
            field.update();
        }
    }

    public final void need() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field field = (Field)element$iv;
            boolean bl = false;
            field.need();
        }
    }

    public final void unNeed() {
        Iterable $this$forEach$iv = this.fields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field field = (Field)element$iv;
            boolean bl = false;
            field.unNeed();
        }
    }

    @JvmStatic
    @NotNull
    public static final BlockBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnl/basjes/modbus/schema/Block$BlockBuilder;", "", "<init>", "()V", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "<set-?>", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "setSchemaDevice", "(Lnl/basjes/modbus/schema/SchemaDevice;)V", "schemaDevice$delegate", "Lkotlin/properties/ReadWriteProperty;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "id$delegate", "description", "fetchGroup", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "build", "Lnl/basjes/modbus/schema/Block;", "modbus-schema-device"})
    @SourceDebugExtension(value={"SMAP\nBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Block.kt\nnl/basjes/modbus/schema/Block$BlockBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
    public static class BlockBuilder {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty schemaDevice$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private final ReadWriteProperty id$delegate = Delegates.INSTANCE.notNull();
        @Nullable
        private String description;
        @Nullable
        private String fetchGroup;
        @Nullable
        private AddressClass addressClass;

        @NotNull
        public final BlockBuilder schemaDevice(@NotNull SchemaDevice schemaDevice) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
            BlockBuilder $this$schemaDevice_u24lambda_u240 = blockBuilder = this;
            boolean bl = false;
            $this$schemaDevice_u24lambda_u240.setSchemaDevice(schemaDevice);
            return blockBuilder;
        }

        private final SchemaDevice getSchemaDevice() {
            return (SchemaDevice)this.schemaDevice$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setSchemaDevice(SchemaDevice schemaDevice) {
            this.schemaDevice$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)schemaDevice);
        }

        @NotNull
        public final BlockBuilder id(@NotNull String id) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            BlockBuilder $this$id_u24lambda_u241 = blockBuilder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.setId(id);
            return blockBuilder;
        }

        private final String getId() {
            return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final void setId(String string) {
            this.id$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @NotNull
        public final BlockBuilder description(@NotNull String description) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            BlockBuilder $this$description_u24lambda_u242 = blockBuilder = this;
            boolean bl = false;
            $this$description_u24lambda_u242.description = description;
            return blockBuilder;
        }

        @NotNull
        public final BlockBuilder fetchGroup(@NotNull String fetchGroup) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)fetchGroup, (String)"fetchGroup");
            BlockBuilder $this$fetchGroup_u24lambda_u243 = blockBuilder = this;
            boolean bl = false;
            $this$fetchGroup_u24lambda_u243.fetchGroup = fetchGroup;
            return blockBuilder;
        }

        @NotNull
        public final BlockBuilder addressClass(@NotNull AddressClass addressClass) {
            BlockBuilder blockBuilder;
            Intrinsics.checkNotNullParameter((Object)addressClass, (String)"addressClass");
            BlockBuilder $this$addressClass_u24lambda_u244 = blockBuilder = this;
            boolean bl = false;
            $this$addressClass_u24lambda_u244.addressClass = addressClass;
            return blockBuilder;
        }

        @NotNull
        public final Block build() {
            Block block;
            String finalDescription = this.description;
            Block block2 = block = finalDescription == null ? new Block(this.getSchemaDevice(), this.getId(), null, 4, null) : new Block(this.getSchemaDevice(), this.getId(), finalDescription);
            if (this.fetchGroup != null) {
                block.setFetchGroup(this.fetchGroup);
            }
            if (this.addressClass != null) {
                block.setAddressClass(this.addressClass);
            }
            return block;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BlockBuilder.class, "schemaDevice", "getSchemaDevice()Lnl/basjes/modbus/schema/SchemaDevice;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BlockBuilder.class, "id", "getId()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/Block$Companion;", "", "<init>", "()V", "builder", "Lnl/basjes/modbus/schema/Block$BlockBuilder;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BlockBuilder builder() {
            return new BlockBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

