/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.RegisterBlockFetcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lnl/basjes/modbus/schema/fetcher/OptimizingRegisterBlockFetcher;", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "value", "", "allowedGapReadSize", "getAllowedGapReadSize", "()I", "setAllowedGapReadSize", "(I)V", "calculateFetchBatches", "", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "maxAge", "", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nOptimizingRegisterBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizingRegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/OptimizingRegisterBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class OptimizingRegisterBlockFetcher
extends RegisterBlockFetcher {
    private int allowedGapReadSize;

    public OptimizingRegisterBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        super(schemaDevice, modbusDevice);
    }

    public final int getAllowedGapReadSize() {
        return this.allowedGapReadSize;
    }

    public final void setAllowedGapReadSize(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "A negative Gap Read Size is not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        this.allowedGapReadSize = value;
    }

    @Override
    @NotNull
    public List<RegisterBlockFetcher.FetchBatch> calculateFetchBatches(long maxAge) {
        List<RegisterBlockFetcher.FetchBatch> baseFetchBatchList = super.calculateFetchBatches(maxAge);
        List fetchBatches = new ArrayList();
        Iterator<RegisterBlockFetcher.FetchBatch> fetchBatchIterator = baseFetchBatchList.iterator();
        if (!fetchBatchIterator.hasNext()) {
            return CollectionsKt.emptyList();
        }
        RegisterBlockFetcher.FetchBatch nextInput = fetchBatchIterator.next();
        RegisterBlockFetcher.FetchBatch nextBatch = new RegisterBlockFetcher.FetchBatch();
        nextBatch.setStart(nextInput.getStart());
        nextBatch.setCount(nextInput.getCount());
        fetchBatches.add(nextBatch);
        while (fetchBatchIterator.hasNext()) {
            nextInput = fetchBatchIterator.next();
            Address address = nextBatch.getStart();
            Intrinsics.checkNotNull((Object)address);
            AddressClass addressClass = address.getAddressClass();
            Address address2 = nextInput.getStart();
            Intrinsics.checkNotNull((Object)address2);
            if (addressClass != address2.getAddressClass()) {
                nextBatch = new RegisterBlockFetcher.FetchBatch();
                nextBatch.setStart(nextInput.getStart());
                nextBatch.setCount(nextInput.getCount());
                fetchBatches.add(nextBatch);
                continue;
            }
            Address address3 = nextBatch.getStart();
            Intrinsics.checkNotNull((Object)address3);
            Address lastOfNextBatch = address3.increment(nextBatch.getCount());
            Address address4 = nextInput.getStart();
            Intrinsics.checkNotNull((Object)address4);
            if (Intrinsics.areEqual((Object)address4, (Object)lastOfNextBatch)) {
                if (nextBatch.getCount() + nextInput.getCount() <= this.getModbusDevice().getMaxRegistersPerModbusRequest()) {
                    RegisterBlockFetcher.FetchBatch fetchBatch = nextBatch;
                    fetchBatch.setCount(fetchBatch.getCount() + nextInput.getCount());
                    continue;
                }
                nextBatch = new RegisterBlockFetcher.FetchBatch();
                nextBatch.setStart(nextInput.getStart());
                nextBatch.setCount(nextInput.getCount());
                fetchBatches.add(nextBatch);
                continue;
            }
            Address address5 = nextBatch.getStart();
            Intrinsics.checkNotNull((Object)address5);
            int nextBatchStart = address5.getPhysicalAddress();
            Address address6 = nextInput.getStart();
            Intrinsics.checkNotNull((Object)address6);
            int nextInputStart = address6.getPhysicalAddress();
            int gapSize = nextInputStart - (nextBatchStart + nextBatch.getCount());
            int mergedCount = nextInputStart + nextInput.getCount() - nextBatchStart;
            if (gapSize <= this.allowedGapReadSize && mergedCount <= this.getModbusDevice().getMaxRegistersPerModbusRequest()) {
                nextBatch.setCount(mergedCount);
                continue;
            }
            nextBatch = new RegisterBlockFetcher.FetchBatch();
            nextBatch.setStart(nextInput.getStart());
            nextBatch.setCount(nextInput.getCount());
            fetchBatches.add(nextBatch);
        }
        return fetchBatches;
    }
}

