/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 .2\u00020\u0001:\u0002-.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010!\u001a\u00020\u001cH\u0002J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u001cJ\u0012\u0010'\u001a\u00020\u001c2\b\b\u0002\u0010(\u001a\u00020)H\u0007J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00182\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 \u00a8\u0006/"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "fetchGroupToAddresses", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "getFetchGroupToAddresses", "()Ljava/util/Map;", "neededFieldsMap", "Lnl/basjes/modbus/schema/Field;", "", "getNeededFieldsMap", "neededFields", "", "getNeededFields", "()Ljava/util/List;", "initialize", "", "lastFetchGroupToAddressesMappingTimestamp", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "ensureValidFetchGroupToAddressesMapping", "need", "field", "unNeed", "needAll", "unNeedAll", "updateAll", "maxAge", "", "update", "calculateFetchBatches", "Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "FetchBatch", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nRegisterBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n774#2:268\n865#2,2:269\n1557#2:271\n1628#2,3:272\n1863#2,2:275\n1863#2,2:277\n1557#2:279\n1628#2,3:280\n1381#2:283\n1469#2,5:284\n1863#2,2:289\n1557#2:291\n1628#2,3:292\n1381#2:295\n1469#2,5:296\n1863#2,2:301\n1557#2:303\n1628#2,3:304\n295#2,2:307\n*S KotlinDebug\n*F\n+ 1 RegisterBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher\n*L\n46#1:268\n46#1:269,2\n47#1:271\n47#1:272,3\n107#1:275,2\n115#1:277,2\n123#1:279\n123#1:280,3\n124#1:283\n124#1:284,5\n125#1:289,2\n133#1:291\n133#1:292,3\n134#1:295\n134#1:296,5\n135#1:301,2\n233#1:303\n233#1:304,3\n234#1:307,2\n*E\n"})
public class RegisterBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private final Map<String, List<Address>> fetchGroupToAddresses;
    @NotNull
    private final Map<Field, Integer> neededFieldsMap;
    private Instant lastFetchGroupToAddressesMappingTimestamp;
    public static final long FORCE_UPDATE_MAX_AGE = -1000000000000L;
    @NotNull
    private static final Logger LOG;

    public RegisterBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
        this.fetchGroupToAddresses = new TreeMap();
        this.neededFieldsMap = new TreeMap();
        this.lastFetchGroupToAddressesMappingTimestamp = Instant.ofEpochMilli(0L);
        this.initialize();
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    @NotNull
    protected final Map<String, List<Address>> getFetchGroupToAddresses() {
        return this.fetchGroupToAddresses;
    }

    @NotNull
    protected final Map<Field, Integer> getNeededFieldsMap() {
        return this.neededFieldsMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Field> getNeededFields() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.neededFieldsMap.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Field)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    public final void initialize() {
        this.fetchGroupToAddresses.clear();
        this.neededFieldsMap.clear();
        this.lastFetchGroupToAddressesMappingTimestamp = Instant.ofEpochMilli(0L);
        this.ensureValidFetchGroupToAddressesMapping();
    }

    private final void ensureValidFetchGroupToAddressesMapping() {
        if (this.schemaDevice.getLastFieldModificationTimestamp().isBefore(this.lastFetchGroupToAddressesMappingTimestamp)) {
            return;
        }
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredRegisters = field.getRequiredRegisters();
                for (Address requiredRegister : requiredRegisters) {
                    RegisterValue registerValue = this.schemaDevice.getRegisterBlock(requiredRegister.getAddressClass()).computeIfAbsent(requiredRegister, RegisterBlockFetcher::ensureValidFetchGroupToAddressesMapping$lambda$2);
                    registerValue.setImmutable(fieldImmutable);
                    registerValue.setFetchGroup(fieldFetchGroup);
                }
                this.fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> RegisterBlockFetcher.ensureValidFetchGroupToAddressesMapping$lambda$4(RegisterBlockFetcher::ensureValidFetchGroupToAddressesMapping$lambda$3, arg_0)).addAll((Collection)requiredRegisters);
            }
        }
        for (Map.Entry entry : this.fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        this.lastFetchGroupToAddressesMappingTimestamp = Instant.now();
    }

    public final void need(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        field.initialize();
        this.neededFieldsMap.merge(field, 1, (arg_0, arg_1) -> RegisterBlockFetcher.need$lambda$7(RegisterBlockFetcher::need$lambda$6, arg_0, arg_1));
        Iterable $this$forEach$iv = field.getRequiredFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            this.need(it);
        }
    }

    public final void unNeed(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.neededFieldsMap.merge(field, -1, (arg_0, arg_1) -> RegisterBlockFetcher.unNeed$lambda$10(RegisterBlockFetcher::unNeed$lambda$9, arg_0, arg_1));
        Iterable $this$forEach$iv = field.getRequiredFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            this.unNeed(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void needAll() {
        void $this$flatMapTo$iv$iv;
        List it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.schemaDevice.getBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Block block = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Block)((Object)it)).getFields());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            Sequence list$iv$iv = CollectionsKt.asSequence((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it2 = (Field)element$iv;
            boolean bl = false;
            this.need(it2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unNeedAll() {
        void $this$flatMapTo$iv$iv;
        List it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.schemaDevice.getBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Block block = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Block)((Object)it)).getFields());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            Sequence list$iv$iv = CollectionsKt.asSequence((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it2 = (Field)element$iv;
            boolean bl = false;
            this.unNeed(it2);
        }
    }

    @JvmOverloads
    public final void updateAll(long maxAge) throws ModbusException {
        this.needAll();
        this.update(maxAge);
        this.unNeedAll();
    }

    public static /* synthetic */ void updateAll$default(RegisterBlockFetcher registerBlockFetcher, long l, int n, Object object) throws ModbusException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateAll");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        registerBlockFetcher.updateAll(l);
    }

    public final void update(@NotNull Field field) throws ModbusException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureValidFetchGroupToAddressesMapping();
        List<Address> requiredRegisters = this.fetchGroupToAddresses.get(field.getFetchGroup());
        Collection collection = requiredRegisters;
        if (collection == null || collection.isEmpty()) {
            requiredRegisters = field.getRequiredRegisters();
        }
        RegisterBlock deviceRegisters = this.modbusDevice.getRegisters(requiredRegisters.get(0), requiredRegisters.size());
        this.schemaDevice.getRegisterBlock(deviceRegisters.getAddressClass()).merge(deviceRegisters);
    }

    public final void update(long maxAge) {
        this.ensureValidFetchGroupToAddressesMapping();
        for (FetchBatch fetchBatch : this.calculateFetchBatches(maxAge)) {
            try {
                Address address = fetchBatch.getStart();
                Intrinsics.checkNotNull((Object)address);
                RegisterBlock registers = this.modbusDevice.getRegisters(address, fetchBatch.getCount());
                this.schemaDevice.getRegisterBlock(registers.getAddressClass()).merge(registers);
            }
            catch (ModbusException me) {
                LOG.error("Got ModbusException on {} --> {}", (Object)fetchBatch, (Object)me);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<FetchBatch> calculateFetchBatches(long maxAge) {
        long now = System.currentTimeMillis();
        List fieldsThatMustBeUpdated = new ArrayList();
        for (Field field : this.getNeededFields()) {
            Object v0;
            block4: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                List<Address> requiredRegisters = field.getRequiredRegisters();
                if (requiredRegisters.isEmpty()) continue;
                RegisterBlock registerBlock = this.schemaDevice.getRegisterBlock(requiredRegisters.get(0).getAddressClass());
                Iterable iterable = requiredRegisters;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(registerBlock.get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RegisterValue it = (RegisterValue)element$iv;
                    boolean bl = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            if (v0 == null) continue;
            fieldsThatMustBeUpdated.add(field);
        }
        Map fetchBatchesMap = new TreeMap();
        for (Field field : fieldsThatMustBeUpdated) {
            List<Address> addresses;
            if (fetchBatchesMap.containsKey(field.getFetchGroup())) continue;
            Intrinsics.checkNotNull(this.fetchGroupToAddresses.get(field.getFetchGroup()));
            FetchBatch fetchBatch = new FetchBatch();
            fetchBatch.setStart(addresses.get(0));
            fetchBatch.setCount(addresses.size());
            fetchBatchesMap.put(field.getFetchGroup(), fetchBatch);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)fetchBatchesMap.values()));
    }

    @JvmOverloads
    public final void updateAll() throws ModbusException {
        RegisterBlockFetcher.updateAll$default(this, 0L, 1, null);
    }

    private static final RegisterValue ensureValidFetchGroupToAddressesMapping$lambda$2(Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegisterValue(it);
    }

    private static final List ensureValidFetchGroupToAddressesMapping$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List ensureValidFetchGroupToAddressesMapping$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Integer need$lambda$6(Integer a, Integer b) {
        Integer n = a;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = b;
        Intrinsics.checkNotNull((Object)n3);
        return Integer.sum(n2, n3);
    }

    private static final Integer need$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer unNeed$lambda$9(Integer a, Integer b) {
        Integer n = a;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = b;
        Intrinsics.checkNotNull((Object)n3);
        return Integer.sum(n2, n3);
    }

    private static final Integer unNeed$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$Companion;", "", "<init>", "()V", "FORCE_UPDATE_MAX_AGE", "", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lnl/basjes/modbus/schema/fetcher/RegisterBlockFetcher$FetchBatch;", "", "<init>", "()V", "start", "Lnl/basjes/modbus/device/api/Address;", "getStart", "()Lnl/basjes/modbus/device/api/Address;", "setStart", "(Lnl/basjes/modbus/device/api/Address;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "modbus-schema-device"})
    public static final class FetchBatch
    implements Comparable<FetchBatch> {
        @Nullable
        private Address start;
        private int count;

        @Nullable
        public final Address getStart() {
            return this.start;
        }

        public final void setStart(@Nullable Address address) {
            this.start = address;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @Override
        public int compareTo(@NotNull FetchBatch other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Address address = this.start;
            Intrinsics.checkNotNull((Object)address);
            Address address2 = other.start;
            Intrinsics.checkNotNull((Object)address2);
            int addressCompare = address.compareTo(address2);
            if (addressCompare != 0) {
                return addressCompare;
            }
            return Intrinsics.compare((int)this.count, (int)other.count);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FetchBatch)) {
                return false;
            }
            return this.count == ((FetchBatch)other).count && Intrinsics.areEqual((Object)this.start, (Object)((FetchBatch)other).start);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.start, this.count};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            return "FetchBatch{ " + this.start + " # " + this.count + "}";
        }
    }
}

