/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaMissingFieldException;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.parser.ExpressionParser;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.expression.strings.StringListExpression;
import nl.basjes.modbus.schema.utils.DoubleToString;
import nl.basjes.modbus.schema.utils.StringTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 Q2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002QRBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020-J\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020DJ\u0006\u0010F\u001a\u00020DJ\u0016\u0010I\u001a\u00020D2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\bJ\u0011\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0000H\u0096\u0002J\b\u0010P\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u00020\b8F\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0013\u0010\u0019\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0013\u0010.\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0012R\u0019\u00100\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u00104\u001a\u0004\u0018\u0001058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0013\u00108\u001a\u0004\u0018\u0001098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0005018F\u00a2\u0006\u0006\u001a\u0004\b=\u00103R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\u0000018F\u00a2\u0006\u0006\u001a\u0004\b?\u00103R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020A018F\u00a2\u0006\u0006\u001a\u0004\bB\u00103R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\u0005018F\u00a2\u0006\u0006\u001a\u0004\bH\u00103\u00a8\u0006S"}, d2={"Lnl/basjes/modbus/schema/Field;", "", "block", "Lnl/basjes/modbus/schema/Block;", "id", "", "description", "immutable", "", "system", "expression", "unit", "fetchGroup", "<init>", "(Lnl/basjes/modbus/schema/Block;Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBlock", "()Lnl/basjes/modbus/schema/Block;", "getDescription", "()Ljava/lang/String;", "getExpression", "getUnit", "getFetchGroup", "setFetchGroup", "(Ljava/lang/String;)V", "getId", "value", "Lnl/basjes/modbus/schema/ReturnType;", "returnType", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "initialized", "initialize", "Lnl/basjes/modbus/schema/expression/Expression;", "parsedExpression", "getParsedExpression", "()Lnl/basjes/modbus/schema/expression/Expression;", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "isSystem", "()Z", "isImmutable", "", "getValue", "()Ljava/lang/Object;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "stringValue", "getStringValue", "stringListValue", "", "getStringListValue", "()Ljava/util/List;", "doubleValue", "", "getDoubleValue", "()Ljava/lang/Double;", "longValue", "", "getLongValue", "()Ljava/lang/Long;", "requiredFieldNames", "getRequiredFieldNames", "requiredFields", "getRequiredFields", "requiredRegisters", "Lnl/basjes/modbus/device/api/Address;", "getRequiredRegisters", "update", "", "need", "unNeed", "testCompareValue", "getTestCompareValue", "toTable", "table", "Lnl/basjes/modbus/schema/utils/StringTable;", "onlyUseFullFields", "compareTo", "", "other", "toString", "Companion", "FieldBuilder", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n1617#2,9:502\n1869#2:511\n1870#2:513\n1626#2:514\n1#3:512\n*S KotlinDebug\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field\n*L\n267#1:502,9\n267#1:511\n267#1:513\n267#1:514\n267#1:512\n*E\n"})
public final class Field
implements Comparable<Field> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block block;
    @NotNull
    private final String description;
    @NotNull
    private final String expression;
    @NotNull
    private final String unit;
    @NotNull
    private String fetchGroup;
    @NotNull
    private final String id;
    @NotNull
    private ReturnType returnType;
    private boolean initialized;
    @Nullable
    private Expression parsedExpression;
    @Nullable
    private AddressClass addressClass;
    private final boolean isSystem;
    private final boolean isImmutable;

    public Field(@NotNull Block block, @NotNull String id, @NotNull String description, boolean immutable, boolean system, @NotNull String expression, @NotNull String unit, @NotNull String fetchGroup) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)fetchGroup, (String)"fetchGroup");
        this.block = block;
        this.description = description;
        this.expression = expression;
        this.unit = unit;
        this.fetchGroup = fetchGroup;
        this.id = ((Object)StringsKt.trim((CharSequence)id)).toString();
        this.returnType = ReturnType.UNKNOWN;
        this.returnType = this.returnType;
        this.isSystem = system;
        this.isImmutable = immutable;
        Field[] fieldArray = new Field[]{this};
        this.block.addField(fieldArray);
    }

    public /* synthetic */ Field(Block block, String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            string4 = "";
        }
        if ((n & 0x80) != 0) {
            Object object = block.getFetchGroup();
            if (object == null) {
                object = block.getId() + " | " + string;
            }
            string5 = object;
        }
        this(block, string, string2, bl, bl2, string3, string4, string5);
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final String getUnit() {
        return this.unit;
    }

    @NotNull
    public final String getFetchGroup() {
        return this.fetchGroup;
    }

    public final void setFetchGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fetchGroup = string;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ReturnType getReturnType() {
        return this.returnType;
    }

    public final boolean initialize() {
        if (!this.initialized) {
            Expression theExpression;
            if (this.parsedExpression == null && !StringsKt.isBlank((CharSequence)this.expression)) {
                try {
                    this.parsedExpression = ExpressionParser.Companion.parse(this.expression);
                }
                catch (ModbusSchemaParseException e) {
                    throw new ModbusSchemaParseException("Field \"" + this.id + "\": Unable to parse the expression >>" + this.expression + "<< --> " + e.getMessage(), e);
                }
            }
            if ((theExpression = this.parsedExpression) != null) {
                boolean bl = this.initialized = theExpression.initialize(this) && theExpression.getProblems().isEmpty();
                if (this.initialized) {
                    ReturnType actualReturnType;
                    boolean allHaveBeenInitialized = true;
                    for (int retry = 0; retry < 6; ++retry) {
                        allHaveBeenInitialized = true;
                        for (String requiredFieldName : theExpression.getRequiredFields()) {
                            Field requiredField;
                            if (this.block.getField(requiredFieldName) == null) {
                                throw new ModbusSchemaMissingFieldException("In block " + this.block.getId() + " the field " + this.id + " needs the field " + requiredFieldName + " which is missing.");
                            }
                            if (requiredField.initialize()) continue;
                            allHaveBeenInitialized = false;
                        }
                        if (allHaveBeenInitialized) break;
                    }
                    if (!allHaveBeenInitialized) {
                        System.out.println((Object)"ERROR");
                    }
                    if (!((actualReturnType = theExpression.getReturnType()) != ReturnType.UNKNOWN)) {
                        boolean $i$a$-require-Field$initialize$32 = false;
                        String $i$a$-require-Field$initialize$32 = "The expression dictated an UNKNOWN return type ?!?!?";
                        throw new IllegalArgumentException($i$a$-require-Field$initialize$32.toString());
                    }
                    if (this.returnType == ReturnType.UNKNOWN) {
                        this.returnType = actualReturnType;
                    } else if (!(this.returnType == actualReturnType)) {
                        boolean bl2 = false;
                        String string = "Field " + this.id + " was tagged it should return " + this.returnType + " but the provided expression returns a " + actualReturnType;
                        throw new IllegalArgumentException(string.toString());
                    }
                    List<Address> requiredRegisters = theExpression.getRequiredRegisters();
                    if (requiredRegisters.isEmpty()) {
                        this.addressClass = null;
                    } else {
                        this.addressClass = requiredRegisters.get(0).getAddressClass();
                        for (Address requiredRegister : requiredRegisters) {
                            if (this.addressClass == requiredRegister.getAddressClass()) continue;
                            throw new ModbusSchemaParseException("For field " + this.block.getId() + "::" + this.id + " the expression " + theExpression + " requires values from multiple AddressClasses (which is illegal)");
                        }
                    }
                    if (this.isImmutable()) {
                        theExpression.setImmutable(true);
                    }
                }
            }
        }
        return this.initialized;
    }

    @Nullable
    public final Expression getParsedExpression() {
        return this.parsedExpression;
    }

    public final boolean isSystem() {
        return this.isSystem;
    }

    public final boolean isImmutable() {
        block6: {
            block5: {
                if (this.isImmutable) {
                    return true;
                }
                if (this.parsedExpression == null) break block5;
                Expression expression = this.parsedExpression;
                Intrinsics.checkNotNull((Object)expression);
                if (expression.isImmutable()) break block6;
            }
            return false;
        }
        for (Field requiredField : this.getRequiredFields()) {
            if (requiredField.isImmutable()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final Object getValue() {
        return this.getValue(this.block.getSchemaDevice());
    }

    @Nullable
    public final Object getValue(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        if (this.parsedExpression instanceof StringExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringExpression");
            return ((StringExpression)expression).getValue(schemaDevice);
        }
        if (this.parsedExpression instanceof StringListExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringListExpression");
            return ((StringListExpression)expression).getValue(schemaDevice);
        }
        if (this.parsedExpression instanceof NumericalExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            if (((NumericalExpression)expression).getReturnType() == ReturnType.LONG) {
                Expression expression2 = this.parsedExpression;
                Intrinsics.checkNotNull((Object)expression2, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
                return ((NumericalExpression)expression2).getValueAsLong(schemaDevice);
            }
            Expression expression3 = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression3, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            if (((NumericalExpression)expression3).getReturnType() == ReturnType.DOUBLE) {
                Expression expression4 = this.parsedExpression;
                Intrinsics.checkNotNull((Object)expression4, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
                return ((NumericalExpression)expression4).getValueAsDouble(schemaDevice);
            }
        }
        return null;
    }

    @Nullable
    public final String getStringValue() {
        if (this.parsedExpression instanceof StringExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringExpression");
            return ((StringExpression)expression).getValue(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final List<String> getStringListValue() {
        if (this.parsedExpression instanceof StringListExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringListExpression");
            return ((StringListExpression)expression).getValue(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final Double getDoubleValue() {
        if (this.parsedExpression instanceof NumericalExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            return ((NumericalExpression)expression).getValueAsDouble(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final Long getLongValue() {
        if (this.parsedExpression instanceof NumericalExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            return ((NumericalExpression)expression).getValueAsLong(this.block.getSchemaDevice());
        }
        return null;
    }

    @NotNull
    public final List<String> getRequiredFieldNames() {
        Object object = this.parsedExpression;
        if (object == null || (object = object.getRequiredFields()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<Field> getRequiredFields() {
        List list;
        List<String> list2;
        Expression expression = this.parsedExpression;
        if (expression != null && (list2 = expression.getRequiredFields()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Field it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.block.getField(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (list3 != null) {
                list = list3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    @NotNull
    public final List<Address> getRequiredRegisters() {
        Object object = this.parsedExpression;
        if (object == null || (object = object.getRequiredRegisters()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void update() {
        this.block.getSchemaDevice().update(this);
    }

    public final void need() {
        this.block.getSchemaDevice().need(this);
    }

    public final void unNeed() {
        this.block.getSchemaDevice().unNeed(this);
    }

    @NotNull
    public final List<String> getTestCompareValue() {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[this.returnType.ordinal()]) {
            case 1: {
                String string = "Unknown returnType (Field " + this.id + ") means we do not know yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                String string = "Coils are not supported yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 3: {
                if (this.getLongValue() != null) {
                    list = CollectionsKt.listOf((Object)String.valueOf(this.getLongValue()));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            case 4: {
                if (this.getDoubleValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                Double d = this.getDoubleValue();
                Intrinsics.checkNotNull((Object)d);
                if (Double.isNaN(d)) {
                    list = CollectionsKt.listOf((Object)"NaN");
                    break;
                }
                if (Intrinsics.areEqual((Double)this.getDoubleValue(), (double)Double.POSITIVE_INFINITY)) {
                    list = CollectionsKt.listOf((Object)"+Infinite");
                    break;
                }
                if (Intrinsics.areEqual((Double)this.getDoubleValue(), (double)Double.NEGATIVE_INFINITY)) {
                    list = CollectionsKt.listOf((Object)"-Infinite");
                    break;
                }
                String string = "%.3f";
                Object[] objectArray = new Object[]{this.getDoubleValue()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                list = CollectionsKt.listOf((Object)string2);
                break;
            }
            case 5: {
                if (this.getStringValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                String string = this.getStringValue();
                Intrinsics.checkNotNull((Object)string);
                list = CollectionsKt.listOf((Object)string);
                break;
            }
            case 6: {
                if (this.getStringListValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                List list2 = this.getStringListValue();
                list = list2;
                Intrinsics.checkNotNull((Object)list2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    public final void toTable(@NotNull StringTable table, boolean onlyUseFullFields) {
        Object truncatedDescription;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (onlyUseFullFields && this.isSystem) {
            return;
        }
        Object value = null;
        try {
            value = this.getValue();
        }
        catch (ModbusException e) {
            if (onlyUseFullFields) {
                return;
            }
            value = "<<ERROR>>";
        }
        if (value == null) {
            if (onlyUseFullFields) {
                return;
            }
            value = "<<Not Implemented>>";
        } else {
            if (value instanceof Double) {
                value = DoubleToString.INSTANCE.of((Double)value, 5L);
            } else if (value instanceof String) {
                if (onlyUseFullFields && ((CharSequence)value).length() == 0) {
                    return;
                }
                value = "\"" + value + "\"";
            }
            if (value instanceof List) {
                value = "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)value), (CharSequence)",", null, null, (int)0, null, Field::toTable$lambda$3, (int)30, null) + "]";
            }
        }
        Object expressionString = null;
        if (this.parsedExpression == null) {
            if (onlyUseFullFields) {
                return;
            }
            expressionString = "-------";
        } else {
            expressionString = String.valueOf(this.parsedExpression);
            if (((String)expressionString).length() > 50) {
                String string = ((String)expressionString).substring(0, 45);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                expressionString = string + " ...";
            }
        }
        String bytes = "";
        if (this.parsedExpression != null) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression);
            bytes = CollectionsKt.joinToString$default((Iterable)expression.getRegisterValues(this.block.getSchemaDevice()), (CharSequence)" ", null, null, (int)0, null, Field::toTable$lambda$4, (int)30, null);
        }
        if (((String)(truncatedDescription = this.description)).length() > 75) {
            String string = ((String)truncatedDescription).substring(0, 70);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            truncatedDescription = string + " ...";
        }
        String[] stringArray = new String[]{this.block.getId(), this.id, this.isSystem ? "*" : "", truncatedDescription, value.toString(), this.unit, expressionString, bytes};
        table.addRow(stringArray);
    }

    @Override
    public int compareTo(@NotNull Field other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        List<Address> thisRequiredRegisters = this.getRequiredRegisters();
        List<Address> otherRequiredRegisters = other.getRequiredRegisters();
        if (thisRequiredRegisters.isEmpty() && otherRequiredRegisters.isEmpty()) {
            return 0;
        }
        if (thisRequiredRegisters.isEmpty()) {
            return 1;
        }
        if (otherRequiredRegisters.isEmpty()) {
            return -1;
        }
        Address thisAddress = this.getRequiredRegisters().get(0);
        Address otherAddress = other.getRequiredRegisters().get(0);
        return thisAddress.compareTo(otherAddress);
    }

    @NotNull
    public String toString() {
        return "Field(id='" + this.id + "', isSystem=" + this.isSystem + ", isImmutable=" + this.isImmutable() + ", unit=" + this.unit + ", fetchGroup='" + this.fetchGroup + "',  returnType=" + this.returnType + ", initialized=" + this.initialized + ", expression='" + this.expression + "', parsedExpression=" + this.parsedExpression + ", addressClass=" + this.addressClass + ")";
    }

    private static final CharSequence toTable$lambda$3(Object it) {
        return String.valueOf(it);
    }

    private static final CharSequence toTable$lambda$4(RegisterValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHexValue();
    }

    @JvmStatic
    @NotNull
    public static final FieldBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/Field$Companion;", "", "<init>", "()V", "builder", "Lnl/basjes/modbus/schema/Field$FieldBuilder;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FieldBuilder builder() {
            return new FieldBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010\u001e\u001a\u00020\u001fR+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\f\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnl/basjes/modbus/schema/Field$FieldBuilder;", "", "<init>", "()V", "block", "Lnl/basjes/modbus/schema/Block;", "<set-?>", "getBlock", "()Lnl/basjes/modbus/schema/Block;", "setBlock", "(Lnl/basjes/modbus/schema/Block;)V", "block$delegate", "Lkotlin/properties/ReadWriteProperty;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "id$delegate", "description", "immutable", "", "system", "expression", "getExpression", "setExpression", "expression$delegate", "unit", "fetchGroup", "build", "Lnl/basjes/modbus/schema/Field;", "modbus-schema-device"})
    @SourceDebugExtension(value={"SMAP\nField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field$FieldBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n1#2:502\n*E\n"})
    public static class FieldBuilder {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty block$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private final ReadWriteProperty id$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private String description = "";
        private boolean immutable;
        private boolean system;
        @NotNull
        private final ReadWriteProperty expression$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private String unit = "";
        @Nullable
        private String fetchGroup;

        @NotNull
        public final FieldBuilder block(@NotNull Block block) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            FieldBuilder $this$block_u24lambda_u240 = fieldBuilder = this;
            boolean bl = false;
            $this$block_u24lambda_u240.setBlock(block);
            return fieldBuilder;
        }

        private final Block getBlock() {
            return (Block)this.block$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setBlock(Block block) {
            this.block$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)block);
        }

        @NotNull
        public final FieldBuilder id(@NotNull String id) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            FieldBuilder $this$id_u24lambda_u241 = fieldBuilder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.setId(id);
            return fieldBuilder;
        }

        private final String getId() {
            return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final void setId(String string) {
            this.id$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @NotNull
        public final FieldBuilder description(@NotNull String description) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            FieldBuilder $this$description_u24lambda_u242 = fieldBuilder = this;
            boolean bl = false;
            $this$description_u24lambda_u242.description = description;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder immutable(boolean immutable) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$immutable_u24lambda_u243 = fieldBuilder = this;
            boolean bl = false;
            $this$immutable_u24lambda_u243.immutable = immutable;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder system(boolean system) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$system_u24lambda_u244 = fieldBuilder = this;
            boolean bl = false;
            $this$system_u24lambda_u244.system = system;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder expression(@NotNull String expression) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            FieldBuilder $this$expression_u24lambda_u245 = fieldBuilder = this;
            boolean bl = false;
            $this$expression_u24lambda_u245.setExpression(expression);
            return fieldBuilder;
        }

        private final String getExpression() {
            return (String)this.expression$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final void setExpression(String string) {
            this.expression$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
        }

        @NotNull
        public final FieldBuilder unit(@Nullable String unit) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$unit_u24lambda_u246 = fieldBuilder = this;
            boolean bl = false;
            String string = unit;
            if (string == null) {
                string = "";
            }
            $this$unit_u24lambda_u246.unit = string;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder fetchGroup(@NotNull String fetchGroup) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)fetchGroup, (String)"fetchGroup");
            FieldBuilder $this$fetchGroup_u24lambda_u247 = fieldBuilder = this;
            boolean bl = false;
            $this$fetchGroup_u24lambda_u247.fetchGroup = fetchGroup;
            return fieldBuilder;
        }

        @NotNull
        public final Field build() {
            String fetchGroup = this.fetchGroup;
            return fetchGroup == null ? new Field(this.getBlock(), this.getId(), this.description, this.immutable, this.system, this.getExpression(), this.unit, null, 128, null) : new Field(this.getBlock(), this.getId(), this.description, this.immutable, this.system, this.getExpression(), this.unit, fetchGroup);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "block", "getBlock()Lnl/basjes/modbus/schema/Block;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "id", "getId()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "expression", "getExpression()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnType.values().length];
            try {
                nArray[ReturnType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRINGLIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

