/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.utils.DoubleToString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/DoubleConstant;", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "value", "", "<init>", "(D)V", "getValue", "()D", "toString", "", "problems", "", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "()Ljava/util/List;", "unused", "", "isImmutable", "()Z", "setImmutable", "(Z)V", "getValueAsDouble", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Double;", "getGuarantee", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression$ValueGuarantee;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "modbus-schema-device"})
public final class DoubleConstant
implements NumericalExpression {
    private final double value;
    private boolean isImmutable;

    public DoubleConstant(double value) {
        this.value = value;
        this.isImmutable = true;
    }

    public final double getValue() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return DoubleToString.INSTANCE.of(this.value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{NumericalExpression.DefaultImpls.getProblems(this), this.checkFatal(Math.abs(this.value) <= Double.MAX_VALUE, "Not a finite number")};
        return this.combine("DoubleConstant", listArray);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean unused) {
        this.isImmutable = true;
    }

    @Override
    @NotNull
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.value;
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        return this.value >= 0.0 ? NumericalExpression.ValueGuarantee.POSITIVE : (this.value < 0.0 ? NumericalExpression.ValueGuarantee.NEGATIVE : NumericalExpression.ValueGuarantee.NONE);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.DOUBLE;
    }

    @Override
    @Nullable
    public Long getValueAsLong(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.DefaultImpls.getValueAsLong(this, schemaDevice);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return NumericalExpression.DefaultImpls.toString(this, isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return NumericalExpression.DefaultImpls.initialize(this, containingField);
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return NumericalExpression.DefaultImpls.getSubExpressions(this);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return NumericalExpression.DefaultImpls.getRequiredRegisters(this);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return NumericalExpression.DefaultImpls.getRequiredFields(this);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.DefaultImpls.getRegisterValues(this, schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return NumericalExpression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return NumericalExpression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return NumericalExpression.DefaultImpls.combine(this, function, problems);
    }
}

