/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.registers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\u00a8\u0006$"}, d2={"Lnl/basjes/modbus/schema/expression/registers/SwapEndian;", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "registers", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;)V", "getRegisters", "()Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "toString", "", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "requiredRegisters", "Lnl/basjes/modbus/device/api/Address;", "getRequiredRegisters", "returnedRegisters", "", "getReturnedRegisters", "()I", "value", "", "isImmutable", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getByteArray", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "reverseBits", "", "modbus-schema-device"})
public final class SwapEndian
implements RegistersExpression {
    @NotNull
    private final RegistersExpression registers;

    public SwapEndian(@NotNull RegistersExpression registers) {
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        this.registers = registers;
    }

    @NotNull
    public final RegistersExpression getRegisters() {
        return this.registers;
    }

    @NotNull
    public String toString() {
        return "swapendian(" + this.registers + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registers);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return this.registers.getRequiredRegisters();
    }

    @Override
    public int getReturnedRegisters() {
        return this.registers.getReturnedRegisters();
    }

    @Override
    public boolean isImmutable() {
        return this.registers.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.registers.setImmutable(value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.checkFatal(this.registers.getReturnedRegisters() == 1, "Need exactly 1 register")};
        return this.combine("swapendian", listArray);
    }

    @Override
    @Nullable
    public byte[] getByteArray(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] byArray = this.registers.getByteArray(schemaDevice);
        if (byArray == null) {
            return null;
        }
        byte[] input = byArray;
        short inputShort = ByteConversions.INSTANCE.bytesToShort(input);
        short result = this.reverseBits(inputShort);
        return ByteConversions.INSTANCE.shortToBytes(result);
    }

    private final short reverseBits(short value) {
        short number = value;
        int sizeOfShort = 16;
        short reverse = 0;
        for (int position = sizeOfShort - 1; -1 < position; --position) {
            reverse = (short)(reverse + (short)((number & 1) << position));
            number = (short)(number >> 1);
        }
        return reverse;
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return RegistersExpression.DefaultImpls.toString(this, isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return RegistersExpression.DefaultImpls.initialize(this, containingField);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return RegistersExpression.DefaultImpls.getRequiredFields(this);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return RegistersExpression.DefaultImpls.getReturnType(this);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return RegistersExpression.DefaultImpls.getRegisterValues(this, schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return RegistersExpression.DefaultImpls.check(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return RegistersExpression.DefaultImpls.checkFatal(this, condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return RegistersExpression.DefaultImpls.combine(this, function, problems);
    }
}

