/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.utils;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"isValidIdentifier", "", "id", "", "requireValidIdentifier", "", "fieldName", "modbus-schema-device"})
public final class ParameterValidationsKt {
    public static final boolean isValidIdentifier(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$").matcher(id).matches();
    }

    public static final void requireValidIdentifier(@NotNull String id, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (!ParameterValidationsKt.isValidIdentifier(id)) {
            throw new ModbusSchemaParseException("Illegal " + fieldName + ": " + id);
        }
    }
}

