/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0006H\u0016J\"\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J0\u0010\u0011\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001f\u0010\u0013\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u0017\u001a\u00020\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnl/basjes/modbus/schema/utils/StringTable;", "", "<init>", "()V", "headers", "", "", "lines", "", "toString", "writeSeparator", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "columnWidths", "", "writeLine", "fields", "withHeaders", "", "([Ljava/lang/String;)Lnl/basjes/modbus/schema/utils/StringTable;", "addRow", "addRowSeparator", "modbus-schema-device"})
public final class StringTable {
    @NotNull
    private List<String> headers = new ArrayList();
    @NotNull
    private final List<List<String>> lines = new ArrayList();

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        List columnWidths = new ArrayList();
        int n = ((Collection)this.headers).size();
        for (int column = 0; column < n; ++column) {
            int maxWidth = this.headers.get(column).length();
            for (List<String> line : this.lines) {
                if (!(!((Collection)line).isEmpty()) || line.size() <= column) continue;
                String columnValue = line.get(column);
                maxWidth = (int)Math.max((double)maxWidth, (double)columnValue.length());
            }
            columnWidths.add(maxWidth);
        }
        this.writeSeparator(sb, columnWidths);
        this.writeLine(sb, columnWidths, this.headers);
        this.writeSeparator(sb, columnWidths);
        for (List<String> line : this.lines) {
            this.writeLine(sb, columnWidths, line);
        }
        this.writeSeparator(sb, columnWidths);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void writeSeparator(StringBuilder sb, List<Integer> columnWidths) {
        boolean first = true;
        Iterator<Integer> iterator = columnWidths.iterator();
        while (iterator.hasNext()) {
            int columnWidth = ((Number)iterator.next()).intValue();
            if (first) {
                sb.append('|');
                first = false;
            } else {
                sb.append('+');
            }
            sb.append(StringsKt.repeat((CharSequence)"-", (int)(columnWidth + 2)));
        }
        sb.append('|');
        sb.append('\n');
    }

    private final void writeLine(StringBuilder sb, List<Integer> columnWidths, List<String> fields) {
        if (fields.isEmpty()) {
            this.writeSeparator(sb, columnWidths);
            return;
        }
        int columns = (int)Math.max((double)columnWidths.size(), (double)fields.size());
        for (int columnNr = 0; columnNr < columns; ++columnNr) {
            int columnWidth = 1;
            if (columnNr < columnWidths.size()) {
                columnWidth = ((Number)columnWidths.get(columnNr)).intValue();
            }
            if (columnNr <= columnWidths.size()) {
                sb.append('|');
            }
            String field = "";
            if (columnNr < fields.size()) {
                field = fields.get(columnNr);
            }
            String string = " %-" + columnWidth + "s ";
            Object[] objectArray = new Object[]{field};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2);
        }
        if (columns <= columnWidths.size()) {
            sb.append('|');
        }
        sb.append('\n');
    }

    @NotNull
    public final StringTable withHeaders(String ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.headers = CollectionsKt.listOf((Object[])Arrays.copyOf(fields, fields.length));
        return this;
    }

    @NotNull
    public final StringTable withHeaders(@NotNull List<String> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.headers = new ArrayList(fields);
        return this;
    }

    @NotNull
    public final StringTable addRow(String ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.lines.add(CollectionsKt.listOf((Object[])Arrays.copyOf(fields, fields.length)));
        return this;
    }

    @NotNull
    public final StringTable addRow(@NotNull List<String> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.lines.add(new ArrayList(fields));
        return this;
    }

    @NotNull
    public final StringTable addRowSeparator() {
        this.lines.add(new ArrayList());
        return this;
    }
}

