/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/SubExpression;", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "name", "", "left", "right", "<init>", "(Ljava/lang/String;Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;)V", "getName", "()Ljava/lang/String;", "getLeft", "()Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "getRight", "operatorSymbol", "getOperatorSymbol", "toString", "isTop", "", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbus-schema-device"})
public abstract class SubExpression
implements NumericalExpression {
    @NotNull
    private final String name;
    @NotNull
    private final NumericalExpression left;
    @NotNull
    private final NumericalExpression right;

    public SubExpression(@NotNull String name, @NotNull NumericalExpression left, @NotNull NumericalExpression right) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.name = name;
        this.left = left;
        this.right = right;
    }

    @NotNull
    protected final String getName() {
        return this.name;
    }

    @NotNull
    public final NumericalExpression getLeft() {
        return this.left;
    }

    @NotNull
    public final NumericalExpression getRight() {
        return this.right;
    }

    @NotNull
    public abstract String getOperatorSymbol();

    @NotNull
    public String toString() {
        return this.toString(true);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return isTop ? this.left.toString(false) + this.getOperatorSymbol() + this.right.toString(false) : "(" + this.toString(true) + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        Object[] objectArray = new NumericalExpression[]{this.left, this.right};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.left.getProblems(), this.right.getProblems()};
        return this.combine(this.name, listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ArrayList registerValues = new ArrayList();
        registerValues.addAll(this.left.getRegisterValues(schemaDevice));
        registerValues.addAll(this.right.getRegisterValues(schemaDevice));
        return registerValues;
    }

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.super.getValueAsDouble(schemaDevice);
    }

    @Override
    @Nullable
    public Long getValueAsLong(@NotNull SchemaDevice schemaDevice) {
        return NumericalExpression.super.getValueAsLong(schemaDevice);
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        return NumericalExpression.super.getGuarantee();
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return NumericalExpression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return NumericalExpression.super.getRequiredRegisters();
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return NumericalExpression.super.getRequiredMutableRegisters();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return NumericalExpression.super.getRequiredFields();
    }

    @Override
    public boolean isImmutable() {
        return NumericalExpression.super.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        NumericalExpression.super.setImmutable(value);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return NumericalExpression.super.getReturnType();
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return NumericalExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return NumericalExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return NumericalExpression.super.combine(function, problems);
    }
}

