/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.numbers.Add;
import nl.basjes.modbus.schema.expression.numbers.Divide;
import nl.basjes.modbus.schema.expression.numbers.DoubleConstant;
import nl.basjes.modbus.schema.expression.numbers.IEEE754Float32;
import nl.basjes.modbus.schema.expression.numbers.IEEE754Float64;
import nl.basjes.modbus.schema.expression.numbers.IntegerSigned16;
import nl.basjes.modbus.schema.expression.numbers.IntegerSigned32;
import nl.basjes.modbus.schema.expression.numbers.IntegerSigned64;
import nl.basjes.modbus.schema.expression.numbers.IntegerUnsigned16;
import nl.basjes.modbus.schema.expression.numbers.IntegerUnsigned32;
import nl.basjes.modbus.schema.expression.numbers.IntegerUnsigned64;
import nl.basjes.modbus.schema.expression.numbers.LongConstant;
import nl.basjes.modbus.schema.expression.numbers.Multiply;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.numbers.NumericalField;
import nl.basjes.modbus.schema.expression.numbers.Power;
import nl.basjes.modbus.schema.expression.numbers.Subtract;
import nl.basjes.modbus.schema.expression.parser.ModbusAntlrErrorListener;
import nl.basjes.modbus.schema.expression.parser.ModbusParserErrorStrategy;
import nl.basjes.modbus.schema.expression.parser.generated.FieldExpressionsLexer;
import nl.basjes.modbus.schema.expression.parser.generated.FieldExpressionsParser;
import nl.basjes.modbus.schema.expression.parser.generated.FieldExpressionsParserBaseVisitor;
import nl.basjes.modbus.schema.expression.registers.RegistersConstantExpression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.expression.registers.RegistersModbusExpression;
import nl.basjes.modbus.schema.expression.registers.SwapBytes;
import nl.basjes.modbus.schema.expression.registers.SwapEndian;
import nl.basjes.modbus.schema.expression.strings.BitsetStringList;
import nl.basjes.modbus.schema.expression.strings.EnumString;
import nl.basjes.modbus.schema.expression.strings.Eui48String;
import nl.basjes.modbus.schema.expression.strings.HexString;
import nl.basjes.modbus.schema.expression.strings.IPv4AddrString;
import nl.basjes.modbus.schema.expression.strings.IPv6AddrString;
import nl.basjes.modbus.schema.expression.strings.StringConcat;
import nl.basjes.modbus.schema.expression.strings.StringConstant;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.expression.strings.StringField;
import nl.basjes.modbus.schema.expression.strings.StringFromNumber;
import nl.basjes.modbus.schema.expression.strings.UTF8String;
import nl.basjes.modbus.schema.shaded.org.antlr.v4.runtime.ANTLRErrorListener;
import nl.basjes.modbus.schema.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.modbus.schema.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.modbus.schema.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.modbus.schema.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 X2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001XB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020,H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010.H\u0002J\u0010\u00102\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020WH\u0016\u00a8\u0006Y"}, d2={"Lnl/basjes/modbus/schema/expression/parser/ExpressionParser;", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParserBaseVisitor;", "Lnl/basjes/modbus/schema/expression/Expression;", "<init>", "()V", "aggregateResult", "aggregate", "nextResult", "visitRegistersExpression", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "context", "Lnl/basjes/modbus/schema/shaded/org/antlr/v4/runtime/ParserRuleContext;", "visitNumericalExpression", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "visitStringExpression", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "visitLongConstant", "ctx", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LongConstantContext;", "visitDoubleConstant", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$DoubleConstantContext;", "visitRegisterValues", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegisterValuesContext;", "visitRegisters", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegistersContext;", "visitRegisterCount", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegisterCountContext;", "visitRegisterRange", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegisterRangeContext;", "visitRegisterSwapEndian", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegisterSwapEndianContext;", "visitRegisterSwapBytes", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$RegisterSwapBytesContext;", "visitStringUtf8", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringUtf8Context;", "visitStringHex", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringHexContext;", "visitStringConstant", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringConstantContext;", "visitStringField", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringFieldContext;", "visitStringNumber", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringNumberContext;", "visitStringConcat", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringConcatContext;", "notImplementedToStringList", "", "", "notImplementedContexts", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$NotImplementedContext;", "visitStringEui48", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringEui48Context;", "visitStringIPv4Addr", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringIPv4AddrContext;", "visitStringIPv6Addr", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringIPv6AddrContext;", "visitStringEnum", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringEnumContext;", "visitStringListBitSet", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$StringListBitSetContext;", "visitLoadInt16", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadInt16Context;", "visitLoadInt32", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadInt32Context;", "visitLoadInt64", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadInt64Context;", "visitLoadUInt16", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadUInt16Context;", "visitLoadUInt32", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadUInt32Context;", "visitLoadUInt64", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadUInt64Context;", "visitLoadIeee754_32", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadIeee754_32Context;", "visitLoadIeee754_64", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$LoadIeee754_64Context;", "visitNumberField", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$NumberFieldContext;", "visitExtraBraces", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$ExtraBracesContext;", "visitPower", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$PowerContext;", "visitImplicitMultiply", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$ImplicitMultiplyContext;", "visitMultiplyDivide", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$MultiplyDivideContext;", "visitAddSubtract", "Lnl/basjes/modbus/schema/expression/parser/generated/FieldExpressionsParser$AddSubtractContext;", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nExpressionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionParser.kt\nnl/basjes/modbus/schema/expression/parser/ExpressionParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1563#2:337\n1634#2,3:338\n1563#2:341\n1634#2,3:342\n1563#2:345\n1634#2,3:346\n1563#2:349\n1634#2,3:350\n*S KotlinDebug\n*F\n+ 1 ExpressionParser.kt\nnl/basjes/modbus/schema/expression/parser/ExpressionParser\n*L\n161#1:337\n161#1:338,3\n171#1:341\n171#1:342,3\n184#1:345\n184#1:346,3\n219#1:349\n219#1:350,3\n*E\n"})
public final class ExpressionParser
extends FieldExpressionsParserBaseVisitor<Expression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    protected Expression aggregateResult(@Nullable Expression aggregate, @Nullable Expression nextResult) {
        if (nextResult == null) {
            return aggregate;
        }
        return nextResult;
    }

    private final RegistersExpression visitRegistersExpression(ParserRuleContext context) {
        Object t = super.visit(context);
        Intrinsics.checkNotNull(t);
        Expression expression = (Expression)t;
        if (expression instanceof RegistersExpression) {
            return (RegistersExpression)expression;
        }
        throw new IllegalStateException("The provided Expression MUST be an instance of ByteArrayExpression but was a " + expression.getClass());
    }

    private final NumericalExpression visitNumericalExpression(ParserRuleContext context) {
        Object t = super.visit(context);
        Intrinsics.checkNotNull(t);
        Expression expression = (Expression)t;
        if (expression instanceof NumericalExpression) {
            return (NumericalExpression)expression;
        }
        throw new IllegalStateException("The provided Expression MUST be an instance of NumericalExpression but was a " + expression.getClass());
    }

    private final StringExpression visitStringExpression(ParserRuleContext context) {
        Object t = super.visit(context);
        Intrinsics.checkNotNull(t);
        Expression expression = (Expression)t;
        if (expression instanceof StringExpression) {
            return (StringExpression)expression;
        }
        throw new IllegalStateException("The provided Expression MUST be an instance of StringExpression but was a " + expression.getClass());
    }

    @Override
    @NotNull
    public Expression visitLongConstant(@NotNull FieldExpressionsParser.LongConstantContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.MINUS() == null) {
            String string = ctx.LONG().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new LongConstant(Long.parseLong(string));
        }
        long l = -1;
        String string = ctx.LONG().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new LongConstant(l * Long.parseLong(string));
    }

    @Override
    @NotNull
    public Expression visitDoubleConstant(@NotNull FieldExpressionsParser.DoubleConstantContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.MINUS() == null) {
            String string = ctx.DOUBLE().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new DoubleConstant(Double.parseDouble(string));
        }
        double d = -1;
        String string = ctx.DOUBLE().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new DoubleConstant(d * Double.parseDouble(string));
    }

    @Override
    @NotNull
    public Expression visitRegisterValues(@NotNull FieldExpressionsParser.RegisterValuesContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.constantHexString().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new RegistersConstantExpression(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Expression visitRegisters(@NotNull FieldExpressionsParser.RegistersContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<FieldExpressionsParser.SingleRegisterContext> list = ctx.singleRegister();
        Intrinsics.checkNotNullExpressionValue(list, (String)"singleRegister(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldExpressionsParser.SingleRegisterContext singleRegisterContext = (FieldExpressionsParser.SingleRegisterContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            collection.add(Address.Companion.of(string));
        }
        List list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new RegistersModbusExpression(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Expression visitRegisterCount(@NotNull FieldExpressionsParser.RegisterCountContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.startRegister.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Address startRegister = Address.Companion.of(string);
        String string2 = ctx.count.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        int totalRegisters = Integer.parseInt(string2);
        if (totalRegisters <= 0) {
            throw new ModbusSchemaParseException("Invalid register count specified: count=" + totalRegisters);
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)totalRegisters);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void count;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(startRegister.increment((int)count));
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new RegistersModbusExpression(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Expression visitRegisterRange(@NotNull FieldExpressionsParser.RegisterRangeContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.startRegister.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Address startRegister = Address.Companion.of(string);
        String string2 = ctx.lastRegister.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        Address lastRegister = Address.Companion.of(string2);
        int totalRegisters = lastRegister.getPhysicalAddress() - startRegister.getPhysicalAddress() + 1;
        if (totalRegisters <= 0) {
            throw new ModbusSchemaParseException("Invalid register range specified: start=" + startRegister + " ; last=" + lastRegister);
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)totalRegisters);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void count;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(startRegister.increment((int)count));
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new RegistersModbusExpression(list);
    }

    @Override
    @NotNull
    public Expression visitRegisterSwapEndian(@NotNull FieldExpressionsParser.RegisterSwapEndianContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new SwapEndian(this.visitRegistersExpression(registerlistContext));
    }

    @Override
    @NotNull
    public Expression visitRegisterSwapBytes(@NotNull FieldExpressionsParser.RegisterSwapBytesContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new SwapBytes(this.visitRegistersExpression(registerlistContext));
    }

    @Override
    @NotNull
    public Expression visitStringUtf8(@NotNull FieldExpressionsParser.StringUtf8Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new UTF8String(this.visitRegistersExpression(registerlistContext));
    }

    @Override
    @NotNull
    public Expression visitStringHex(@NotNull FieldExpressionsParser.StringHexContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new HexString(this.visitRegistersExpression(registerlistContext));
    }

    @Override
    @NotNull
    public Expression visitStringConstant(@NotNull FieldExpressionsParser.StringConstantContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.STRING().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new StringConstant(string);
    }

    @Override
    @NotNull
    public Expression visitStringField(@NotNull FieldExpressionsParser.StringFieldContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.FIELDNAME().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new StringField(string);
    }

    @Override
    @NotNull
    public Expression visitStringNumber(@NotNull FieldExpressionsParser.StringNumberContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.NumberContext numberContext = ctx.number();
        Intrinsics.checkNotNullExpressionValue((Object)numberContext, (String)"number(...)");
        return new StringFromNumber(this.visitNumericalExpression(numberContext));
    }

    @Override
    @NotNull
    public Expression visitStringConcat(@NotNull FieldExpressionsParser.StringConcatContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List expressions = new ArrayList();
        for (FieldExpressionsParser.StringFragmentsContext string : ctx.stringFragments()) {
            Intrinsics.checkNotNull((Object)string);
            expressions.add(this.visitStringExpression(string));
        }
        return new StringConcat(expressions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> notImplementedToStringList(List<? extends FieldExpressionsParser.NotImplementedContext> notImplementedContexts) {
        List notImplemented = CollectionsKt.emptyList();
        Collection collection = notImplementedContexts;
        if (!(collection == null || collection.isEmpty())) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = notImplementedContexts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FieldExpressionsParser.NotImplementedContext notImplementedContext = (FieldExpressionsParser.NotImplementedContext)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getText());
            }
            notImplemented = (List)destination$iv$iv;
        }
        return notImplemented;
    }

    @Override
    @NotNull
    public Expression visitStringEui48(@NotNull FieldExpressionsParser.StringEui48Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new Eui48String(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitStringIPv4Addr(@NotNull FieldExpressionsParser.StringIPv4AddrContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IPv4AddrString(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitStringIPv6Addr(@NotNull FieldExpressionsParser.StringIPv6AddrContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IPv6AddrString(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitStringEnum(@NotNull FieldExpressionsParser.StringEnumContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        RegistersExpression registers = this.visitRegistersExpression(registerlistContext);
        Map enumMappings = new TreeMap();
        for (FieldExpressionsParser.MappingContext enumMappingContext : ctx.mapping()) {
            Map map = enumMappings;
            String string = enumMappingContext.key.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Long l = Long.parseLong(string);
            String string2 = enumMappingContext.value.getText();
            map.put(l, string2);
        }
        return new EnumString(registers, this.notImplementedToStringList(ctx.notImplemented()), enumMappings);
    }

    @Override
    @NotNull
    public Expression visitStringListBitSet(@NotNull FieldExpressionsParser.StringListBitSetContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        RegistersExpression registers = this.visitRegistersExpression(registerlistContext);
        Map bitsetMappings = new TreeMap();
        for (FieldExpressionsParser.MappingContext bitsetMappingContext : ctx.mapping()) {
            Map map = bitsetMappings;
            String string = bitsetMappingContext.key.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Integer n = Integer.parseInt(string);
            String string2 = bitsetMappingContext.value.getText();
            map.put(n, string2);
        }
        return new BitsetStringList(registers, this.notImplementedToStringList(ctx.notImplemented()), bitsetMappings);
    }

    @Override
    @NotNull
    public Expression visitLoadInt16(@NotNull FieldExpressionsParser.LoadInt16Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerSigned16(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadInt32(@NotNull FieldExpressionsParser.LoadInt32Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerSigned32(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadInt64(@NotNull FieldExpressionsParser.LoadInt64Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerSigned64(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadUInt16(@NotNull FieldExpressionsParser.LoadUInt16Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerUnsigned16(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadUInt32(@NotNull FieldExpressionsParser.LoadUInt32Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerUnsigned32(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadUInt64(@NotNull FieldExpressionsParser.LoadUInt64Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IntegerUnsigned64(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadIeee754_32(@NotNull FieldExpressionsParser.LoadIeee754_32Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IEEE754Float32(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitLoadIeee754_64(@NotNull FieldExpressionsParser.LoadIeee754_64Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.RegisterlistContext registerlistContext = ctx.registers;
        Intrinsics.checkNotNullExpressionValue((Object)registerlistContext, (String)"registers");
        return new IEEE754Float64(this.visitRegistersExpression(registerlistContext), this.notImplementedToStringList(ctx.notImplemented()));
    }

    @Override
    @NotNull
    public Expression visitNumberField(@NotNull FieldExpressionsParser.NumberFieldContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new NumericalField(string);
    }

    @Override
    @NotNull
    public Expression visitExtraBraces(@NotNull FieldExpressionsParser.ExtraBracesContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object t = super.visit(ctx.number());
        Intrinsics.checkNotNull(t);
        return (Expression)t;
    }

    @Override
    @NotNull
    public Expression visitPower(@NotNull FieldExpressionsParser.PowerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.NumberContext numberContext = ctx.base;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext, (String)"base");
        NumericalExpression base = this.visitNumericalExpression(numberContext);
        FieldExpressionsParser.NumberContext numberContext2 = ctx.exponent;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext2, (String)"exponent");
        NumericalExpression exponent = this.visitNumericalExpression(numberContext2);
        return new Power(base, exponent);
    }

    @Override
    @NotNull
    public Expression visitImplicitMultiply(@NotNull FieldExpressionsParser.ImplicitMultiplyContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.NumberContext numberContext = ctx.left;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext, (String)"left");
        NumericalExpression left = this.visitNumericalExpression(numberContext);
        FieldExpressionsParser.NumberContext numberContext2 = ctx.middle;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext2, (String)"middle");
        NumericalExpression middle = this.visitNumericalExpression(numberContext2);
        return new Multiply(left, middle);
    }

    @Override
    @NotNull
    public Expression visitMultiplyDivide(@NotNull FieldExpressionsParser.MultiplyDivideContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.NumberContext numberContext = ctx.left;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext, (String)"left");
        NumericalExpression left = this.visitNumericalExpression(numberContext);
        FieldExpressionsParser.NumberContext numberContext2 = ctx.right;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext2, (String)"right");
        NumericalExpression right = this.visitNumericalExpression(numberContext2);
        if (ctx.DIVIDE() != null) {
            return new Divide(left, right);
        }
        return new Multiply(left, right);
    }

    @Override
    @NotNull
    public Expression visitAddSubtract(@NotNull FieldExpressionsParser.AddSubtractContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FieldExpressionsParser.NumberContext numberContext = ctx.left;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext, (String)"left");
        NumericalExpression left = this.visitNumericalExpression(numberContext);
        FieldExpressionsParser.NumberContext numberContext2 = ctx.right;
        Intrinsics.checkNotNullExpressionValue((Object)numberContext2, (String)"right");
        NumericalExpression right = this.visitNumericalExpression(numberContext2);
        if (ctx.ADD() != null) {
            return new Add(left, right);
        }
        return new Subtract(left, right);
    }

    @JvmStatic
    @NotNull
    public static final Expression parse(@NotNull String expression) {
        return Companion.parse(expression);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lnl/basjes/modbus/schema/expression/parser/ExpressionParser$Companion;", "", "<init>", "()V", "parse", "Lnl/basjes/modbus/schema/expression/Expression;", "expression", "", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Expression parse(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ANTLRErrorListener errorListener = new ModbusAntlrErrorListener(expression);
            CodePointCharStream input = CharStreams.fromString(expression);
            FieldExpressionsLexer lexer = new FieldExpressionsLexer(input);
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            FieldExpressionsParser parser = new FieldExpressionsParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(errorListener);
            parser.setErrorHandler(new ModbusParserErrorStrategy());
            FieldExpressionsParser.ExpressionContext expressionContext = parser.expression();
            Intrinsics.checkNotNullExpressionValue((Object)expressionContext, (String)"expression(...)");
            ParserRuleContext expressionContext2 = expressionContext;
            Object t = new ExpressionParser().visit(expressionContext2);
            Intrinsics.checkNotNull(t);
            return (Expression)t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

