/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.registers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lnl/basjes/modbus/schema/expression/registers/RegistersModbusExpression;", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "registers", "", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Ljava/util/List;)V", "requiredRegisters", "getRequiredRegisters", "()Ljava/util/List;", "returnedRegisters", "", "getReturnedRegisters", "()I", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "requiredMutableRegisters", "getRequiredMutableRegisters", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "isSortedList", "getByteArray", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "getAddressClass", "()Lnl/basjes/modbus/device/api/AddressClass;", "toString", "", "modbus-schema-device"})
public class RegistersModbusExpression
implements RegistersExpression {
    @NotNull
    private final List<Address> registers;
    private boolean isImmutable;

    public RegistersModbusExpression(@NotNull List<Address> registers) {
        Intrinsics.checkNotNullParameter(registers, (String)"registers");
        this.registers = registers;
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return this.registers;
    }

    @Override
    public int getReturnedRegisters() {
        return this.registers.size();
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return this.registers;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        if (this.registers.isEmpty()) {
            return CollectionsKt.listOf((Object)new Expression.Problem("No registers"));
        }
        TreeSet sortedSet = new TreeSet(this.registers);
        if (sortedSet.size() != this.registers.size()) {
            return CollectionsKt.listOf((Object)new Expression.Problem("Duplicate registers: " + this.registers));
        }
        Address expectedAddress = null;
        Iterator iterator = sortedSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Address address = (Address)iterator2.next();
            if (expectedAddress == null) {
                expectedAddress = address;
            }
            Address address2 = expectedAddress;
            Intrinsics.checkNotNull((Object)address2);
            if (!Intrinsics.areEqual((Object)address2, (Object)address)) {
                return CollectionsKt.listOf((Object)new Expression.Problem("Illegal Register range specified: " + this.registers));
            }
            expectedAddress = Address.increment$default((Address)expectedAddress, (int)0, (int)1, null);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isSortedList() {
        return this.getProblems().isEmpty() ? Intrinsics.areEqual(this.registers, new ArrayList(new TreeSet(this.registers))) : false;
    }

    @Override
    @Nullable
    public byte[] getByteArray(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        RegisterBlock registerBlock = schemaDevice.getRegisterBlock(this.getAddressClass());
        byte[] bytes = new byte[this.registers.size() * 2];
        int nextByteIndex = 0;
        for (Address register : this.registers) {
            Short s = registerBlock.getValue(register);
            if (s == null) {
                return null;
            }
            short value = s;
            byte msb = (byte)(0xFF & (value & 0xFFFFFF00) >> 8);
            byte lsb = (byte)(0xFF & (value & 0xFF));
            bytes[nextByteIndex++] = msb;
            bytes[nextByteIndex++] = lsb;
        }
        return bytes;
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ArrayList<RegisterValue> registerValues = new ArrayList<RegisterValue>();
        RegisterBlock registerBlock = schemaDevice.getRegisterBlock(this.getAddressClass());
        for (Address register : this.registers) {
            registerValues.add(registerBlock.get(register));
        }
        return registerValues;
    }

    private final AddressClass getAddressClass() {
        return this.registers.get(0).getAddressClass();
    }

    @NotNull
    public String toString() {
        if (this.isSortedList()) {
            if (this.registers.size() > 1) {
                return this.registers.get(0) + " # " + this.registers.size();
            }
            return this.registers.get(0).toString();
        }
        return CollectionsKt.joinToString$default((Iterable)this.registers, (CharSequence)", ", null, null, (int)0, null, RegistersModbusExpression::toString$lambda$0, (int)30, null);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return RegistersExpression.super.toString(isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return RegistersExpression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return RegistersExpression.super.getSubExpressions();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return RegistersExpression.super.getRequiredFields();
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return RegistersExpression.super.getReturnType();
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return RegistersExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return RegistersExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return RegistersExpression.super.combine(function, problems);
    }

    private static final CharSequence toString$lambda$0(Address it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }
}

