/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.NotImplemented;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.utils.ByteConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Lnl/basjes/modbus/schema/expression/strings/EnumString;", "Lnl/basjes/modbus/schema/expression/NotImplemented;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "registers", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "notImplemented", "", "", "mappings", "", "", "<init>", "(Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;Ljava/util/List;Ljava/util/Map;)V", "getMappings", "()Ljava/util/Map;", "toString", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "isImmutable", "", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getRegisterValues", "Lnl/basjes/modbus/device/api/RegisterValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getValue", "modbus-schema-device"})
public final class EnumString
extends NotImplemented
implements StringExpression {
    @NotNull
    private final RegistersExpression registers;
    @NotNull
    private final Map<Long, String> mappings;
    private boolean isImmutable;

    public EnumString(@NotNull RegistersExpression registers, @NotNull List<String> notImplemented, @NotNull Map<Long, String> mappings) {
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        Intrinsics.checkNotNullParameter(notImplemented, (String)"notImplemented");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        super(registers.getReturnedRegisters(), notImplemented);
        this.registers = registers;
        this.mappings = mappings;
    }

    @NotNull
    public final Map<Long, String> getMappings() {
        return this.mappings;
    }

    @Override
    @NotNull
    public String toString() {
        return "enum(" + this.registers + super.toString() + " ; " + CollectionsKt.joinToString$default((Iterable)this.mappings.entrySet(), (CharSequence)" ; ", null, null, (int)0, null, EnumString::toString$lambda$0, (int)30, null) + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.registers);
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable(boolean bl) {
        this.isImmutable = bl;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{this.checkFatal(this.registers.getReturnedRegisters() > 0, "No registers"), this.checkFatal(this.registers.getReturnedRegisters() <= 4, "Too many registers"), StringExpression.super.getProblems(), super.getProblems()};
        return this.combine("enum", listArray);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.registers.getRegisterValues(schemaDevice);
    }

    @Override
    @Nullable
    public String getValue(@NotNull SchemaDevice schemaDevice) throws ModbusException {
        Long l;
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        byte[] byArray = this.registers.getByteArray(schemaDevice);
        if (byArray == null) {
            return null;
        }
        byte[] bytes = byArray;
        if (this.isNotImplemented(bytes)) {
            return null;
        }
        switch (bytes.length) {
            case 2: {
                l = ByteConversions.INSTANCE.bytesToShort(bytes);
                break;
            }
            case 4: {
                l = ByteConversions.INSTANCE.bytesToInteger(bytes);
                break;
            }
            case 8: {
                l = ByteConversions.INSTANCE.bytesToLong(bytes);
                break;
            }
            default: {
                l = null;
            }
        }
        Long value = l;
        Object mappedValue = this.mappings.get(value);
        if (mappedValue == null) {
            mappedValue = "No mapping for value " + ByteConversions.INSTANCE.bytesToHexString(bytes);
        }
        return mappedValue;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.super.getReturnType();
    }

    private static final CharSequence toString$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "->'" + it.getValue() + "'";
    }
}

