/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lnl/basjes/modbus/schema/expression/strings/StringConcat;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "expressions", "", "<init>", "(Ljava/util/List;)V", "getExpressions", "()Ljava/util/List;", "toString", "", "subExpressions", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getValue", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbus-schema-device"})
public final class StringConcat
implements StringExpression {
    @NotNull
    private final List<StringExpression> expressions;

    public StringConcat(@NotNull List<? extends StringExpression> expressions) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        this.expressions = expressions;
    }

    @NotNull
    public final List<StringExpression> getExpressions() {
        return this.expressions;
    }

    @NotNull
    public String toString() {
        return "concat(" + CollectionsKt.joinToString$default((Iterable)this.expressions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return this.expressions;
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{StringExpression.super.getProblems()};
        return this.combine("concat", listArray);
    }

    @Override
    @NotNull
    public String getValue(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Object result = "";
        for (StringExpression expression : this.expressions) {
            String string = expression.getValue(schemaDevice);
            if (string == null) {
                string = "";
            }
            result = (String)result + string;
        }
        return result;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.super.getReturnType();
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return StringExpression.super.toString(isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return StringExpression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Address> getRequiredRegisters() {
        return StringExpression.super.getRequiredRegisters();
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableRegisters() {
        return StringExpression.super.getRequiredMutableRegisters();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return StringExpression.super.getRequiredFields();
    }

    @Override
    public boolean isImmutable() {
        return StringExpression.super.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        StringExpression.super.setImmutable(value);
    }

    @Override
    @NotNull
    public List<RegisterValue> getRegisterValues(@NotNull SchemaDevice schemaDevice) {
        return StringExpression.super.getRegisterValues(schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return StringExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return StringExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return StringExpression.super.combine(function, problems);
    }
}

