/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaMissingFieldException;
import nl.basjes.modbus.schema.exceptions.ModbusSchemaParseException;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.parser.ExpressionParser;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.expression.strings.StringListExpression;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import nl.basjes.modbus.schema.utils.ParameterValidationsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 `2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002`aB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010%\u001a\u00020\tJ\f\u0010K\u001a\b\u0012\u0004\u0012\u00020I04J\u0006\u0010L\u001a\u00020\tJ\f\u0010M\u001a\b\u0012\u0004\u0012\u00020I04J\u0006\u0010N\u001a\u00020\tJ\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P04J\u0006\u0010W\u001a\u00020XJ\u0006\u0010Y\u001a\u00020XJ\u0006\u0010Z\u001a\u00020\tJ\u0011\u0010]\u001a\u00020R2\u0006\u0010^\u001a\u00020\u0000H\u0096\u0002J\b\u0010_\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR&\u0010\r\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\"\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u0018\u001a\u0004\u0018\u00010&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0013\u0010-\u001a\u00020\t8F\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\"R\u0013\u0010\u0018\u001a\u0004\u0018\u00010.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0013R\u0019\u00103\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0013\u00107\u001a\u0004\u0018\u0001088F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0013\u0010;\u001a\u0004\u0018\u00010<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0013\u0010?\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0013\u0010B\u001a\u0004\u0018\u00010<8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010>R\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0005048F\u00a2\u0006\u0006\u001a\u0004\bE\u00106R\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u0000048F\u00a2\u0006\u0006\u001a\u0004\bG\u00106R\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020I048F\u00a2\u0006\u0006\u001a\u0004\bJ\u00106R\u001a\u0010Q\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u0017\u0010[\u001a\b\u0012\u0004\u0012\u00020\u0005048F\u00a2\u0006\u0006\u001a\u0004\b\\\u00106\u00a8\u0006b"}, d2={"Lnl/basjes/modbus/schema/Field;", "", "block", "Lnl/basjes/modbus/schema/Block;", "id", "", "description", "shortDescription", "immutable", "", "system", "expression", "unit", "fetchGroup", "<init>", "(Lnl/basjes/modbus/schema/Block;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBlock", "()Lnl/basjes/modbus/schema/Block;", "getDescription", "()Ljava/lang/String;", "getShortDescription", "getExpression", "getUnit", "getId", "value", "Lnl/basjes/modbus/schema/ReturnType;", "returnType", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "getFetchGroup", "setFetchGroup", "(Ljava/lang/String;)V", "fetchGroupIsDefault", "getFetchGroupIsDefault", "()Z", "initialized", "getInitialized", "initialize", "Lnl/basjes/modbus/schema/expression/Expression;", "parsedExpression", "getParsedExpression", "()Lnl/basjes/modbus/schema/expression/Expression;", "addressClass", "Lnl/basjes/modbus/device/api/AddressClass;", "isSystem", "isImmutable", "", "getValue", "()Ljava/lang/Object;", "stringValue", "getStringValue", "stringListValue", "", "getStringListValue", "()Ljava/util/List;", "doubleValue", "", "getDoubleValue", "()Ljava/lang/Double;", "longValue", "", "getLongValue", "()Ljava/lang/Long;", "booleanValue", "getBooleanValue", "()Ljava/lang/Boolean;", "valueEpochMs", "getValueEpochMs", "requiredFieldNames", "getRequiredFieldNames", "requiredFields", "getRequiredFields", "requiredAddresses", "Lnl/basjes/modbus/device/api/Address;", "getRequiredAddresses", "usedReadErrorAddresses", "isUsingReadErrorRegisters", "usedHardReadErrorAddresses", "isUsingHardReadErrorRegisters", "update", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "neededCount", "", "getNeededCount", "()I", "setNeededCount", "(I)V", "need", "", "unNeed", "isNeeded", "testCompareValue", "getTestCompareValue", "compareTo", "other", "toString", "Companion", "FieldBuilder", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n1#2:560\n1#2:571\n1#2:584\n1617#3,9:561\n1869#3:570\n1870#3:572\n1626#3:573\n1617#3,9:574\n1869#3:583\n1870#3:585\n1626#3:586\n774#3:587\n865#3,2:588\n1563#3:590\n1634#3,3:591\n774#3:594\n865#3,2:595\n1563#3:597\n1634#3,3:598\n1869#3,2:601\n1869#3,2:603\n1869#3,2:605\n*S KotlinDebug\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field\n*L\n311#1:571\n325#1:584\n311#1:561,9\n311#1:570\n311#1:572\n311#1:573\n325#1:574,9\n325#1:583\n325#1:585\n325#1:586\n334#1:587\n334#1:588,2\n334#1:590\n334#1:591,3\n342#1:594\n342#1:595,2\n342#1:597\n342#1:598,3\n363#1:601,2\n370#1:603,2\n378#1:605,2\n*E\n"})
public final class Field
implements Comparable<Field> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block block;
    @NotNull
    private final String description;
    @NotNull
    private final String shortDescription;
    @NotNull
    private final String expression;
    @NotNull
    private final String unit;
    @NotNull
    private final String id;
    @NotNull
    private ReturnType returnType;
    @NotNull
    private String fetchGroup;
    private boolean fetchGroupIsDefault;
    private boolean initialized;
    @Nullable
    private Expression parsedExpression;
    @Nullable
    private AddressClass addressClass;
    private final boolean isSystem;
    private final boolean isImmutable;
    private int neededCount;

    public Field(@NotNull Block block, @NotNull String id, @NotNull String description, @NotNull String shortDescription, boolean immutable, boolean system, @NotNull String expression, @NotNull String unit, @NotNull String fetchGroup) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)shortDescription, (String)"shortDescription");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)fetchGroup, (String)"fetchGroup");
        this.block = block;
        this.description = description;
        this.shortDescription = shortDescription;
        this.expression = expression;
        this.unit = unit;
        this.id = ((Object)StringsKt.trim((CharSequence)id)).toString();
        this.returnType = ReturnType.UNKNOWN;
        this.fetchGroup = fetchGroup;
        this.fetchGroupIsDefault = StringsKt.isBlank((CharSequence)fetchGroup) || Intrinsics.areEqual((Object)fetchGroup, (Object)("<<" + this.block.getId() + " | " + id + ">>"));
        this.isSystem = system;
        this.isImmutable = immutable;
        ParameterValidationsKt.requireValidIdentifier(id, "Field id");
        Field[] fieldArray = new Field[]{this};
        this.block.addField(fieldArray);
    }

    public /* synthetic */ Field(Block block, String string, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = string2;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            string5 = "";
        }
        if ((n & 0x100) != 0) {
            string6 = "";
        }
        this(block, string, string2, string3, bl, bl2, string4, string5, string6);
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getShortDescription() {
        return this.shortDescription;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final String getUnit() {
        return this.unit;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ReturnType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final String getFetchGroup() {
        Object object;
        CharSequence charSequence = this.fetchGroup;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            object = "<<" + this.block.getId() + " | " + this.id + ">>";
        } else {
            object = charSequence;
        }
        return (String)object;
    }

    public final void setFetchGroup(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.fetchGroup = value;
        this.fetchGroupIsDefault = StringsKt.isBlank((CharSequence)this.fetchGroup);
    }

    public final boolean getFetchGroupIsDefault() {
        return this.fetchGroupIsDefault;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final boolean initialize() {
        if (!this.initialized) {
            Expression theExpression;
            if (this.parsedExpression == null && !StringsKt.isBlank((CharSequence)this.expression)) {
                try {
                    this.parsedExpression = ExpressionParser.Companion.parse(this.expression);
                }
                catch (ModbusSchemaParseException e) {
                    throw new ModbusSchemaParseException("Field \"" + this.id + "\": Unable to parse the expression >>" + this.expression + "<< --> " + e.getMessage(), e);
                }
                catch (NullPointerException npe) {
                    throw new ModbusSchemaParseException("Field \"" + this.id + "\": Unable to parse the expression >>" + this.expression + "<< --> " + npe.getMessage(), npe);
                }
            }
            if ((theExpression = this.parsedExpression) != null) {
                boolean bl = this.initialized = theExpression.initialize(this) && theExpression.getProblems().isEmpty();
                if (this.initialized) {
                    ReturnType actualReturnType;
                    if (this.getRequiredAddresses().size() > 125) {
                        throw new ModbusSchemaParseException("In block " + this.block.getId() + " the field " + this.id + " requires a block of " + this.getRequiredAddresses().size() + " registers which cannot be retrieved over Modbus.");
                    }
                    boolean allHaveBeenInitialized = true;
                    for (int retry = 0; retry < 6; ++retry) {
                        allHaveBeenInitialized = true;
                        for (String requiredFieldName : theExpression.getRequiredFields()) {
                            Field requiredField;
                            if (this.block.getField(requiredFieldName) == null) {
                                throw new ModbusSchemaMissingFieldException("In block " + this.block.getId() + " the field " + this.id + " needs the field " + requiredFieldName + " which is missing.");
                            }
                            if (requiredField.initialize()) continue;
                            allHaveBeenInitialized = false;
                        }
                        if (allHaveBeenInitialized) break;
                    }
                    if (!allHaveBeenInitialized) {
                        System.out.println((Object)"ERROR");
                    }
                    if (!((actualReturnType = theExpression.getReturnType()) != ReturnType.UNKNOWN)) {
                        boolean $i$a$-require-Field$initialize$32 = false;
                        String $i$a$-require-Field$initialize$32 = "The expression dictated an UNKNOWN return type ?!?!?";
                        throw new IllegalArgumentException($i$a$-require-Field$initialize$32.toString());
                    }
                    if (this.returnType == ReturnType.UNKNOWN) {
                        this.returnType = actualReturnType;
                    } else if (!(this.returnType == actualReturnType)) {
                        boolean bl2 = false;
                        String string = "Field " + this.id + " was tagged it should return " + this.returnType + " but the provided expression returns a " + actualReturnType;
                        throw new IllegalArgumentException(string.toString());
                    }
                    List<Address> requiredRegisters = theExpression.getRequiredAddresses();
                    if (requiredRegisters.isEmpty()) {
                        this.addressClass = null;
                    } else {
                        this.addressClass = requiredRegisters.get(0).getAddressClass();
                        for (Address requiredRegister : requiredRegisters) {
                            if (this.addressClass == requiredRegister.getAddressClass()) continue;
                            throw new ModbusSchemaParseException("For field " + this.block.getId() + "::" + this.id + " the expression " + theExpression + " requires values from multiple AddressClasses (which is illegal)");
                        }
                    }
                    if (this.isImmutable()) {
                        theExpression.setImmutable(true);
                    }
                }
            }
        }
        return this.initialized;
    }

    @Nullable
    public final Expression getParsedExpression() {
        return this.parsedExpression;
    }

    public final boolean isSystem() {
        return this.isSystem;
    }

    public final boolean isImmutable() {
        block6: {
            block5: {
                if (this.isImmutable) {
                    return true;
                }
                if (this.parsedExpression == null) break block5;
                Expression expression = this.parsedExpression;
                Intrinsics.checkNotNull((Object)expression);
                if (expression.isImmutable()) break block6;
            }
            return false;
        }
        for (Field requiredField : this.getRequiredFields()) {
            if (requiredField.isImmutable()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final Object getValue() {
        List<String> list;
        switch (WhenMappings.$EnumSwitchMapping$0[this.returnType.ordinal()]) {
            case 1: {
                list = null;
                break;
            }
            case 2: {
                list = this.getBooleanValue();
                break;
            }
            case 3: {
                list = this.getLongValue();
                break;
            }
            case 4: {
                list = this.getDoubleValue();
                break;
            }
            case 5: {
                list = this.getStringValue();
                break;
            }
            case 6: {
                list = this.getStringListValue();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Nullable
    public final String getStringValue() {
        if (this.parsedExpression instanceof StringExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringExpression");
            return ((StringExpression)expression).getValue(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final List<String> getStringListValue() {
        if (this.parsedExpression instanceof StringListExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.strings.StringListExpression");
            return ((StringListExpression)expression).getValueAsStringList(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final Double getDoubleValue() {
        if (this.parsedExpression instanceof NumericalExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            return ((NumericalExpression)expression).getValueAsDouble(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final Long getLongValue() {
        if (this.parsedExpression instanceof NumericalExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.numbers.NumericalExpression");
            return ((NumericalExpression)expression).getValueAsLong(this.block.getSchemaDevice());
        }
        return null;
    }

    @Nullable
    public final Boolean getBooleanValue() {
        if (this.parsedExpression instanceof BooleanExpression) {
            Expression expression = this.parsedExpression;
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type nl.basjes.modbus.schema.expression.booleans.BooleanExpression");
            return ((BooleanExpression)expression).getBoolean(this.block.getSchemaDevice());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long getValueEpochMs() {
        void $this$mapNotNullTo$iv$iv;
        Expression parsedExpression = this.parsedExpression;
        if (parsedExpression == null) {
            return null;
        }
        AddressClass addressClass = this.addressClass;
        if (addressClass == null) {
            return null;
        }
        List registerValues = this.block.getSchemaDevice().getModbusBlock(addressClass).get(parsedExpression.getRequiredMutableAddresses());
        Iterable $this$mapNotNull$iv = registerValues;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModbusValue it = (ModbusValue)element$iv$iv;
            boolean bl2 = false;
            if (it.getTimestamp() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List timestamps = (List)destination$iv$iv;
        if (timestamps.isEmpty()) {
            return null;
        }
        return (Long)CollectionsKt.minOrThrow((Iterable)timestamps);
    }

    @NotNull
    public final List<String> getRequiredFieldNames() {
        Object object = this.parsedExpression;
        if (object == null || (object = object.getRequiredFields()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<Field> getRequiredFields() {
        List list;
        List<String> list2;
        Expression expression = this.parsedExpression;
        if (expression != null && (list2 = expression.getRequiredFields()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Field it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.block.getField(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            if (list3 != null) {
                list = list3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    @NotNull
    public final List<Address> getRequiredAddresses() {
        Object object = this.parsedExpression;
        if (object == null || (object = object.getRequiredAddresses()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Address> usedReadErrorAddresses() {
        void $this$mapTo$iv$iv;
        ModbusValue it;
        Iterable $this$filterTo$iv$iv;
        AddressClass addressClass = this.addressClass;
        if (addressClass == null) {
            return CollectionsKt.emptyList();
        }
        AddressClass addressClass2 = addressClass;
        List registerValues = this.block.getSchemaDevice().getModbusBlock(addressClass2).get(this.getRequiredAddresses());
        Iterable $this$filter$iv = registerValues;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModbusValue)element$iv$iv;
            boolean bl = false;
            if (!it.isReadError()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModbusValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAddress());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public final boolean isUsingReadErrorRegisters() {
        return !this.usedReadErrorAddresses().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Address> usedHardReadErrorAddresses() {
        void $this$mapTo$iv$iv;
        ModbusValue it;
        Iterable $this$filterTo$iv$iv;
        AddressClass addressClass = this.addressClass;
        if (addressClass == null) {
            return CollectionsKt.emptyList();
        }
        AddressClass addressClass2 = addressClass;
        List registerValues = this.block.getSchemaDevice().getModbusBlock(addressClass2).get(this.getRequiredAddresses());
        Iterable $this$filter$iv = registerValues;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModbusValue)element$iv$iv;
            boolean bl = false;
            if (!it.getHardReadError()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModbusValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAddress());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public final boolean isUsingHardReadErrorRegisters() {
        return !this.usedHardReadErrorAddresses().isEmpty();
    }

    @NotNull
    public final List<ModbusQuery> update() {
        return this.block.getSchemaDevice().update(this);
    }

    public final int getNeededCount() {
        return this.neededCount;
    }

    public final void setNeededCount(int n) {
        this.neededCount = n;
    }

    public final void need() {
        int n = this.neededCount;
        this.neededCount = n + 1;
        Iterable $this$forEach$iv = this.getRequiredFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.need();
        }
        AddressClass addressClass = this.addressClass;
        if (addressClass == null) {
            return;
        }
        AddressClass addressClass2 = addressClass;
        List registerValues = this.block.getSchemaDevice().getModbusBlock(addressClass2).get(this.getRequiredAddresses());
        Iterable $this$forEach$iv2 = registerValues;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ModbusValue it = (ModbusValue)element$iv;
            boolean bl = false;
            it.clearSoftReadError();
        }
    }

    public final void unNeed() {
        int n = this.neededCount;
        this.neededCount = n + -1;
        Iterable $this$forEach$iv = this.getRequiredFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            it.unNeed();
        }
    }

    public final boolean isNeeded() {
        return this.neededCount > 0;
    }

    @NotNull
    public final List<String> getTestCompareValue() {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[this.returnType.ordinal()]) {
            case 1: {
                String string = "Unknown returnType (Field " + this.id + ") means we do not know yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                Boolean value;
                Boolean bl = value = this.getBooleanValue();
                if (bl != null) {
                    list = CollectionsKt.listOf((Object)(bl != false ? "true" : "false"));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                if (this.getLongValue() != null) {
                    list = CollectionsKt.listOf((Object)String.valueOf(this.getLongValue()));
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            case 4: {
                if (this.getDoubleValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                Double d = this.getDoubleValue();
                Intrinsics.checkNotNull((Object)d);
                if (Double.isNaN(d)) {
                    list = CollectionsKt.listOf((Object)"NaN");
                    break;
                }
                if (Intrinsics.areEqual((Double)this.getDoubleValue(), (double)Double.POSITIVE_INFINITY)) {
                    list = CollectionsKt.listOf((Object)"+Infinite");
                    break;
                }
                if (Intrinsics.areEqual((Double)this.getDoubleValue(), (double)Double.NEGATIVE_INFINITY)) {
                    list = CollectionsKt.listOf((Object)"-Infinite");
                    break;
                }
                String string = "%.3f";
                Object[] objectArray = new Object[]{this.getDoubleValue()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                list = CollectionsKt.listOf((Object)string2);
                break;
            }
            case 5: {
                if (this.getStringValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                String string = this.getStringValue();
                Intrinsics.checkNotNull((Object)string);
                list = CollectionsKt.listOf((Object)string);
                break;
            }
            case 6: {
                if (this.getStringListValue() == null) {
                    list = CollectionsKt.emptyList();
                    break;
                }
                List list2 = this.getStringListValue();
                list = list2;
                Intrinsics.checkNotNull((Object)list2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Override
    public int compareTo(@NotNull Field other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        List<Address> thisRequiredRegisters = this.getRequiredAddresses();
        List<Address> otherRequiredRegisters = other.getRequiredAddresses();
        if (thisRequiredRegisters.isEmpty() && otherRequiredRegisters.isEmpty()) {
            return 0;
        }
        if (thisRequiredRegisters.isEmpty()) {
            return 1;
        }
        if (otherRequiredRegisters.isEmpty()) {
            return -1;
        }
        Address thisAddress = this.getRequiredAddresses().get(0);
        Address otherAddress = other.getRequiredAddresses().get(0);
        return thisAddress.compareTo(otherAddress);
    }

    @NotNull
    public String toString() {
        return "Field(id='" + this.id + "', isSystem=" + this.isSystem + ", isImmutable=" + this.isImmutable() + ", unit=" + this.unit + ", fetchGroup='" + this.getFetchGroup() + "', returnType=" + this.returnType + ", initialized=" + this.initialized + ", expression='" + this.expression + "', parsedExpression=" + this.parsedExpression + ", addressClass=" + this.addressClass + ", neededCount=" + this.neededCount + ")";
    }

    @JvmStatic
    @NotNull
    public static final FieldBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/Field$Companion;", "", "<init>", "()V", "builder", "Lnl/basjes/modbus/schema/Field$FieldBuilder;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FieldBuilder builder() {
            return new FieldBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020 R+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnl/basjes/modbus/schema/Field$FieldBuilder;", "", "<init>", "()V", "block", "Lnl/basjes/modbus/schema/Block;", "<set-?>", "getBlock", "()Lnl/basjes/modbus/schema/Block;", "setBlock", "(Lnl/basjes/modbus/schema/Block;)V", "block$delegate", "Lkotlin/properties/ReadWriteProperty;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "id$delegate", "description", "shortDescription", "immutable", "", "system", "expression", "getExpression", "setExpression", "expression$delegate", "unit", "fetchGroup", "build", "Lnl/basjes/modbus/schema/Field;", "modbus-schema-device"})
    @SourceDebugExtension(value={"SMAP\nField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Field.kt\nnl/basjes/modbus/schema/Field$FieldBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,559:1\n1#2:560\n*E\n"})
    public static class FieldBuilder {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty block$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private final ReadWriteProperty id$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private String description = "";
        @NotNull
        private String shortDescription = "";
        private boolean immutable;
        private boolean system;
        @NotNull
        private final ReadWriteProperty expression$delegate = Delegates.INSTANCE.notNull();
        @NotNull
        private String unit = "";
        @Nullable
        private String fetchGroup;

        @NotNull
        public final FieldBuilder block(@NotNull Block block) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            FieldBuilder $this$block_u24lambda_u240 = fieldBuilder = this;
            boolean bl = false;
            $this$block_u24lambda_u240.setBlock(block);
            return fieldBuilder;
        }

        private final Block getBlock() {
            return (Block)this.block$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setBlock(Block block) {
            this.block$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)block);
        }

        @NotNull
        public final FieldBuilder id(@NotNull String id) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            FieldBuilder $this$id_u24lambda_u241 = fieldBuilder = this;
            boolean bl = false;
            $this$id_u24lambda_u241.setId(id);
            return fieldBuilder;
        }

        private final String getId() {
            return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        private final void setId(String string) {
            this.id$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @NotNull
        public final FieldBuilder description(@NotNull String description) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            FieldBuilder $this$description_u24lambda_u242 = fieldBuilder = this;
            boolean bl = false;
            $this$description_u24lambda_u242.description = description;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder shortDescription(@NotNull String shortDescription) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)shortDescription, (String)"shortDescription");
            FieldBuilder $this$shortDescription_u24lambda_u243 = fieldBuilder = this;
            boolean bl = false;
            $this$shortDescription_u24lambda_u243.shortDescription = shortDescription;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder immutable(boolean immutable) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$immutable_u24lambda_u244 = fieldBuilder = this;
            boolean bl = false;
            $this$immutable_u24lambda_u244.immutable = immutable;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder system(boolean system) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$system_u24lambda_u245 = fieldBuilder = this;
            boolean bl = false;
            $this$system_u24lambda_u245.system = system;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder expression(@NotNull String expression) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            FieldBuilder $this$expression_u24lambda_u246 = fieldBuilder = this;
            boolean bl = false;
            $this$expression_u24lambda_u246.setExpression(expression);
            return fieldBuilder;
        }

        private final String getExpression() {
            return (String)this.expression$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        private final void setExpression(String string) {
            this.expression$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
        }

        @NotNull
        public final FieldBuilder unit(@Nullable String unit) {
            FieldBuilder fieldBuilder;
            FieldBuilder $this$unit_u24lambda_u247 = fieldBuilder = this;
            boolean bl = false;
            String string = unit;
            if (string == null) {
                string = "";
            }
            $this$unit_u24lambda_u247.unit = string;
            return fieldBuilder;
        }

        @NotNull
        public final FieldBuilder fetchGroup(@NotNull String fetchGroup) {
            FieldBuilder fieldBuilder;
            Intrinsics.checkNotNullParameter((Object)fetchGroup, (String)"fetchGroup");
            FieldBuilder $this$fetchGroup_u24lambda_u248 = fieldBuilder = this;
            boolean bl = false;
            $this$fetchGroup_u24lambda_u248.fetchGroup = fetchGroup;
            return fieldBuilder;
        }

        @NotNull
        public final Field build() {
            String fetchGroup = this.fetchGroup;
            CharSequence charSequence = fetchGroup;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? new Field(this.getBlock(), this.getId(), this.description, this.shortDescription, this.immutable, this.system, this.getExpression(), this.unit, null, 256, null) : new Field(this.getBlock(), this.getId(), this.description, this.shortDescription, this.immutable, this.system, this.getExpression(), this.unit, fetchGroup);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "block", "getBlock()Lnl/basjes/modbus/schema/Block;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "id", "getId()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FieldBuilder.class, "expression", "getExpression()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnType.values().length];
            try {
                nArray[ReturnType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReturnType.STRINGLIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

