/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.booleans;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a0\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lnl/basjes/modbus/schema/expression/booleans/BooleanBit;", "Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;", "addresses", "<init>", "(Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;)V", "toString", "", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "value", "", "isImmutable", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getModbusValues", "Lnl/basjes/modbus/device/api/ModbusValue;", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getBoolean", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Boolean;", "modbus-schema-device"})
public final class BooleanBit
implements BooleanExpression {
    @NotNull
    private final BooleanExpression addresses;

    public BooleanBit(@NotNull BooleanExpression addresses) {
        Intrinsics.checkNotNullParameter((Object)addresses, (String)"addresses");
        this.addresses = addresses;
    }

    @NotNull
    public String toString() {
        return "boolean(" + this.addresses + ")";
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.addresses);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.BOOLEAN;
    }

    @Override
    public boolean isImmutable() {
        return this.addresses.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.addresses.setImmutable(value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{BooleanExpression.super.getProblems()};
        return this.combine("boolean", listArray);
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.addresses.getModbusValues(schemaDevice);
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.addresses.getBoolean(schemaDevice);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return BooleanExpression.super.toString(isTop);
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        return BooleanExpression.super.initialize(containingField);
    }

    @Override
    @NotNull
    public List<Address> getRequiredAddresses() {
        return BooleanExpression.super.getRequiredAddresses();
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableAddresses() {
        return BooleanExpression.super.getRequiredMutableAddresses();
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return BooleanExpression.super.getRequiredFields();
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return BooleanExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return BooleanExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return BooleanExpression.super.combine(function, problems);
    }
}

