/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.modbus;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import nl.basjes.modbus.schema.expression.modbus.ModbusExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lnl/basjes/modbus/schema/expression/modbus/DiscreteModbusExpression;", "Lnl/basjes/modbus/schema/expression/booleans/BooleanExpression;", "Lnl/basjes/modbus/schema/expression/modbus/ModbusExpression;", "address", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Lnl/basjes/modbus/device/api/Address;)V", "getAddress", "()Lnl/basjes/modbus/device/api/Address;", "getBoolean", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Boolean;", "getModbusValues", "", "Lnl/basjes/modbus/device/api/ModbusValue;", "modbus-schema-device"})
public final class DiscreteModbusExpression
extends ModbusExpression
implements BooleanExpression {
    @NotNull
    private final Address address;

    public DiscreteModbusExpression(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        super(CollectionsKt.listOf((Object)address), null);
        this.address = address;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ModbusBlock<?, ?, ?> discreteBlock = schemaDevice.getModbusBlock(this.getAddressClass());
        if (!(discreteBlock instanceof DiscreteBlock)) {
            boolean bl = false;
            String string = "This should occur: doing getBoolean() on address " + this.getAddresses() + " (not discrete).";
            throw new IllegalArgumentException(string.toString());
        }
        return (Boolean)((DiscreteValue)((DiscreteBlock)discreteBlock).get(this.address)).getValue();
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ArrayList<ModbusValue> discreteValues = new ArrayList<ModbusValue>();
        ModbusBlock<?, ?, ?> discreteBlock = schemaDevice.getModbusBlock(this.getAddressClass());
        if (!(discreteBlock instanceof DiscreteBlock)) {
            boolean bl = false;
            String string = "This should occur: doing getModbusValues() on address " + this.getAddresses() + " (not discrete).";
            throw new IllegalArgumentException(string.toString());
        }
        discreteValues.add(((DiscreteBlock)discreteBlock).get(this.address));
        return discreteValues;
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return BooleanExpression.super.getReturnType();
    }
}

