/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.modbus;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.modbus.ModbusExpression;
import nl.basjes.modbus.schema.expression.registers.RegistersExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnl/basjes/modbus/schema/expression/modbus/RegistersModbusExpression;", "Lnl/basjes/modbus/schema/expression/registers/RegistersExpression;", "Lnl/basjes/modbus/schema/expression/modbus/ModbusExpression;", "addresses", "", "Lnl/basjes/modbus/device/api/Address;", "<init>", "(Ljava/util/List;)V", "getByteArray", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusValues", "Lnl/basjes/modbus/device/api/ModbusValue;", "returnedAddresses", "", "getReturnedAddresses", "()I", "modbus-schema-device"})
public final class RegistersModbusExpression
extends ModbusExpression
implements RegistersExpression {
    public RegistersModbusExpression(@NotNull List<Address> addresses) {
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        super(addresses, null);
    }

    @Override
    @Nullable
    public byte[] getByteArray(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ModbusBlock<?, ?, ?> registerBlock = schemaDevice.getModbusBlock(this.getAddressClass());
        if (!(registerBlock instanceof RegisterBlock)) {
            boolean $i$a$-require-RegistersModbusExpression$getByteArray$22 = false;
            String $i$a$-require-RegistersModbusExpression$getByteArray$22 = "This should occur: doing getByteArray() on address " + this.getAddresses() + " (not registers).";
            throw new IllegalArgumentException($i$a$-require-RegistersModbusExpression$getByteArray$22.toString());
        }
        byte[] bytes = new byte[this.getAddresses().size() * 2];
        int nextByteIndex = 0;
        for (Address address : this.getAddresses()) {
            Short s = (Short)((RegisterBlock)registerBlock).getValue(address);
            if (s == null) {
                return null;
            }
            short value = s;
            byte msb = (byte)(0xFF & (value & 0xFFFFFF00) >> 8);
            byte lsb = (byte)(0xFF & (value & 0xFF));
            bytes[nextByteIndex++] = msb;
            bytes[nextByteIndex++] = lsb;
        }
        return bytes;
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        ArrayList<ModbusValue> registerValues = new ArrayList<ModbusValue>();
        ModbusBlock<?, ?, ?> registerBlock = schemaDevice.getModbusBlock(this.getAddressClass());
        if (!(registerBlock instanceof RegisterBlock)) {
            boolean $i$a$-require-RegistersModbusExpression$getModbusValues$22 = false;
            String $i$a$-require-RegistersModbusExpression$getModbusValues$22 = "This should occur: doing getRegisterValues() on address " + this.getAddresses() + " (not registers).";
            throw new IllegalArgumentException($i$a$-require-RegistersModbusExpression$getModbusValues$22.toString());
        }
        for (Address register : this.getAddresses()) {
            registerValues.add(((RegisterBlock)registerBlock).get(register));
        }
        return registerValues;
    }

    @Override
    public int getReturnedAddresses() {
        return this.getAddresses().size();
    }
}

