/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.numbers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.numbers.NumericalOperationsKt;
import nl.basjes.modbus.schema.expression.numbers.SubExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lnl/basjes/modbus/schema/expression/numbers/Divide;", "Lnl/basjes/modbus/schema/expression/numbers/SubExpression;", "left", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "right", "<init>", "(Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;)V", "dividend", "getDividend", "()Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression;", "divisor", "getDivisor", "operatorSymbol", "", "getOperatorSymbol", "()Ljava/lang/String;", "getValueAsDouble", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "(Lnl/basjes/modbus/schema/SchemaDevice;)Ljava/lang/Double;", "getGuarantee", "Lnl/basjes/modbus/schema/expression/numbers/NumericalExpression$ValueGuarantee;", "returnType", "Lnl/basjes/modbus/schema/ReturnType;", "getReturnType", "()Lnl/basjes/modbus/schema/ReturnType;", "modbus-schema-device"})
public final class Divide
extends SubExpression {
    public Divide(@NotNull NumericalExpression left, @NotNull NumericalExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        super("Divide", left, right);
    }

    @NotNull
    public final NumericalExpression getDividend() {
        return this.getLeft();
    }

    @NotNull
    public final NumericalExpression getDivisor() {
        return this.getRight();
    }

    @Override
    @NotNull
    public String getOperatorSymbol() {
        return "/";
    }

    @Override
    @Nullable
    public Double getValueAsDouble(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Double d = NumericalOperationsKt.access$getValidatedDouble(schemaDevice, this.getDividend());
        if (d == null) {
            return null;
        }
        double dividend = d;
        Double d2 = NumericalOperationsKt.access$getValidatedDouble(schemaDevice, this.getDivisor());
        if (d2 == null) {
            return null;
        }
        double divisor = d2;
        return dividend / divisor;
    }

    @Override
    @NotNull
    public NumericalExpression.ValueGuarantee getGuarantee() {
        NumericalExpression.ValueGuarantee leftGuarantee = this.getLeft().getGuarantee();
        NumericalExpression.ValueGuarantee rightGuarantee = this.getRight().getGuarantee();
        return leftGuarantee == NumericalExpression.ValueGuarantee.POSITIVE && rightGuarantee == NumericalExpression.ValueGuarantee.POSITIVE ? NumericalExpression.ValueGuarantee.POSITIVE : (leftGuarantee == NumericalExpression.ValueGuarantee.POSITIVE && rightGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE ? NumericalExpression.ValueGuarantee.NEGATIVE : (leftGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE && rightGuarantee == NumericalExpression.ValueGuarantee.POSITIVE ? NumericalExpression.ValueGuarantee.NEGATIVE : (leftGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE && rightGuarantee == NumericalExpression.ValueGuarantee.NEGATIVE ? NumericalExpression.ValueGuarantee.POSITIVE : NumericalExpression.ValueGuarantee.NONE)));
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return ReturnType.DOUBLE;
    }
}

