/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.expression.strings;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.ReturnType;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.expression.Expression;
import nl.basjes.modbus.schema.expression.booleans.BooleanExpression;
import nl.basjes.modbus.schema.expression.generic.MissingField;
import nl.basjes.modbus.schema.expression.numbers.NumericalExpression;
import nl.basjes.modbus.schema.expression.strings.StringExpression;
import nl.basjes.modbus.schema.expression.strings.StringFromBoolean;
import nl.basjes.modbus.schema.expression.strings.StringFromNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R$\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0014\u00a8\u0006%"}, d2={"Lnl/basjes/modbus/schema/expression/strings/StringField;", "Lnl/basjes/modbus/schema/expression/strings/StringExpression;", "fieldName", "", "<init>", "(Ljava/lang/String;)V", "getFieldName", "()Ljava/lang/String;", "field", "Lnl/basjes/modbus/schema/Field;", "fieldExpression", "toString", "isTop", "", "initialize", "containingField", "subExpressions", "", "Lnl/basjes/modbus/schema/expression/Expression;", "getSubExpressions", "()Ljava/util/List;", "requiredFields", "getRequiredFields", "requiredAddresses", "Lnl/basjes/modbus/device/api/Address;", "getRequiredAddresses", "value", "isImmutable", "()Z", "setImmutable", "(Z)V", "problems", "Lnl/basjes/modbus/schema/expression/Expression$Problem;", "getProblems", "getValue", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbus-schema-device"})
public final class StringField
implements StringExpression {
    @NotNull
    private final String fieldName;
    private Field field;
    @NotNull
    private StringExpression fieldExpression;

    public StringField(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        this.fieldName = fieldName;
        this.fieldExpression = new MissingField(this.fieldName);
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public String toString() {
        return this.toString(true);
    }

    @Override
    @NotNull
    public String toString(boolean isTop) {
        return this.fieldName;
    }

    @Override
    public boolean initialize(@NotNull Field containingField) {
        Expression expression;
        Expression expression2;
        Intrinsics.checkNotNullParameter((Object)containingField, (String)"containingField");
        Block block = containingField.getBlock();
        Field retrievedField = block.getField(this.fieldName);
        if (retrievedField == null) {
            return false;
        }
        this.field = retrievedField;
        Field field = this.field;
        if (field == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"field");
            field = null;
        }
        if ((expression2 = (expression = field.getParsedExpression())) instanceof StringExpression) {
            this.fieldExpression = (StringExpression)expression;
            return true;
        }
        if (expression2 instanceof NumericalExpression) {
            this.fieldExpression = new StringFromNumber((NumericalExpression)expression);
            return true;
        }
        if (expression2 instanceof BooleanExpression) {
            this.fieldExpression = new StringFromBoolean((BooleanExpression)expression, "false", "true");
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Expression> getSubExpressions() {
        return CollectionsKt.listOf((Object)this.fieldExpression);
    }

    @Override
    @NotNull
    public List<String> getRequiredFields() {
        return CollectionsKt.listOf((Object)this.fieldName);
    }

    @Override
    @NotNull
    public List<Address> getRequiredAddresses() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isImmutable() {
        return this.fieldExpression.isImmutable();
    }

    @Override
    public void setImmutable(boolean value) {
        this.fieldExpression.setImmutable(value);
    }

    @Override
    @NotNull
    public List<Expression.Problem> getProblems() {
        List[] listArray = new List[]{StringExpression.super.getProblems()};
        return this.combine("StringField", listArray);
    }

    @Override
    @Nullable
    public String getValue(@NotNull SchemaDevice schemaDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        return this.fieldExpression.getValue(schemaDevice);
    }

    @Override
    @NotNull
    public ReturnType getReturnType() {
        return StringExpression.super.getReturnType();
    }

    @Override
    @NotNull
    public List<Address> getRequiredMutableAddresses() {
        return StringExpression.super.getRequiredMutableAddresses();
    }

    @Override
    @NotNull
    public List<ModbusValue<?, ?>> getModbusValues(@NotNull SchemaDevice schemaDevice) {
        return StringExpression.super.getModbusValues(schemaDevice);
    }

    @Override
    @NotNull
    public List<Expression.Problem> check(boolean condition, @NotNull String explain) {
        return StringExpression.super.check(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> checkFatal(boolean condition, @NotNull String explain) {
        return StringExpression.super.checkFatal(condition, explain);
    }

    @Override
    @NotNull
    public List<Expression.Problem> combine(@NotNull String function, List<? extends Expression.Problem> ... problems) {
        return StringExpression.super.combine(function, problems);
    }
}

