/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.modbus.schema.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import nl.basjes.modbus.device.api.Address;
import nl.basjes.modbus.device.api.AddressClass;
import nl.basjes.modbus.device.api.DiscreteBlock;
import nl.basjes.modbus.device.api.DiscreteValue;
import nl.basjes.modbus.device.api.ModbusBlock;
import nl.basjes.modbus.device.api.ModbusDevice;
import nl.basjes.modbus.device.api.ModbusValue;
import nl.basjes.modbus.device.api.RegisterBlock;
import nl.basjes.modbus.device.api.RegisterValue;
import nl.basjes.modbus.device.exception.ModbusApiException;
import nl.basjes.modbus.device.exception.ModbusException;
import nl.basjes.modbus.schema.Block;
import nl.basjes.modbus.schema.Field;
import nl.basjes.modbus.schema.SchemaDevice;
import nl.basjes.modbus.schema.fetcher.MergedModbusQuery;
import nl.basjes.modbus.schema.fetcher.ModbusQuery;
import nl.basjes.modbus.schema.fetcher.OptimizingModbusBlockFetcherKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J,\u0010\u001d\u001a\u00020\u001e*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f2\u0012\u0010 \u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher;", "", "schemaDevice", "Lnl/basjes/modbus/schema/SchemaDevice;", "modbusDevice", "Lnl/basjes/modbus/device/api/ModbusDevice;", "<init>", "(Lnl/basjes/modbus/schema/SchemaDevice;Lnl/basjes/modbus/device/api/ModbusDevice;)V", "getSchemaDevice", "()Lnl/basjes/modbus/schema/SchemaDevice;", "getModbusDevice", "()Lnl/basjes/modbus/device/api/ModbusDevice;", "calculateFetchGroupToAddressesMapping", "", "", "", "Lnl/basjes/modbus/device/api/Address;", "update", "", "Lnl/basjes/modbus/schema/fetcher/ModbusQuery;", "field", "Lnl/basjes/modbus/schema/Field;", "getDiscretes", "Lnl/basjes/modbus/device/api/DiscreteBlock;", "modbusQuery", "getRegisters", "Lnl/basjes/modbus/device/api/RegisterBlock;", "maxAge", "", "mergeFetched", "", "Lnl/basjes/modbus/device/api/ModbusBlock;", "fetchedModbusBlock", "fetch", "calculateModbusQueries", "Companion", "modbus-schema-device"})
@SourceDebugExtension(value={"SMAP\nModbusBlockFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n1#2:347\n1869#3,2:348\n1761#3,3:350\n1869#3,2:353\n1761#3,3:355\n1869#3,2:358\n1761#3,3:360\n1563#3:363\n1634#3,3:364\n1563#3:367\n1634#3,3:368\n774#3:371\n865#3,2:372\n774#3:374\n865#3,2:375\n1869#3,2:377\n1869#3,2:379\n1563#3:381\n1634#3,3:382\n295#3,2:385\n*S KotlinDebug\n*F\n+ 1 ModbusBlockFetcher.kt\nnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher\n*L\n102#1:348,2\n121#1:350,3\n124#1:353,2\n133#1:355,3\n136#1:358,2\n216#1:360,3\n228#1:363\n228#1:364,3\n234#1:367\n234#1:368,3\n236#1:371\n236#1:372,2\n237#1:374\n237#1:375,2\n238#1:377,2\n282#1:379,2\n315#1:381\n315#1:382,3\n316#1:385,2\n*E\n"})
public class ModbusBlockFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaDevice schemaDevice;
    @NotNull
    private final ModbusDevice modbusDevice;
    @NotNull
    private static final Logger LOG;

    public ModbusBlockFetcher(@NotNull SchemaDevice schemaDevice, @NotNull ModbusDevice modbusDevice) {
        Intrinsics.checkNotNullParameter((Object)schemaDevice, (String)"schemaDevice");
        Intrinsics.checkNotNullParameter((Object)modbusDevice, (String)"modbusDevice");
        this.schemaDevice = schemaDevice;
        this.modbusDevice = modbusDevice;
    }

    @NotNull
    protected final SchemaDevice getSchemaDevice() {
        return this.schemaDevice;
    }

    @NotNull
    protected final ModbusDevice getModbusDevice() {
        return this.modbusDevice;
    }

    private final Map<String, List<Address>> calculateFetchGroupToAddressesMapping() {
        Map fetchGroupToAddresses = new TreeMap();
        for (Block entry : this.schemaDevice.getBlocks()) {
            for (Field field : entry.getFields()) {
                String fieldFetchGroup = field.getFetchGroup();
                boolean fieldImmutable = field.isImmutable();
                List<Address> requiredAddresses = field.getRequiredAddresses();
                for (Address requiredAddress : requiredAddresses) {
                    ModbusValue modbusValue = this.schemaDevice.getModbusBlock(requiredAddress.getAddressClass()).getOrCreateIfAbsent(requiredAddress);
                    modbusValue.setImmutable(fieldImmutable);
                    modbusValue.setFetchGroup(fieldFetchGroup);
                }
                fetchGroupToAddresses.computeIfAbsent(fieldFetchGroup, arg_0 -> ModbusBlockFetcher.calculateFetchGroupToAddressesMapping$lambda$1(ModbusBlockFetcher::calculateFetchGroupToAddressesMapping$lambda$0, arg_0)).addAll((Collection)requiredAddresses);
            }
        }
        for (Map.Entry entry : fetchGroupToAddresses.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            List fetchGroupAddresses = CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)value)));
            if (fetchGroupAddresses.isEmpty()) continue;
            Address firstAddress = (Address)fetchGroupAddresses.get(0);
            int numberOfAddresses = fetchGroupAddresses.size();
            Address lastAddress = (Address)fetchGroupAddresses.get(numberOfAddresses - 1);
            if (Intrinsics.areEqual((Object)firstAddress.increment(numberOfAddresses - 1), (Object)lastAddress)) continue;
            boolean bl = false;
            String string = "There are gaps in the addresses for fetch group \"" + key + "\": " + fetchGroupAddresses;
            throw new IllegalStateException(string.toString());
        }
        return fetchGroupToAddresses;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<ModbusQuery> update(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!field.getInitialized()) {
            $i$a$-require-ModbusBlockFetcher$update$1 = false;
            $i$a$-require-ModbusBlockFetcher$update$1 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
            throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$update$1.toString());
        }
        if (field.isUsingHardReadErrorRegisters()) {
            return CollectionsKt.emptyList();
        }
        fetched = new ArrayList<E>();
        $this$forEach$iv = field.getRequiredFields();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Field)element$iv;
            $i$a$-forEach-ModbusBlockFetcher$update$2 = false;
            fetched.addAll((Collection)it.update());
        }
        fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        requiredRegisters = fetchGroupToAddresses.get(field.getFetchGroup());
        var5_8 = requiredRegisters;
        if (var5_8 == null || var5_8.isEmpty() != false) {
            requiredRegisters = field.getRequiredAddresses();
        }
        if (requiredRegisters.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        modbusQuery = new ModbusQuery(requiredRegisters.get(0), requiredRegisters.size());
        modbusQuery.getFields().add(field);
        switch (WhenMappings.$EnumSwitchMapping$0[modbusQuery.getType().ordinal()]) {
            case 1: {
                deviceDiscretes = this.getDiscretes(this.modbusDevice, modbusQuery);
                $this$any$iv = deviceDiscretes.getValues();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl36
                v0 = false;
                ** GOTO lbl43
lbl36:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (DiscreteValue)element$iv;
                    $i$a$-any-ModbusBlockFetcher$update$3 = false;
                    if (!it.isReadError()) continue;
                    v0 = true;
                    ** GOTO lbl43
                }
                v0 = false;
lbl43:
                // 3 sources

                if (v0) {
                    modbusQuery.setStatus(ModbusQuery.Status.ERROR);
                    $this$forEach$iv = deviceDiscretes.getValues();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (DiscreteValue)element$iv;
                        $i$a$-forEach-ModbusBlockFetcher$update$4 = false;
                        it.setHardReadError();
                    }
                }
                if (!((modbusBlock = this.schemaDevice.getModbusBlock(deviceDiscretes.getAddressClass())) instanceof DiscreteBlock)) {
                    $i$a$-require-ModbusBlockFetcher$update$5 = false;
                    $i$a$-require-ModbusBlockFetcher$update$5 = "This should never fail";
                    throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$update$5.toString());
                }
                ((DiscreteBlock)modbusBlock).merge((ModbusBlock)deviceDiscretes);
                break;
            }
            case 2: {
                deviceRegisters = this.getRegisters(this.modbusDevice, modbusQuery);
                $this$any$iv = deviceRegisters.getValues();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl66
                v1 = false;
                ** GOTO lbl73
lbl66:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (RegisterValue)element$iv;
                    $i$a$-any-ModbusBlockFetcher$update$6 = false;
                    if (!it.isReadError()) continue;
                    v1 = true;
                    ** GOTO lbl73
                }
                v1 = false;
lbl73:
                // 3 sources

                if (v1) {
                    modbusQuery.setStatus(ModbusQuery.Status.ERROR);
                    $this$forEach$iv = deviceRegisters.getValues();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (RegisterValue)element$iv;
                        $i$a$-forEach-ModbusBlockFetcher$update$7 = false;
                        it.setHardReadError();
                    }
                }
                if (!((modbusBlock = this.schemaDevice.getModbusBlock(deviceRegisters.getAddressClass())) instanceof RegisterBlock)) {
                    $i$a$-require-ModbusBlockFetcher$update$8 = false;
                    var11_23 = "This should never fail";
                    throw new IllegalArgumentException(var11_23.toString());
                }
                ((RegisterBlock)modbusBlock).merge((ModbusBlock)deviceRegisters);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        fetched.add(modbusQuery);
        return fetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DiscreteBlock getDiscretes(@NotNull ModbusDevice $this$getDiscretes, @NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiscretes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            DiscreteBlock discreteBlock = $this$getDiscretes.getDiscretes(modbusQuery.getStart(), modbusQuery.getCount());
            modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
            DiscreteBlock discreteBlock2 = discreteBlock;
            return discreteBlock2;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RegisterBlock getRegisters(@NotNull ModbusDevice $this$getRegisters, @NotNull ModbusQuery modbusQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getRegisters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modbusQuery, (String)"modbusQuery");
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            RegisterBlock registerBlock = $this$getRegisters.getRegisters(modbusQuery.getStart(), modbusQuery.getCount());
            modbusQuery.setStatus(ModbusQuery.Status.SUCCESS);
            RegisterBlock registerBlock2 = registerBlock;
            return registerBlock2;
        }
        catch (ModbusException modbusException) {
            modbusQuery.setStatus(ModbusQuery.Status.ERROR);
            throw modbusException;
        }
        finally {
            long stop = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            modbusQuery.setDuration-BwNAW2A(Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)stop, (long)start)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update(long maxAge) {
        ModbusBlockFetcher modbusBlockFetcher = this;
        synchronized (modbusBlockFetcher) {
            boolean bl = false;
            List fetched = new ArrayList();
            for (ModbusQuery fetchBatch : this.calculateModbusQueries(maxAge)) {
                fetched.addAll((Collection)this.fetch(fetchBatch));
            }
            List list = fetched;
            return list;
        }
    }

    public static /* synthetic */ List update$default(ModbusBlockFetcher modbusBlockFetcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return modbusBlockFetcher.update(l);
    }

    private final void mergeFetched(ModbusBlock<?, ?, ?> $this$mergeFetched, ModbusBlock<?, ?, ?> fetchedModbusBlock) {
        ModbusBlock<?, ?, ?> modbusBlock = $this$mergeFetched;
        if (modbusBlock instanceof DiscreteBlock && fetchedModbusBlock instanceof DiscreteBlock) {
            ((DiscreteBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else if (modbusBlock instanceof RegisterBlock && fetchedModbusBlock instanceof RegisterBlock) {
            ((RegisterBlock)$this$mergeFetched).merge(fetchedModbusBlock);
        } else {
            throw new ModbusApiException("Type mismatch existingModbusBlock (" + $this$mergeFetched.getClass().getName() + ") and fetchedModbusBlock (" + fetchedModbusBlock.getClass().getName() + ")", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModbusQuery> fetch(ModbusQuery modbusQuery) {
        List fetched = new ArrayList();
        try {
            ModbusValue it;
            Object element$iv3;
            boolean bl;
            ModbusBlock<?, ?, ?> existingModbusBlock;
            ModbusBlock fetchedModbusBlock;
            block24: {
                ModbusBlock modbusBlock;
                switch (WhenMappings.$EnumSwitchMapping$0[modbusQuery.getType().ordinal()]) {
                    case 1: {
                        modbusBlock = (ModbusBlock)this.getDiscretes(this.modbusDevice, modbusQuery);
                        break;
                    }
                    case 2: {
                        modbusBlock = (ModbusBlock)this.getRegisters(this.modbusDevice, modbusQuery);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                fetchedModbusBlock = modbusBlock;
                fetched.add(modbusQuery);
                existingModbusBlock = this.schemaDevice.getModbusBlock(fetchedModbusBlock.getAddressClass());
                this.mergeFetched(existingModbusBlock, fetchedModbusBlock);
                Iterable $this$any$iv = fetchedModbusBlock.getValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv3 = iterator.next();
                        it = (ModbusValue)element$iv3;
                        boolean bl2 = false;
                        if (!it.isReadError()) continue;
                        bl = true;
                        break block24;
                    }
                    bl = false;
                }
            }
            if (bl) {
                modbusQuery.setStatus(ModbusQuery.Status.ERROR);
                if (modbusQuery instanceof MergedModbusQuery) {
                    void $this$forEach$iv;
                    Object element$iv$iv;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Object it2;
                    Collection collection;
                    Comparable<Field> comparable;
                    Iterable $this$mapTo$iv$iv;
                    for (ModbusQuery fetchPart : ((MergedModbusQuery)modbusQuery).getModbusQueries()) {
                        fetched.addAll((Collection)this.fetch(fetchPart));
                    }
                    Iterable $this$map$iv = modbusQuery.getFields();
                    boolean $i$f$map = false;
                    element$iv3 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        comparable = (Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(((Field)it2).getBlock());
                    }
                    List blocks = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    $this$map$iv = blocks;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (Block)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(((Block)it2).getFields());
                    }
                    $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it2 = (Field)element$iv$iv;
                        boolean bl5 = false;
                        if (!(!modbusQuery.getFields().contains(it2))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = iterator.next();
                        it2 = (Field)element$iv$iv;
                        boolean bl6 = false;
                        if (!OptimizingModbusBlockFetcherKt.overlaps(((Field)it2).getRequiredAddresses(), modbusQuery.getStart(), modbusQuery.getCount())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        Field it3 = (Field)element$iv2;
                        boolean bl7 = false;
                        fetched.addAll((Collection)it3.update());
                    }
                    List holes = new ArrayList();
                    int $this$filterTo$iv$iv2 = modbusQuery.getCount();
                    for (int index = 0; index < $this$filterTo$iv$iv2; ++index) {
                        ModbusValue modbusValue = existingModbusBlock.get(modbusQuery.getStart().increment(index));
                        if (!modbusValue.isReadError() || modbusValue.getHardReadError()) continue;
                        holes.add(modbusValue);
                    }
                    if (!((Collection)holes).isEmpty()) {
                        List holeQueries = new ArrayList();
                        ModbusValue previousHole = (ModbusValue)holes.get(0);
                        ModbusQuery holeQuery = new ModbusQuery(previousHole.getAddress(), 1);
                        int bl7 = holes.size();
                        for (int holeIndex = 1; holeIndex < bl7; ++holeIndex) {
                            ModbusValue hole = (ModbusValue)holes.get(holeIndex);
                            if (Intrinsics.areEqual((Object)previousHole.getAddress().increment(1), (Object)hole.getAddress())) {
                                comparable = holeQuery;
                                int n = ((ModbusQuery)comparable).getCount();
                                ((ModbusQuery)comparable).setCount(n + 1);
                            } else {
                                holeQueries.add(holeQuery);
                                holeQuery = new ModbusQuery(hole.getAddress(), 1);
                            }
                            previousHole = hole;
                        }
                        holeQueries.add(holeQuery);
                        for (ModbusQuery holeQuery2 : holeQueries) {
                            fetched.addAll((Collection)this.fetch(holeQuery2));
                        }
                    }
                    return fetched;
                }
                Iterable $this$forEach$iv = fetchedModbusBlock.getValues();
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    it = (ModbusValue)element$iv3;
                    boolean bl8 = false;
                    it.setHardReadError();
                }
                this.mergeFetched(existingModbusBlock, fetchedModbusBlock);
            }
        }
        catch (ModbusException me) {
            LOG.error("Got ModbusException on {} --> {}", (Object)modbusQuery, (Object)me);
        }
        return CollectionsKt.listOf((Object)modbusQuery);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ModbusQuery> calculateModbusQueries(long maxAge) {
        long now = System.currentTimeMillis();
        List fieldsThatMustBeUpdated = new ArrayList();
        for (Field field : this.schemaDevice.neededFields()) {
            Object v0;
            block6: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                if (!field.getInitialized()) {
                    boolean $i$a$-require-ModbusBlockFetcher$calculateModbusQueries$22 = false;
                    String $i$a$-require-ModbusBlockFetcher$calculateModbusQueries$22 = "You cannot fetch the registers for a Field if the field has not yet been initialized. (Field ID=" + field.getId() + ")";
                    throw new IllegalArgumentException($i$a$-require-ModbusBlockFetcher$calculateModbusQueries$22.toString());
                }
                List<Address> requiredRegisters = field.getRequiredAddresses();
                if (requiredRegisters.isEmpty()) continue;
                ModbusBlock<?, ?, ?> registerBlock = this.schemaDevice.getModbusBlock(requiredRegisters.get(0).getAddressClass());
                Iterable iterable = requiredRegisters;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Address address = (Address)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(registerBlock.get((Address)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ModbusValue it = (ModbusValue)element$iv;
                    boolean bl = false;
                    if (!it.needsToBeUpdated(now, maxAge)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            if (v0 == null) continue;
            fieldsThatMustBeUpdated.add(field);
        }
        Map<String, List<Address>> fetchGroupToAddresses = this.calculateFetchGroupToAddressesMapping();
        Map fetchBatchesMap = new TreeMap();
        for (Field field : fieldsThatMustBeUpdated) {
            List<Address> addresses;
            ModbusQuery fetchBatch = (ModbusQuery)fetchBatchesMap.get(field.getFetchGroup());
            if (fetchBatch != null) {
                fetchBatch.getFields().add(field);
                continue;
            }
            Intrinsics.checkNotNull(fetchGroupToAddresses.get(field.getFetchGroup()));
            fetchBatch = new ModbusQuery(addresses.get(0), addresses.size());
            fetchBatch.getFields().add(field);
            fetchBatchesMap.put(field.getFetchGroup(), fetchBatch);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)fetchBatchesMap.values()));
    }

    @JvmOverloads
    @NotNull
    public final List<ModbusQuery> update() {
        return ModbusBlockFetcher.update$default(this, 0L, 1, null);
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List calculateFetchGroupToAddressesMapping$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnl/basjes/modbus/schema/fetcher/ModbusBlockFetcher$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "modbus-schema-device"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressClass.Type.values().length];
            try {
                nArray[AddressClass.Type.DISCRETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressClass.Type.REGISTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

